/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.notification;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.spi.Notification;
import io.digdag.spi.NotificationException;
import io.digdag.spi.NotificationSender;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ShellNotificationSender
implements NotificationSender {
    private static final String NOTIFICATION_SHELL_COMMAND = "notification.shell.command";
    private static final String NOTIFICATION_SHELL_TIMEOUT = "notification.shell.timeout";
    private static final int NOTIFICATION_SHELL_TIMEOUT_DEFAULT = 30000;
    private final String command;
    private final ObjectMapper mapper;
    private final int timeoutMs;

    @Inject
    public ShellNotificationSender(Config systemConfig, ObjectMapper mapper) {
        this.command = (String)systemConfig.get(NOTIFICATION_SHELL_COMMAND, String.class);
        this.mapper = mapper;
        this.timeoutMs = (Integer)systemConfig.get(NOTIFICATION_SHELL_TIMEOUT, Integer.TYPE, (Object)30000);
    }

    public void sendNotification(Notification notification) throws NotificationException {
        byte[] notificationJson;
        try {
            notificationJson = this.mapper.writeValueAsBytes((Object)notification);
        }
        catch (JsonProcessingException e) {
            throw ThrowablesUtil.propagate((Throwable)e);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        File devNull = new File("/dev/null");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).redirectOutput(devNull).redirectError(devNull).redirectInput(ProcessBuilder.Redirect.PIPE).command("/bin/sh", "-c", this.command);
        try {
            Process process = processBuilder.start();
            executor.execute(() -> {
                try {
                    OutputStream stream = process.getOutputStream();
                    ByteStreams.copy((InputStream)new ByteArrayInputStream(notificationJson), (OutputStream)stream);
                    stream.flush();
                    stream.close();
                }
                catch (IOException e) {
                    throw ThrowablesUtil.propagate((Throwable)e);
                }
            });
            boolean exited = process.waitFor(this.timeoutMs, TimeUnit.MILLISECONDS);
            if (!exited) {
                process.destroyForcibly();
                throw new NotificationException("Notification shell command timed out: " + this.command);
            }
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new NotificationException("Notification shell command failed: " + this.command + ", exit code = " + exitCode);
            }
        }
        catch (IOException e) {
            throw new NotificationException("Failed to execute notification shell command: " + this.command, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw ThrowablesUtil.propagate((Throwable)e);
        }
    }
}

