/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.log;

import com.google.common.base.Optional;
import io.digdag.core.log.LogFiles;
import io.digdag.spi.DirectDownloadHandle;
import io.digdag.spi.DirectUploadHandle;
import io.digdag.spi.ImmutableLogFileHandle;
import io.digdag.spi.LogFileHandle;
import io.digdag.spi.LogFilePrefix;
import io.digdag.spi.LogServer;
import io.digdag.spi.StorageFileNotFoundException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFileLogServer
implements LogServer {
    public abstract Optional<DirectUploadHandle> getDirectUploadHandle(String var1, String var2, String var3);

    protected abstract void putFile(String var1, String var2, String var3, byte[] var4);

    protected abstract byte[] getFile(String var1, String var2, String var3) throws StorageFileNotFoundException;

    protected abstract void listFiles(String var1, String var2, boolean var3, FileMetadataConsumer var4);

    public Optional<DirectUploadHandle> getDirectUploadHandle(LogFilePrefix prefix, String taskName, Instant firstLogTime, String agentId) {
        String dateDir = LogFiles.formatDataDir(prefix);
        String attemptDir = LogFiles.formatSessionAttemptDir(prefix);
        String fileName = LogFiles.formatFileName(taskName, firstLogTime, agentId);
        return this.getDirectUploadHandle(dateDir, attemptDir, fileName);
    }

    public String putFile(LogFilePrefix prefix, String taskName, Instant firstLogTime, String agentId, byte[] gzData) {
        String dateDir = LogFiles.formatDataDir(prefix);
        String attemptDir = LogFiles.formatSessionAttemptDir(prefix);
        String fileName = LogFiles.formatFileName(taskName, firstLogTime, agentId);
        this.putFile(dateDir, attemptDir, fileName, gzData);
        return fileName;
    }

    public byte[] getFile(LogFilePrefix prefix, String fileName) throws StorageFileNotFoundException {
        String dateDir = LogFiles.formatDataDir(prefix);
        String attemptDir = LogFiles.formatSessionAttemptDir(prefix);
        return this.getFile(dateDir, attemptDir, fileName);
    }

    public List<LogFileHandle> getFileHandles(LogFilePrefix prefix, Optional<String> taskName, boolean enableDirectDownload) {
        String dateDir = LogFiles.formatDataDir(prefix);
        String attemptDir = LogFiles.formatSessionAttemptDir(prefix);
        ArrayList<LogFileHandle> handles = new ArrayList<LogFileHandle>();
        this.listFiles(dateDir, attemptDir, enableDirectDownload, (name, size, direct) -> {
            LogFileHandle handle;
            if (name.endsWith(".log.gz") && (!taskName.isPresent() || name.startsWith((String)taskName.get())) && (handle = LogFiles.buildLogFileHandleFromFileName(name, size)) != null) {
                if (direct != null) {
                    handles.add((LogFileHandle)ImmutableLogFileHandle.builder().from(handle).direct(Optional.of((Object)direct)).build());
                } else {
                    handles.add(handle);
                }
            }
        });
        LogFiles.sortLogFileHandles(handles);
        return handles;
    }

    public static interface FileMetadataConsumer {
        public void accept(String var1, long var2, DirectDownloadHandle var4);
    }
}

