/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database.migrate;

import io.digdag.core.database.migrate.MigrationContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.skife.jdbi.v2.Handle;

public interface Migration {
    public static final Pattern MIGRATION_NAME_PATTERN = Pattern.compile("Migration_([0-9]{14})_([A-Za-z0-9]+)");

    default public String getVersion() {
        Matcher m = MIGRATION_NAME_PATTERN.matcher(this.getClass().getSimpleName());
        if (!m.matches()) {
            throw new AssertionError((Object)("Invalid migration class name: " + this.getClass().getSimpleName()));
        }
        return m.group(1);
    }

    default public boolean noTransaction(MigrationContext context) {
        return false;
    }

    public void migrate(Handle var1, MigrationContext var2);
}

