/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database.migrate;

import io.digdag.core.database.DatabaseConfig;
import java.util.ArrayList;
import java.util.List;

public class CreateTableBuilder {
    private final String databaseType;
    private final String name;
    private final List<String> columns = new ArrayList<String>();

    CreateTableBuilder(String databaseType, String name) {
        this.databaseType = databaseType;
        this.name = name;
    }

    private boolean isPostgres() {
        return DatabaseConfig.isPostgres(this.databaseType);
    }

    public CreateTableBuilder add(String column, String typeAndOptions) {
        this.columns.add(column + " " + typeAndOptions);
        return this;
    }

    public CreateTableBuilder addIntId(String column) {
        if (this.isPostgres()) {
            return this.add(column, "serial primary key");
        }
        return this.add(column, "int primary key AUTO_INCREMENT");
    }

    public CreateTableBuilder addIntIdNoAutoIncrement(String column, String options) {
        if (this.isPostgres()) {
            return this.add(column, "serial primary key " + options);
        }
        return this.add(column, "int primary key AUTO_INCREMENT " + options);
    }

    public CreateTableBuilder addLongId(String column) {
        if (this.isPostgres()) {
            return this.add(column, "bigserial primary key");
        }
        return this.add(column, "bigint primary key AUTO_INCREMENT");
    }

    public CreateTableBuilder addLongIdNoAutoIncrement(String column, String options) {
        return this.add(column, "bigint primary key " + options);
    }

    public CreateTableBuilder addShort(String column, String options) {
        return this.add(column, "smallint " + options);
    }

    public CreateTableBuilder addInt(String column, String options) {
        return this.add(column, "int " + options);
    }

    public CreateTableBuilder addLong(String column, String options) {
        return this.add(column, "bigint " + options);
    }

    public CreateTableBuilder addUuid(String column, String options) {
        return this.add(column, "uuid " + options);
    }

    public CreateTableBuilder addString(String column, String options) {
        if (this.isPostgres()) {
            return this.add(column, "text " + options);
        }
        return this.add(column, "varchar(255) " + options);
    }

    public CreateTableBuilder addMediumText(String column, String options) {
        return this.add(column, "text " + options);
    }

    public CreateTableBuilder addLongText(String column, String options) {
        return this.add(column, "text " + options);
    }

    public CreateTableBuilder addBinary(String column, String options) {
        if (this.isPostgres()) {
            return this.add(column, "bytea " + options);
        }
        return this.add(column, "varbinary(255) " + options);
    }

    public CreateTableBuilder addLongBinary(String column, String options) {
        if (this.isPostgres()) {
            return this.add(column, "bytea " + options);
        }
        return this.add(column, "blob " + options);
    }

    public CreateTableBuilder addTimestamp(String column, String options) {
        if (this.isPostgres()) {
            return this.add(column, "timestamp with time zone " + options);
        }
        return this.add(column, "timestamp " + options);
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + this.name + " (\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            sb.append("  ");
            sb.append(this.columns.get(i));
            if (i + 1 < this.columns.size()) {
                sb.append(",\n");
                continue;
            }
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }
}

