/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.database.ImmutableDatabaseConfig;
import io.digdag.core.database.RemoteDatabaseConfig;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.immutables.value.Value;

@Value.Immutable
public interface DatabaseConfig {
    public String getType();

    public Optional<String> getPath();

    public Map<String, String> getOptions();

    public Optional<RemoteDatabaseConfig> getRemoteDatabaseConfig();

    public int getExpireLockInterval();

    public boolean getAutoMigrate();

    public int getConnectionTimeout();

    public int getIdleTimeout();

    public int getKeepaliveTime();

    public int getMaximumPoolSize();

    public int getMinimumPoolSize();

    public int getValidationTimeout();

    public boolean getEnableJMX();

    public long getLeakDetectionThreshold();

    public static ImmutableDatabaseConfig.Builder builder() {
        return ImmutableDatabaseConfig.builder();
    }

    public static DatabaseConfig convertFrom(Config config) {
        return DatabaseConfig.convertFrom(config, "database");
    }

    public static DatabaseConfig convertFrom(Config config, String keyPrefix) {
        String type;
        ImmutableDatabaseConfig.Builder builder = DatabaseConfig.builder();
        switch (type = (String)config.get(keyPrefix + ".type", String.class, (Object)"memory")) {
            case "h2": {
                builder.type("h2");
                builder.path((Optional<String>)Optional.of((Object)((String)config.get(keyPrefix + ".path", String.class))));
                builder.remoteDatabaseConfig((Optional<RemoteDatabaseConfig>)Optional.absent());
                break;
            }
            case "memory": {
                builder.type("h2");
                builder.path((Optional<String>)Optional.absent());
                builder.remoteDatabaseConfig((Optional<RemoteDatabaseConfig>)Optional.absent());
                break;
            }
            case "postgresql": {
                builder.type("postgresql");
                builder.remoteDatabaseConfig((Optional<RemoteDatabaseConfig>)Optional.of((Object)RemoteDatabaseConfig.builder().user((String)config.get(keyPrefix + ".user", String.class)).password((String)config.get(keyPrefix + ".password", String.class, (Object)"")).host((String)config.get(keyPrefix + ".host", String.class)).port((Optional<Integer>)config.getOptional(keyPrefix + ".port", Integer.class)).database((String)config.get(keyPrefix + ".database", String.class)).loginTimeout((Integer)config.get(keyPrefix + ".loginTimeout", Integer.TYPE, (Object)30)).socketTimeout((Integer)config.get(keyPrefix + ".socketTimeout", Integer.TYPE, (Object)1800)).ssl((Boolean)config.get(keyPrefix + ".ssl", Boolean.TYPE, (Object)false)).sslfactory((String)config.get(keyPrefix + ".sslfactory", String.class, (Object)"org.postgresql.ssl.NonValidatingFactory")).sslmode((Optional<String>)config.getOptional(keyPrefix + ".sslmode", String.class)).sslcert((Optional<String>)config.getOptional(keyPrefix + ".sslcert", String.class)).sslkey((Optional<String>)config.getOptional(keyPrefix + ".sslkey", String.class)).sslrootcert((Optional<String>)config.getOptional(keyPrefix + ".sslrootcert", String.class)).build()));
                break;
            }
            default: {
                throw new ConfigException("Unknown database.type: " + type);
            }
        }
        builder.connectionTimeout((Integer)config.get(keyPrefix + ".connectionTimeout", Integer.TYPE, (Object)30));
        builder.idleTimeout((Integer)config.get(keyPrefix + ".idleTimeout", Integer.TYPE, (Object)600));
        builder.keepaliveTime((Integer)config.get(keyPrefix + ".keepaliveTime", Integer.TYPE, (Object)0));
        builder.validationTimeout((Integer)config.get(keyPrefix + ".validationTimeout", Integer.TYPE, (Object)5));
        int maximumPoolSize = (Integer)config.get(keyPrefix + ".maximumPoolSize", Integer.TYPE, (Object)(Runtime.getRuntime().availableProcessors() * 32));
        builder.maximumPoolSize(maximumPoolSize);
        builder.minimumPoolSize((Integer)config.get(keyPrefix + ".minimumPoolSize", Integer.TYPE, (Object)maximumPoolSize));
        builder.enableJMX(DatabaseConfig.isJMXEnable(config));
        builder.leakDetectionThreshold((Long)config.get(keyPrefix + ".leakDetectionThreshold", Long.TYPE, (Object)0L));
        ImmutableMap.Builder options = ImmutableMap.builder();
        for (String key : config.getKeys()) {
            String optionKey;
            if (!key.startsWith(optionKey = keyPrefix + ".opts.")) continue;
            options.put((Object)key.substring(optionKey.length()), (Object)((String)config.get(key, String.class)));
        }
        builder.options((Map<String, ? extends String>)options.build());
        builder.autoMigrate((Boolean)config.get(keyPrefix + ".migrate", Boolean.TYPE, (Object)true));
        builder.expireLockInterval((Integer)config.get(keyPrefix + ".queue.expireLockInterval", Integer.TYPE, (Object)10));
        return builder.build();
    }

    public static boolean isJMXEnable(Config config) {
        return (Boolean)config.getOptional("server.jmx.port", Integer.class).transform(port -> true).or((Object)false);
    }

    public static Config toConfig(DatabaseConfig databaseConfig, ConfigFactory cf) {
        return DatabaseConfig.toConfig(databaseConfig, cf, "database");
    }

    public static Config toConfig(DatabaseConfig databaseConfig, ConfigFactory cf, String keyPrefix) {
        Config config = cf.create();
        config.set(keyPrefix + ".type", (Object)databaseConfig.getType());
        switch (databaseConfig.getType()) {
            case "h2": {
                config.setOptional(keyPrefix + ".path", databaseConfig.getPath());
                break;
            }
            case "memory": {
                break;
            }
            case "postgresql": {
                RemoteDatabaseConfig remoteDatabaseConfig = (RemoteDatabaseConfig)databaseConfig.getRemoteDatabaseConfig().orNull();
                if (!1.$assertionsDisabled && remoteDatabaseConfig == null) {
                    throw new AssertionError();
                }
                config.set(keyPrefix + ".user", (Object)remoteDatabaseConfig.getUser());
                config.set(keyPrefix + ".password", (Object)remoteDatabaseConfig.getPassword());
                config.set(keyPrefix + ".host", (Object)remoteDatabaseConfig.getHost());
                config.setOptional(keyPrefix + ".port", remoteDatabaseConfig.getPort());
                config.set(keyPrefix + ".database", (Object)remoteDatabaseConfig.getDatabase());
                config.set(keyPrefix + ".loginTimeout", (Object)remoteDatabaseConfig.getLoginTimeout());
                config.set(keyPrefix + ".socketTimeout", (Object)remoteDatabaseConfig.getSocketTimeout());
                config.set(keyPrefix + ".ssl", (Object)remoteDatabaseConfig.getSsl());
                config.set(keyPrefix + ".sslfactory", (Object)remoteDatabaseConfig.getSslfactory());
                config.setOptional(keyPrefix + ".sslmode", remoteDatabaseConfig.getSslmode());
                config.setOptional(keyPrefix + ".sslcert", remoteDatabaseConfig.getSslcert());
                config.setOptional(keyPrefix + ".sslkey", remoteDatabaseConfig.getSslkey());
                config.setOptional(keyPrefix + ".sslrootcert", remoteDatabaseConfig.getSslrootcert());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown database.type: " + databaseConfig.getType()));
            }
        }
        config.set(keyPrefix + ".connectionTimeout", (Object)databaseConfig.getConnectionTimeout());
        config.set(keyPrefix + ".keepaliveTime", (Object)databaseConfig.getKeepaliveTime());
        config.set(keyPrefix + ".idleTimeout", (Object)databaseConfig.getIdleTimeout());
        config.set(keyPrefix + ".validationTimeout", (Object)databaseConfig.getValidationTimeout());
        config.set(keyPrefix + ".maximumPoolSize", (Object)databaseConfig.getMaximumPoolSize());
        config.set(keyPrefix + ".minimumPoolSize", (Object)databaseConfig.getMinimumPoolSize());
        config.set(keyPrefix + ".enableJMX", (Object)databaseConfig.getEnableJMX());
        Map<String, String> options = databaseConfig.getOptions();
        for (String key : options.keySet()) {
            config.set(keyPrefix + ".opts." + key, (Object)options.get(key));
        }
        config.set(keyPrefix + ".migrate", (Object)databaseConfig.getAutoMigrate());
        config.set(keyPrefix + ".queue.expireLockInterval", (Object)databaseConfig.getExpireLockInterval());
        return config;
    }

    public static String buildJdbcUrl(DatabaseConfig config) {
        switch (config.getType()) {
            case "h2": {
                if (config.getRemoteDatabaseConfig().isPresent()) {
                    throw new IllegalArgumentException("Database type is h2 but remoteDatabaseConfig is not set unexpectedly");
                }
                if (config.getPath().isPresent()) {
                    Path dir = FileSystems.getDefault().getPath((String)config.getPath().get(), new String[0]);
                    try {
                        Files.createDirectories(dir, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        throw new ConfigException((Throwable)ex);
                    }
                    return String.format(Locale.ENGLISH, "jdbc:h2:%s", dir.resolve("digdag").toAbsolutePath().toString());
                }
                return String.format(Locale.ENGLISH, "jdbc:h2:mem:digdag-%s", UUID.randomUUID());
            }
            case "postgresql": {
                if (!config.getRemoteDatabaseConfig().isPresent()) {
                    throw new IllegalArgumentException("Database type is postgresql but remoteDatabaseConfig is not set unexpectedly");
                }
                RemoteDatabaseConfig remote = (RemoteDatabaseConfig)config.getRemoteDatabaseConfig().get();
                if (remote.getPort().isPresent()) {
                    return String.format(Locale.ENGLISH, "jdbc:postgresql://%s:%d/%s", remote.getHost(), remote.getPort().get(), remote.getDatabase());
                }
                return String.format(Locale.ENGLISH, "jdbc:postgresql://%s/%s", remote.getHost(), remote.getDatabase());
            }
        }
        throw new ConfigException("Unsupported database type: " + config.getType());
    }

    /*
     * WARNING - void declaration
     */
    public static Properties buildJdbcProperties(DatabaseConfig config) {
        void var4_7;
        Properties props = new Properties();
        Optional<RemoteDatabaseConfig> rc = config.getRemoteDatabaseConfig();
        String string = config.getType();
        int n = -1;
        switch (string.hashCode()) {
            case 3274: {
                if (!string.equals("h2")) break;
                boolean bl = false;
                break;
            }
            case -2105481388: {
                if (!string.equals("postgresql")) break;
                boolean bl = true;
            }
        }
        switch (var4_7) {
            case 0: {
                break;
            }
            case 1: {
                props.setProperty("loginTimeout", Integer.toString(((RemoteDatabaseConfig)rc.get()).getLoginTimeout()));
                props.setProperty("socketTimeout", Integer.toString(((RemoteDatabaseConfig)rc.get()).getSocketTimeout()));
                props.setProperty("tcpKeepAlive", "true");
                break;
            }
            default: {
                throw new ConfigException("Unsupported database type: " + config.getType());
            }
        }
        if (config.getRemoteDatabaseConfig().isPresent()) {
            props.setProperty("user", ((RemoteDatabaseConfig)rc.get()).getUser());
            props.setProperty("password", ((RemoteDatabaseConfig)rc.get()).getPassword());
            if (((RemoteDatabaseConfig)rc.get()).getSsl()) {
                props.setProperty("ssl", "true");
                props.setProperty("sslfactory", ((RemoteDatabaseConfig)rc.get()).getSslfactory());
                if (((RemoteDatabaseConfig)rc.get()).getSslmode().isPresent()) {
                    props.setProperty("sslmode", (String)((RemoteDatabaseConfig)rc.get()).getSslmode().get());
                }
                if (((RemoteDatabaseConfig)rc.get()).getSslcert().isPresent()) {
                    props.setProperty("sslcert", (String)((RemoteDatabaseConfig)rc.get()).getSslcert().get());
                }
                if (((RemoteDatabaseConfig)rc.get()).getSslkey().isPresent()) {
                    props.setProperty("sslkey", (String)((RemoteDatabaseConfig)rc.get()).getSslkey().get());
                }
                if (((RemoteDatabaseConfig)rc.get()).getSslrootcert().isPresent()) {
                    props.setProperty("sslrootcert", (String)((RemoteDatabaseConfig)rc.get()).getSslrootcert().get());
                }
            }
        }
        for (Map.Entry entry : config.getOptions().entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    public static boolean isPostgres(String databaseType) {
        return databaseType.equals("postgresql");
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

