/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.DatabaseMigrator;
import java.sql.SQLException;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProvider
implements Provider<DataSource>,
AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DatabaseConfig config;
    private DataSource ds;
    private AutoCloseable closer;

    @Inject
    public DataSourceProvider(DatabaseConfig config) {
        this.config = config;
    }

    public synchronized DataSource get() {
        if (this.ds == null) {
            switch (this.config.getType()) {
                case "h2": {
                    this.createSimpleDataSource();
                    break;
                }
                default: {
                    this.createPooledDataSource();
                }
            }
        }
        return this.ds;
    }

    private void createSimpleDataSource() {
        String url = DatabaseConfig.buildJdbcUrl(this.config);
        JdbcDataSource ds = new JdbcDataSource();
        ds.setUrl(url + ";DB_CLOSE_ON_EXIT=FALSE");
        this.logger.debug("Using database URL {}", (Object)url);
        try {
            this.closer = ds.getConnection();
        }
        catch (SQLException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
        this.ds = ds;
    }

    private void createPooledDataSource() {
        String url = DatabaseConfig.buildJdbcUrl(this.config);
        HikariConfig hikari = new HikariConfig();
        hikari.setJdbcUrl(url);
        hikari.setDriverClassName(DatabaseMigrator.getDriverClassName(this.config.getType()));
        hikari.setDataSourceProperties(DatabaseConfig.buildJdbcProperties(this.config));
        hikari.setConnectionTimeout((long)(this.config.getConnectionTimeout() * 1000));
        hikari.setIdleTimeout((long)(this.config.getIdleTimeout() * 1000));
        hikari.setKeepaliveTime((long)(this.config.getKeepaliveTime() * 1000));
        hikari.setValidationTimeout((long)(this.config.getValidationTimeout() * 1000));
        hikari.setMaximumPoolSize(this.config.getMaximumPoolSize());
        hikari.setMinimumIdle(this.config.getMinimumPoolSize());
        hikari.setRegisterMbeans(this.config.getEnableJMX());
        hikari.setLeakDetectionThreshold(this.config.getLeakDetectionThreshold());
        this.logger.debug("Using database URL {}", (Object)hikari.getJdbcUrl());
        HikariDataSource ds = new HikariDataSource(hikari);
        this.ds = ds;
        this.closer = ds;
    }

    @Override
    @PreDestroy
    public synchronized void close() {
        if (this.ds != null) {
            try {
                this.closer.close();
            }
            catch (Exception ex) {
                throw ThrowablesUtil.propagate((Throwable)ex);
            }
            this.ds = null;
            this.closer = null;
        }
    }
}

