/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digdag.client.config.ConfigKey;
import io.digdag.commons.ThrowablesUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class ConfigKeyListMapper {
    private final ObjectMapper jsonTreeMapper = new ObjectMapper();

    ConfigKeyListMapper() {
    }

    public List<ConfigKey> fromResultSetOrEmpty(ResultSet rs, String column) throws SQLException {
        String text = rs.getString(column);
        if (rs.wasNull()) {
            return new ArrayList<ConfigKey>();
        }
        return this.fromText(text);
    }

    private List<ConfigKey> fromText(String text) {
        try {
            return (List)this.jsonTreeMapper.readValue(text, this.jsonTreeMapper.getTypeFactory().constructParametrizedType(List.class, List.class, new Class[]{ConfigKey.class}));
        }
        catch (IOException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    private String toText(List<ConfigKey> keys) {
        try {
            return this.jsonTreeMapper.writeValueAsString(keys);
        }
        catch (IOException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    public String toBinding(List<ConfigKey> keys) {
        if (keys.isEmpty()) {
            return null;
        }
        String text = this.toText(keys);
        if ("[]".equals(text)) {
            return null;
        }
        return text;
    }
}

