/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.Preconditions;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.crypto.SecretCrypto;
import io.digdag.core.crypto.SecretCryptoException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESGCMSecretCrypto
implements SecretCrypto {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String NAME = "aesgcm";
    private static final byte[] NAME_BYTES = "aesgcm".getBytes(StandardCharsets.UTF_8);
    private final SecretKey sharedSecret;
    private static final int AES_KEY_SIZE = 128;
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static final int TERM = 1;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int RECORD_SIZE_ALIGNMENT = 16;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int LENGTH_SIZE = 4;
    private static final int NAME_SIZE = NAME_BYTES.length;
    private static final int TERM_SIZE = 4;
    private static final int VERSION_SIZE = 4;
    private static final int WRAPPING_SIZE = NAME_SIZE + 4 + 4 + 12;

    public AESGCMSecretCrypto(String sharedSecretBase64) {
        byte[] sharedSecretRaw = Base64.getDecoder().decode(sharedSecretBase64);
        Preconditions.checkArgument((sharedSecretRaw.length * 8 == 128 ? 1 : 0) != 0);
        this.sharedSecret = new SecretKeySpec(sharedSecretRaw, "AES");
    }

    @Override
    public String encryptSecret(String plainText) {
        byte[] cipherText;
        if (plainText.length() > 16384) {
            throw new IllegalArgumentException("Too long text");
        }
        byte[] nonce = this.generateNonce();
        Cipher cipher = this.cipher(1, this.sharedSecret, nonce);
        byte[] plainTextBytes = plainText.getBytes(StandardCharsets.UTF_8);
        if (plainTextBytes.length > 16384) {
            throw new IllegalArgumentException("Too long text");
        }
        int recordContentsLength = 4 + plainTextBytes.length;
        int recordLength = 16 * ((recordContentsLength + 16 - 1) / 16);
        byte[] recordBytes = new byte[recordLength];
        ByteBuffer recordBuffer = ByteBuffer.wrap(recordBytes);
        recordBuffer.putInt(plainTextBytes.length);
        recordBuffer.put(plainTextBytes);
        try {
            cipherText = cipher.doFinal(recordBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw ThrowablesUtil.propagate((Throwable)e);
        }
        byte[] opaque = new byte[WRAPPING_SIZE + cipherText.length];
        ByteBuffer output = ByteBuffer.wrap(opaque);
        output.put(NAME_BYTES);
        output.putInt(2);
        output.putInt(1);
        output.put(nonce);
        output.put(cipherText);
        assert (output.remaining() == 0);
        return Base64.getEncoder().encodeToString(opaque);
    }

    @Override
    public String decryptSecret(String encryptedBase64) {
        byte[] recordBytes;
        byte[] encrypted = Base64.getDecoder().decode(encryptedBase64);
        Preconditions.checkArgument((encrypted.length >= WRAPPING_SIZE + 16 ? 1 : 0) != 0, (Object)"Bad size");
        ByteBuffer buffer = ByteBuffer.wrap(encrypted);
        byte[] nameBytes = new byte[NAME_SIZE];
        buffer.get(nameBytes);
        if (!Arrays.equals(NAME_BYTES, nameBytes)) {
            throw new IllegalArgumentException("Crypto engine mismatch");
        }
        int version = buffer.getInt();
        if (version != 1 && version != 2) {
            throw new IllegalArgumentException("Bad version");
        }
        int term = buffer.getInt();
        if (term != 1) {
            throw new IllegalArgumentException("Bad term");
        }
        byte[] nonce = new byte[12];
        buffer.get(nonce);
        Cipher cipher = this.cipher(2, this.sharedSecret, nonce);
        try {
            recordBytes = cipher.doFinal(encrypted, buffer.position(), buffer.remaining());
        }
        catch (AEADBadTagException e) {
            throw new SecretCryptoException(e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw ThrowablesUtil.propagate((Throwable)e);
        }
        ByteBuffer decryptedBuffer = ByteBuffer.wrap(recordBytes);
        int length = decryptedBuffer.getInt();
        if (length < -1 || length > 16384) {
            throw new IllegalArgumentException("Bad length");
        }
        decryptedBuffer.limit(decryptedBuffer.position() + length);
        return StandardCharsets.UTF_8.decode(decryptedBuffer).toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Cipher cipher(int encryptMode, SecretKey sharedSecret, byte[] nonce) {
        Cipher result;
        try {
            result = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e1) {
            throw ThrowablesUtil.propagate((Throwable)e1);
        }
        Cipher cipher = result;
        GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
        try {
            cipher.init(encryptMode, (Key)sharedSecret, spec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw ThrowablesUtil.propagate((Throwable)e);
        }
        return cipher;
    }

    private byte[] generateNonce() {
        byte[] nonce = new byte[12];
        SECURE_RANDOM.nextBytes(nonce);
        return nonce;
    }
}

