/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigElement;
import io.digdag.core.config.StrictSafeConstructor;
import io.digdag.core.config.YamlParameterizedConstructor;
import io.digdag.core.config.YamlTagResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlConfigLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper treeObjectMapper = new ObjectMapper();

    @Inject
    public YamlConfigLoader() {
    }

    public ConfigElement loadFile(File file) throws IOException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String content = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
            ConfigElement configElement = this.loadString(content);
            return configElement;
        }
    }

    public ConfigElement loadString(String content) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new StrictSafeConstructor(), new Representer(), new DumperOptions(), (Resolver)new YamlTagResolver());
        ObjectNode object = this.normalizeValidateObjectNode(yaml.load(content));
        return ConfigElement.of((ObjectNode)object);
    }

    public ConfigElement loadParameterizedFile(File file, Config params) throws IOException {
        return ConfigElement.of((ObjectNode)this.loadParameterizedInclude(file.toPath(), params));
    }

    ObjectNode loadParameterizedInclude(Path path, Config params) throws IOException {
        String content;
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            content = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        Yaml yaml = new Yaml((BaseConstructor)new YamlParameterizedConstructor(), new Representer(), new DumperOptions(), (Resolver)new YamlTagResolver());
        ObjectNode object = this.normalizeValidateObjectNode(yaml.load(content));
        Path includeDir = path.toAbsolutePath().getParent();
        if (includeDir == null) {
            throw new FileNotFoundException("Loading file named '/' is invalid");
        }
        return new ParameterizeContext(includeDir, params).evalObjectRecursive(object);
    }

    private ObjectNode normalizeValidateObjectNode(Object object) throws IOException {
        JsonNode node = this.treeObjectMapper.readTree(this.treeObjectMapper.writeValueAsString(object));
        if (!node.isObject()) {
            throw new RuntimeJsonMappingException("Expected object to load Config but got " + node);
        }
        return (ObjectNode)node;
    }

    private class ParameterizeContext {
        private final Path includeDir;
        private final Config params;

        private ParameterizeContext(Path includeDir, Config params) {
            this.includeDir = includeDir.toAbsolutePath().normalize();
            this.params = params;
        }

        private ObjectNode evalObjectRecursive(ObjectNode object) throws IOException {
            ObjectNode built = object.objectNode();
            for (Map.Entry pair : ImmutableList.copyOf((Iterator)object.fields())) {
                JsonNode value = (JsonNode)pair.getValue();
                if (value.isObject()) {
                    built.set((String)pair.getKey(), (JsonNode)this.evalObjectRecursive((ObjectNode)value));
                    continue;
                }
                if (value.isArray()) {
                    built.set((String)pair.getKey(), (JsonNode)this.evalArrayRecursive((ArrayNode)value));
                    continue;
                }
                if (((String)pair.getKey()).startsWith("!include:")) {
                    String name = value.isTextual() ? value.textValue() : value.toString();
                    ObjectNode included = this.include(name);
                    for (Map.Entry merging : ImmutableList.copyOf((Iterator)included.fields())) {
                        JsonNode dest = built.get((String)merging.getKey());
                        if (dest != null && dest.isObject() && ((JsonNode)merging.getValue()).isObject()) {
                            this.mergeObject((ObjectNode)dest, (ObjectNode)merging.getValue());
                            continue;
                        }
                        built.set((String)merging.getKey(), (JsonNode)merging.getValue());
                    }
                    continue;
                }
                if (value.isTextual() && value.textValue().startsWith("!include:")) {
                    built.set((String)pair.getKey(), (JsonNode)this.include(value.textValue()));
                    continue;
                }
                built.set((String)pair.getKey(), value);
            }
            return built;
        }

        private ArrayNode evalArrayRecursive(ArrayNode array) throws IOException {
            ArrayNode built = array.arrayNode();
            for (JsonNode value : array) {
                Object evaluated = value.isObject() ? this.evalObjectRecursive((ObjectNode)value) : (value.isArray() ? this.evalArrayRecursive((ArrayNode)value) : (value.isTextual() && value.textValue().startsWith("!include:") ? this.include(value.textValue()) : value));
                built.add((JsonNode)evaluated);
            }
            return built;
        }

        private ObjectNode include(String name) throws IOException {
            Path path = this.includeDir.resolve(name).toAbsolutePath().normalize();
            if (!path.toString().startsWith(this.includeDir.toString())) {
                throw new FileNotFoundException("File name must not include ..: " + name);
            }
            return YamlConfigLoader.this.loadParameterizedInclude(path, this.params);
        }

        private void mergeObject(ObjectNode dest, ObjectNode src) {
            for (Map.Entry pair : ImmutableList.copyOf((Iterator)src.fields())) {
                JsonNode d = dest.get((String)pair.getKey());
                JsonNode v = (JsonNode)pair.getValue();
                if (d != null && d.isObject() && v.isObject()) {
                    this.mergeObject((ObjectNode)d, (ObjectNode)v);
                    continue;
                }
                dest.replace((String)pair.getKey(), v);
            }
        }
    }
}

