/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.archive;

import com.google.common.base.Preconditions;
import io.digdag.core.archive.ArchiveMetadata;
import io.digdag.core.archive.DigdagIgnore;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class ProjectArchive {
    public static final String WORKFLOW_FILE_SUFFIX = ".dig";
    private final Path projectPath;
    private final ArchiveMetadata metadata;

    public static String resourceNameToWorkflowName(String resourceName) {
        if (resourceName.endsWith(WORKFLOW_FILE_SUFFIX)) {
            return resourceName.substring(0, resourceName.length() - WORKFLOW_FILE_SUFFIX.length());
        }
        return resourceName;
    }

    ProjectArchive(Path projectPath, ArchiveMetadata metadata) {
        Preconditions.checkArgument((boolean)projectPath.isAbsolute(), (String)"project path must be absolute: %s", (Object)projectPath);
        this.projectPath = projectPath;
        this.metadata = metadata;
    }

    public Path getProjectPath() {
        return this.projectPath;
    }

    public ArchiveMetadata getArchiveMetadata() {
        return this.metadata;
    }

    public void listFiles(PathConsumer consumer) throws IOException {
        ProjectArchive.listFiles(this.projectPath, consumer);
    }

    static void listFiles(Path projectPath, PathConsumer consumer) throws IOException {
        Optional<DigdagIgnore> digdagIgnore = DigdagIgnore.ofProject(projectPath);
        DirectoryStream.Filter<Path> filter = target -> ProjectArchive.rejectDotFiles(target) && digdagIgnore.map(ignore -> ignore.accept((Path)target)).orElse(true) != false;
        ProjectArchive.listFilesRecursively(projectPath, projectPath, consumer, filter, new HashSet<String>());
    }

    public String pathToResourceName(Path path) {
        return ProjectArchive.realPathToResourceName(this.projectPath, path.normalize().toAbsolutePath());
    }

    public static String realPathToResourceName(Path projectPath, Path realPath) {
        Preconditions.checkArgument((boolean)projectPath.isAbsolute(), (String)"project path must be absolute: %s", (Object)projectPath);
        Preconditions.checkArgument((boolean)realPath.isAbsolute(), (String)"real path must be absolute: %s", (Object)realPath);
        if (!realPath.startsWith(projectPath)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Given path '%s' is outside of project directory '%s'", realPath, projectPath));
        }
        Path relative = projectPath.relativize(realPath);
        return relative.toString().replace(File.separatorChar, '/');
    }

    private static void listFilesRecursively(Path projectPath, Path targetDir, PathConsumer consumer, DirectoryStream.Filter<Path> filter, Set<String> listed) throws IOException {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(targetDir, filter);){
            for (Path path : ds) {
                boolean cont;
                String resourceName = ProjectArchive.realPathToResourceName(projectPath, path);
                if (!listed.add(resourceName) || !(cont = consumer.accept(resourceName, path)) || !Files.isDirectory(path, new LinkOption[0])) continue;
                ProjectArchive.listFilesRecursively(projectPath, path, consumer, filter, listed);
            }
        }
    }

    private static boolean rejectDotFiles(Path target) {
        return !target.getFileName().toString().startsWith(".");
    }

    public static interface PathConsumer {
        public boolean accept(String var1, Path var2) throws IOException;
    }
}

