/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.digdag.core.BackgroundExecutor;
import io.digdag.core.ErrorReporter;
import io.digdag.core.agent.AgentConfig;
import io.digdag.core.agent.AgentId;
import io.digdag.core.agent.MultiThreadAgent;
import io.digdag.core.agent.OperatorManager;
import io.digdag.core.agent.TaskServerApi;
import io.digdag.core.database.TransactionManager;
import io.digdag.spi.metrics.DigdagMetrics;
import java.time.Duration;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class LocalAgentManager
implements BackgroundExecutor {
    private final Supplier<MultiThreadAgent> agentFactory;
    private volatile Thread thread;
    private volatile MultiThreadAgent agent;
    @Inject(optional=true)
    private ErrorReporter errorReporter = ErrorReporter.empty();
    @Inject
    private DigdagMetrics metrics;

    @Inject
    public LocalAgentManager(AgentConfig config, AgentId agentId, TaskServerApi taskServer, OperatorManager operatorManager, TransactionManager transactionManager) {
        this.agentFactory = config.getEnabled() ? () -> new MultiThreadAgent(config, agentId, taskServer, operatorManager, transactionManager, this.errorReporter, this.metrics) : null;
    }

    @PostConstruct
    public synchronized void start() {
        if (this.agentFactory != null && this.thread == null) {
            this.agent = this.agentFactory.get();
            Thread thread = new ThreadFactoryBuilder().setDaemon(false).setNameFormat("local-agent-%d").build().newThread(this.agent);
            thread.start();
            this.thread = thread;
        }
    }

    @PreDestroy
    public synchronized void shutdown() throws InterruptedException {
        if (this.thread != null) {
            this.agent.shutdown((Optional<Duration>)Optional.absent());
            this.thread.join();
            this.thread = null;
        }
    }

    @Override
    public void eagerShutdown() throws InterruptedException {
        this.shutdown();
    }
}

