/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.digdag.client.config.Config;
import io.digdag.core.agent.AgentId;
import java.lang.management.ManagementFactory;

public class AgentIdProvider
implements Provider<AgentId> {
    private final AgentId id;

    @Inject
    public AgentIdProvider(Config systemConfig) {
        String id = (String)systemConfig.get("agent.id", String.class, null);
        if (id == null) {
            id = ManagementFactory.getRuntimeMXBean().getName();
        }
        this.id = AgentId.of(id);
    }

    public AgentId get() {
        return this.id;
    }
}

