/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift.config;

import io.dekorate.testing.openshift.config.OpenshiftIntegrationTestConfig;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class OpenshiftIntegrationTestConfigFluent<A extends OpenshiftIntegrationTestConfigFluent<A>>
extends BaseFluent<A> {
    private boolean deployEnabled;
    private boolean buildEnabled;
    private boolean pushEnabled;
    private long imageStreamTagTimeout;
    private long readinessTimeout;
    private List<String> additionalModules = new ArrayList<String>();

    public OpenshiftIntegrationTestConfigFluent() {
    }

    public OpenshiftIntegrationTestConfigFluent(OpenshiftIntegrationTestConfig instance) {
        OpenshiftIntegrationTestConfig openshiftIntegrationTestConfig = instance = instance != null ? instance : new OpenshiftIntegrationTestConfig();
        if (instance != null) {
            this.withDeployEnabled(instance.isDeployEnabled());
            this.withBuildEnabled(instance.isBuildEnabled());
            this.withPushEnabled(instance.isPushEnabled());
            this.withImageStreamTagTimeout(instance.getImageStreamTagTimeout());
            this.withReadinessTimeout(instance.getReadinessTimeout());
            this.withAdditionalModules(instance.getAdditionalModules());
        }
    }

    public boolean isDeployEnabled() {
        return this.deployEnabled;
    }

    public A withDeployEnabled(boolean deployEnabled) {
        this.deployEnabled = deployEnabled;
        return (A)((Object)this);
    }

    public boolean hasDeployEnabled() {
        return true;
    }

    public boolean isBuildEnabled() {
        return this.buildEnabled;
    }

    public A withBuildEnabled(boolean buildEnabled) {
        this.buildEnabled = buildEnabled;
        return (A)((Object)this);
    }

    public boolean hasBuildEnabled() {
        return true;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public A withPushEnabled(boolean pushEnabled) {
        this.pushEnabled = pushEnabled;
        return (A)((Object)this);
    }

    public boolean hasPushEnabled() {
        return true;
    }

    public long getImageStreamTagTimeout() {
        return this.imageStreamTagTimeout;
    }

    public A withImageStreamTagTimeout(long imageStreamTagTimeout) {
        this.imageStreamTagTimeout = imageStreamTagTimeout;
        return (A)((Object)this);
    }

    public boolean hasImageStreamTagTimeout() {
        return true;
    }

    public long getReadinessTimeout() {
        return this.readinessTimeout;
    }

    public A withReadinessTimeout(long readinessTimeout) {
        this.readinessTimeout = readinessTimeout;
        return (A)((Object)this);
    }

    public boolean hasReadinessTimeout() {
        return true;
    }

    public A withAdditionalModules(String ... additionalModules) {
        if (this.additionalModules != null) {
            this.additionalModules.clear();
            this._visitables.remove((Object)"additionalModules");
        }
        if (additionalModules != null) {
            for (String item : additionalModules) {
                this.addToAdditionalModules(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getAdditionalModules() {
        int size = this.additionalModules != null ? this.additionalModules.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.additionalModules) {
            result[index++] = item;
        }
        return result;
    }

    public A addToAdditionalModules(int index, String item) {
        if (this.additionalModules == null) {
            this.additionalModules = new ArrayList<String>();
        }
        this.additionalModules.add(index, item);
        return (A)((Object)this);
    }

    public A setToAdditionalModules(int index, String item) {
        if (this.additionalModules == null) {
            this.additionalModules = new ArrayList<String>();
        }
        this.additionalModules.set(index, item);
        return (A)((Object)this);
    }

    public A addToAdditionalModules(String ... items) {
        if (this.additionalModules == null) {
            this.additionalModules = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalModules.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAdditionalModules(Collection<String> items) {
        if (this.additionalModules == null) {
            this.additionalModules = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalModules.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalModules(String ... items) {
        if (this.additionalModules == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalModules.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAdditionalModules(Collection<String> items) {
        if (this.additionalModules == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalModules.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasAdditionalModules() {
        return this.additionalModules != null && !this.additionalModules.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenshiftIntegrationTestConfigFluent that = (OpenshiftIntegrationTestConfigFluent)((Object)o);
        if (this.deployEnabled != that.deployEnabled) {
            return false;
        }
        if (this.buildEnabled != that.buildEnabled) {
            return false;
        }
        if (this.pushEnabled != that.pushEnabled) {
            return false;
        }
        if (this.imageStreamTagTimeout != that.imageStreamTagTimeout) {
            return false;
        }
        if (this.readinessTimeout != that.readinessTimeout) {
            return false;
        }
        return Objects.equals(this.additionalModules, that.additionalModules);
    }

    public int hashCode() {
        return Objects.hash(this.deployEnabled, this.buildEnabled, this.pushEnabled, this.imageStreamTagTimeout, this.readinessTimeout, this.additionalModules, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("deployEnabled:");
        sb.append(this.deployEnabled + ",");
        sb.append("buildEnabled:");
        sb.append(this.buildEnabled + ",");
        sb.append("pushEnabled:");
        sb.append(this.pushEnabled + ",");
        sb.append("imageStreamTagTimeout:");
        sb.append(this.imageStreamTagTimeout + ",");
        sb.append("readinessTimeout:");
        sb.append(this.readinessTimeout + ",");
        if (this.additionalModules != null && !this.additionalModules.isEmpty()) {
            sb.append("additionalModules:");
            sb.append(this.additionalModules);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDeployEnabled() {
        return this.withDeployEnabled(true);
    }

    public A withBuildEnabled() {
        return this.withBuildEnabled(true);
    }

    public A withPushEnabled() {
        return this.withPushEnabled(true);
    }
}

