/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift;

import io.dekorate.testing.AbstractDiagonsticsService;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;

public class DeploymentConfigDiagnostics
extends AbstractDiagonsticsService<DeploymentConfig> {
    private static final String DEPLOYMENT_STATUS_HEADER_FORMAT = "Deployment: %s [%d/%d]";
    private static final String DEPLOYMENT_STATUS_CONDITIONS_FORMAT = "\t%-20s %-10s %-40s";

    public DeploymentConfigDiagnostics(KubernetesClient client) {
        super(client);
    }

    public void display(DeploymentConfig deployment) {
        this.LOGGER.info("Diagnostics for kind: [DeploymentConfig] with name : [" + deployment.getMetadata().getName() + "].");
        this.displayStatus(deployment);
        this.displayEvents((HasMetadata)deployment);
    }

    public void displayStatus(DeploymentConfig deployment) {
        String name = deployment.getMetadata().getName();
        DeploymentConfig updated = (DeploymentConfig)((DeployableScalableResource)((OpenShiftClient)this.getKubernetesClient().adapt(OpenShiftClient.class)).deploymentConfigs().withName(name)).get();
        if (updated != null) {
            int readyReplicas = updated.getStatus() != null && updated.getStatus().getReadyReplicas() != null ? updated.getStatus().getReadyReplicas() : 0;
            this.LOGGER.info(String.format(DEPLOYMENT_STATUS_HEADER_FORMAT, name, readyReplicas, updated.getSpec().getReplicas()));
            if (updated.getStatus() != null) {
                this.LOGGER.info(String.format(DEPLOYMENT_STATUS_CONDITIONS_FORMAT, "Type", "Status", "Message"));
                updated.getStatus().getConditions().forEach(c -> this.LOGGER.info(String.format(DEPLOYMENT_STATUS_CONDITIONS_FORMAT, c.getType(), c.getStatus(), c.getMessage())));
            } else {
                this.LOGGER.error("Failed to retrieve Deployment: [" + name + "]");
            }
        }
    }
}

