/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.kubernetes.decorator.AddAwsElasticBlockStoreVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureDiskVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddPortDecorator;
import io.dekorate.kubernetes.decorator.AddPvcVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyArgsDecorator;
import io.dekorate.kubernetes.decorator.ApplyCommandDecorator;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyServiceAccountNamedDecorator;
import io.dekorate.kubernetes.decorator.ApplyWorkingDirDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import java.util.function.Predicate;

public class ApplyDeploymentTriggerDecorator
extends NamedResourceDecorator<DeploymentConfigSpecFluent<?>> {
    private static final String IMAGESTREAMTAG = "ImageStreamTag";
    private static final String IMAGECHANGE = "ImageChange";
    private final String containerName;
    private final String imageStreamTag;
    private final Predicate<DeploymentTriggerPolicyBuilder> predicate;

    public ApplyDeploymentTriggerDecorator(String containerName, String imageStreamTag) {
        this.containerName = containerName;
        this.imageStreamTag = imageStreamTag;
        this.predicate = d -> d.hasImageChangeParams() && d.buildImageChangeParams().getContainerNames() != null && d.buildImageChangeParams().getContainerNames().contains(containerName);
    }

    public void andThenVisit(DeploymentConfigSpecFluent<?> deploymentConfigSpec, ObjectMeta resourceMeta) {
        DeploymentConfigSpecFluent.TriggersNested target = deploymentConfigSpec.buildMatchingTrigger(this.predicate) != null ? deploymentConfigSpec.editMatchingTrigger(this.predicate) : deploymentConfigSpec.addNewTrigger();
        ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)target.withType(IMAGECHANGE)).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withContainerNames(new String[]{this.containerName})).withNewFrom().withKind(IMAGESTREAMTAG)).withName(this.imageStreamTag)).endFrom()).endImageChangeParams()).endTrigger();
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddEnvVarDecorator.class, AddPortDecorator.class, AddMountDecorator.class, AddPvcVolumeDecorator.class, AddAwsElasticBlockStoreVolumeDecorator.class, AddAzureDiskVolumeDecorator.class, AddAwsElasticBlockStoreVolumeDecorator.class, ApplyImageDecorator.class, ApplyImagePullPolicyDecorator.class, ApplyWorkingDirDecorator.class, ApplyCommandDecorator.class, ApplyArgsDecorator.class, ApplyServiceAccountNamedDecorator.class, AddReadinessProbeDecorator.class, AddLivenessProbeDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class, AddInitContainerDecorator.class};
    }
}

