/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Arrays;
import java.util.Objects;

@Description(value="Add an annotation to the matching resources (filtered by name and/or kinds).")
public class AddAnnotationDecorator
extends NamedResourceDecorator<ObjectMetaBuilder> {
    private final Annotation annotation;

    public AddAnnotationDecorator(Annotation annotation) {
        this(ANY, annotation);
    }

    public AddAnnotationDecorator(String name, Annotation annotation) {
        super(ANY, name);
        this.annotation = annotation;
    }

    public AddAnnotationDecorator(String name, String key, String value, String ... kinds) {
        super(ANY, name);
        this.annotation = new Annotation(key, value, kinds);
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, String kind, ObjectMeta resourceMeta) {
        if (this.annotation.getKinds() == null || this.annotation.getKinds().length == 0 || Arrays.asList(this.annotation.getKinds()).contains(kind)) {
            this.andThenVisit(builder, resourceMeta);
        }
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        builder.addToAnnotations(this.annotation.getKey(), this.annotation.getValue());
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{RemoveAnnotationDecorator.class};
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddAnnotationDecorator that = (AddAnnotationDecorator)o;
        return Objects.equals(this.annotation, that.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.annotation);
    }
}

