/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.IngressBuilder;
import io.dekorate.kubernetes.config.IngressRule;
import java.util.Objects;

public class Ingress {
    private String host;
    private String ingressClassName;
    private Boolean expose;
    private String tlsSecretName;
    private String[] tlsHosts = new String[0];
    private IngressRule[] rules = new IngressRule[0];

    public Ingress() {
    }

    public Ingress(String host, String ingressClassName, Boolean expose, String tlsSecretName, String[] tlsHosts, IngressRule[] rules) {
        this.host = host;
        this.ingressClassName = ingressClassName;
        this.expose = expose;
        this.tlsSecretName = tlsSecretName;
        this.tlsHosts = tlsHosts != null ? tlsHosts : new String[]{};
        this.rules = rules != null ? rules : new IngressRule[]{};
    }

    public String getHost() {
        return this.host;
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public boolean isExpose() {
        return this.expose != null && this.expose != false;
    }

    public String getTlsSecretName() {
        return this.tlsSecretName;
    }

    public String[] getTlsHosts() {
        return this.tlsHosts;
    }

    public IngressRule[] getRules() {
        return this.rules;
    }

    public static IngressBuilder newBuilder() {
        return new IngressBuilder();
    }

    public static IngressBuilder newBuilderFromDefaults() {
        return (IngressBuilder)new IngressBuilder().withExpose(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ingress that = (Ingress)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.ingressClassName != null ? !this.ingressClassName.equals(that.ingressClassName) : that.ingressClassName != null) {
            return false;
        }
        if (this.expose != null ? !this.expose.equals(that.expose) : that.expose != null) {
            return false;
        }
        if (this.tlsSecretName != null ? !this.tlsSecretName.equals(that.tlsSecretName) : that.tlsSecretName != null) {
            return false;
        }
        if (this.tlsHosts != null ? !this.tlsHosts.equals(that.tlsHosts) : that.tlsHosts != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.ingressClassName, this.expose, this.tlsSecretName, this.tlsHosts, this.rules, super.hashCode());
    }
}

