/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AnnotationBuilder;
import io.dekorate.kubernetes.config.AnnotationFluentImpl;
import io.dekorate.kubernetes.config.ApplicationConfigurationFluentImpl;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolumeBuilder;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolumeFluentImpl;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureDiskVolumeBuilder;
import io.dekorate.kubernetes.config.AzureDiskVolumeFluentImpl;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.AzureFileVolumeBuilder;
import io.dekorate.kubernetes.config.AzureFileVolumeFluentImpl;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigMapVolumeBuilder;
import io.dekorate.kubernetes.config.ConfigMapVolumeFluentImpl;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluentImpl;
import io.dekorate.kubernetes.config.CronJob;
import io.dekorate.kubernetes.config.CronJobBuilder;
import io.dekorate.kubernetes.config.CronJobFluentImpl;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.EmptyDirVolumeBuilder;
import io.dekorate.kubernetes.config.EmptyDirVolumeFluentImpl;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluentImpl;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.GitRepoVolumeBuilder;
import io.dekorate.kubernetes.config.GitRepoVolumeFluentImpl;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.HostAliasBuilder;
import io.dekorate.kubernetes.config.HostAliasFluentImpl;
import io.dekorate.kubernetes.config.Job;
import io.dekorate.kubernetes.config.JobBuilder;
import io.dekorate.kubernetes.config.JobFluentImpl;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelBuilder;
import io.dekorate.kubernetes.config.LabelFluentImpl;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.MountBuilder;
import io.dekorate.kubernetes.config.MountFluentImpl;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolumeBuilder;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolumeFluentImpl;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.PortFluentImpl;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.config.ProbeFluentImpl;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.ResourceRequirementsBuilder;
import io.dekorate.kubernetes.config.ResourceRequirementsFluentImpl;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import io.dekorate.kubernetes.config.SecretVolumeFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BaseConfigFluentImpl<A extends BaseConfigFluent<A>>
extends ApplicationConfigurationFluentImpl<A>
implements BaseConfigFluent<A> {
    private String deploymentKind;
    private ArrayList<LabelBuilder> labels = new ArrayList();
    private ArrayList<AnnotationBuilder> annotations = new ArrayList();
    private ArrayList<EnvBuilder> envVars = new ArrayList();
    private String workingDir;
    private List<String> command = new ArrayList<String>();
    private List<String> arguments = new ArrayList<String>();
    private String serviceAccount;
    private ArrayList<PortBuilder> ports = new ArrayList();
    private ServiceType serviceType;
    private ArrayList<PersistentVolumeClaimVolumeBuilder> pvcVolumes = new ArrayList();
    private ArrayList<SecretVolumeBuilder> secretVolumes = new ArrayList();
    private ArrayList<ConfigMapVolumeBuilder> configMapVolumes = new ArrayList();
    private ArrayList<EmptyDirVolumeBuilder> emptyDirVolumes = new ArrayList();
    private ArrayList<GitRepoVolumeBuilder> gitRepoVolumes = new ArrayList();
    private ArrayList<AwsElasticBlockStoreVolumeBuilder> awsElasticBlockStoreVolumes = new ArrayList();
    private ArrayList<AzureDiskVolumeBuilder> azureDiskVolumes = new ArrayList();
    private ArrayList<AzureFileVolumeBuilder> azureFileVolumes = new ArrayList();
    private ArrayList<MountBuilder> mounts = new ArrayList();
    private ImagePullPolicy imagePullPolicy;
    private List<String> imagePullSecrets = new ArrayList<String>();
    private ArrayList<HostAliasBuilder> hostAliases = new ArrayList();
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private ProbeBuilder startupProbe;
    private ResourceRequirementsBuilder requestResources;
    private ResourceRequirementsBuilder limitResources;
    private ArrayList<ContainerBuilder> sidecars = new ArrayList();
    private Boolean autoDeployEnabled;
    private ArrayList<JobBuilder> jobs = new ArrayList();
    private ArrayList<CronJobBuilder> cronJobs = new ArrayList();

    public BaseConfigFluentImpl() {
    }

    public BaseConfigFluentImpl(BaseConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withDeploymentKind(instance.getDeploymentKind());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withServiceAccount(instance.getServiceAccount());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withHostAliases(instance.getHostAliases());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withStartupProbe(instance.getStartupProbe());
        this.withRequestResources(instance.getRequestResources());
        this.withLimitResources(instance.getLimitResources());
        this.withSidecars(instance.getSidecars());
        this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
        this.withJobs(instance.getJobs());
        this.withCronJobs(instance.getCronJobs());
    }

    @Override
    public String getDeploymentKind() {
        return this.deploymentKind;
    }

    @Override
    public A withDeploymentKind(String deploymentKind) {
        this.deploymentKind = deploymentKind;
        return (A)this;
    }

    @Override
    public Boolean hasDeploymentKind() {
        return this.deploymentKind != null;
    }

    @Override
    public A withLabels(Label ... labels) {
        if (this.labels != null) {
            this.labels.clear();
        }
        if (labels != null) {
            for (Label item : labels) {
                this.addToLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Label[] getLabels() {
        int size = this.labels != null ? this.labels.size() : 0;
        Label[] result = new Label[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.labels) {
            result[index++] = (Label)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Label[] buildLabels() {
        int size = this.labels != null ? this.labels.size() : 0;
        Label[] result = new Label[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.labels) {
            result[index++] = (Label)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Label buildLabel(Integer index) {
        return this.labels.get(index).build();
    }

    @Override
    public Label buildFirstLabel() {
        return this.labels.get(0).build();
    }

    @Override
    public Label buildLastLabel() {
        return this.labels.get(this.labels.size() - 1).build();
    }

    @Override
    public Label buildMatchingLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToLabels(Integer index, Label item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        this._visitables.get((Object)"labels").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"labels").size(), builder);
        this.labels.add(index >= 0 ? index.intValue() : this.labels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLabels(Integer index, Label item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"labels").size()) {
            this._visitables.get((Object)"labels").add(builder);
        } else {
            this._visitables.get((Object)"labels").set(index, builder);
        }
        if (index < 0 || index >= this.labels.size()) {
            this.labels.add(builder);
        } else {
            this.labels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Label ... items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLabels(Collection<Label> items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Label ... items) {
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLabels(Collection<Label> items) {
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromLabels(Predicate<LabelBuilder> predicate) {
        if (this.labels == null) {
            return (A)this;
        }
        Iterator<LabelBuilder> each = this.labels.iterator();
        List visitables = this._visitables.get((Object)"labels");
        while (each.hasNext()) {
            LabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null && !this.labels.isEmpty();
    }

    @Override
    public A addNewLabel(String key, String value, String[] kinds) {
        return this.addToLabels(new Label(key, value, kinds));
    }

    @Override
    public BaseConfigFluent.LabelsNested<A> addNewLabel() {
        return new LabelsNestedImpl();
    }

    @Override
    public BaseConfigFluent.LabelsNested<A> addNewLabelLike(Label item) {
        return new LabelsNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.LabelsNested<A> setNewLabelLike(Integer index, Label item) {
        return new LabelsNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.LabelsNested<A> editLabel(Integer index) {
        if (this.labels.size() <= index) {
            throw new RuntimeException("Can't edit labels. Index exceeds size.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public BaseConfigFluent.LabelsNested<A> editFirstLabel() {
        if (this.labels.size() == 0) {
            throw new RuntimeException("Can't edit first labels. The list is empty.");
        }
        return this.setNewLabelLike(0, this.buildLabel(0));
    }

    @Override
    public BaseConfigFluent.LabelsNested<A> editLastLabel() {
        int index = this.labels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last labels. The list is empty.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public BaseConfigFluent.LabelsNested<A> editMatchingLabel(Predicate<LabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!predicate.test(this.labels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching labels. No match found.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public A withAnnotations(Annotation ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
        }
        if (annotations != null) {
            for (Annotation item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Annotation[] getAnnotations() {
        int size = this.annotations != null ? this.annotations.size() : 0;
        Annotation[] result = new Annotation[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.annotations) {
            result[index++] = (Annotation)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Annotation[] buildAnnotations() {
        int size = this.annotations != null ? this.annotations.size() : 0;
        Annotation[] result = new Annotation[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.annotations) {
            result[index++] = (Annotation)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Annotation buildAnnotation(Integer index) {
        return this.annotations.get(index).build();
    }

    @Override
    public Annotation buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    @Override
    public Annotation buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    @Override
    public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAnnotations(Integer index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        this._visitables.get((Object)"annotations").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"annotations").size(), builder);
        this.annotations.add(index >= 0 ? index.intValue() : this.annotations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAnnotations(Integer index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"annotations").size()) {
            this._visitables.get((Object)"annotations").add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
        }
        if (index < 0 || index >= this.annotations.size()) {
            this.annotations.add(builder);
        } else {
            this.annotations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Annotation ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAnnotations(Collection<Annotation> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Annotation ... items) {
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAnnotations(Collection<Annotation> items) {
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate) {
        if (this.annotations == null) {
            return (A)this;
        }
        Iterator<AnnotationBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    @Override
    public A addNewAnnotation(String key, String value, String[] kinds) {
        return this.addToAnnotations(new Annotation(key, value, kinds));
    }

    @Override
    public BaseConfigFluent.AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNestedImpl();
    }

    @Override
    public BaseConfigFluent.AnnotationsNested<A> addNewAnnotationLike(Annotation item) {
        return new AnnotationsNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.AnnotationsNested<A> setNewAnnotationLike(Integer index, Annotation item) {
        return new AnnotationsNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.AnnotationsNested<A> editAnnotation(Integer index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public BaseConfigFluent.AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    @Override
    public BaseConfigFluent.AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public BaseConfigFluent.AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public A withEnvVars(Env ... envVars) {
        if (this.envVars != null) {
            this.envVars.clear();
        }
        if (envVars != null) {
            for (Env item : envVars) {
                this.addToEnvVars(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Env[] getEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildEnvVar(Integer index) {
        return this.envVars.get(index).build();
    }

    @Override
    public Env buildFirstEnvVar() {
        return this.envVars.get(0).build();
    }

    @Override
    public Env buildLastEnvVar() {
        return this.envVars.get(this.envVars.size() - 1).build();
    }

    @Override
    public Env buildMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEnvVars(Integer index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.get((Object)"envVars").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"envVars").size(), builder);
        this.envVars.add(index >= 0 ? index.intValue() : this.envVars.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvVars(Integer index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"envVars").size()) {
            this._visitables.get((Object)"envVars").add(builder);
        } else {
            this._visitables.get((Object)"envVars").set(index, builder);
        }
        if (index < 0 || index >= this.envVars.size()) {
            this.envVars.add(builder);
        } else {
            this.envVars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvVars(Env ... items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvVars(Collection<Env> items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvVars(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvVars(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEnvVars(Predicate<EnvBuilder> predicate) {
        if (this.envVars == null) {
            return (A)this;
        }
        Iterator<EnvBuilder> each = this.envVars.iterator();
        List visitables = this._visitables.get((Object)"envVars");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvVars() {
        return this.envVars != null && !this.envVars.isEmpty();
    }

    @Override
    public BaseConfigFluent.EnvVarsNested<A> addNewEnvVar() {
        return new EnvVarsNestedImpl();
    }

    @Override
    public BaseConfigFluent.EnvVarsNested<A> addNewEnvVarLike(Env item) {
        return new EnvVarsNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.EnvVarsNested<A> setNewEnvVarLike(Integer index, Env item) {
        return new EnvVarsNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.EnvVarsNested<A> editEnvVar(Integer index) {
        if (this.envVars.size() <= index) {
            throw new RuntimeException("Can't edit envVars. Index exceeds size.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public BaseConfigFluent.EnvVarsNested<A> editFirstEnvVar() {
        if (this.envVars.size() == 0) {
            throw new RuntimeException("Can't edit first envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(0, this.buildEnvVar(0));
    }

    @Override
    public BaseConfigFluent.EnvVarsNested<A> editLastEnvVar() {
        int index = this.envVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public BaseConfigFluent.EnvVarsNested<A> editMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envVars.size(); ++i) {
            if (!predicate.test(this.envVars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envVars. No match found.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)this;
    }

    @Override
    public Boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    @Override
    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getCommand() {
        int size = this.command != null ? this.command.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.command) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCommand(Integer index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(Integer index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public A withArguments(String ... arguments) {
        if (this.arguments != null) {
            this.arguments.clear();
        }
        if (arguments != null) {
            for (String item : arguments) {
                this.addToArguments(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getArguments() {
        int size = this.arguments != null ? this.arguments.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.arguments) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToArguments(Integer index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToArguments(Integer index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToArguments(String ... items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToArguments(Collection<String> items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromArguments(String ... items) {
        for (String item : items) {
            if (this.arguments == null) continue;
            this.arguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArguments(Collection<String> items) {
        for (String item : items) {
            if (this.arguments == null) continue;
            this.arguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    public A withPorts(Port ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Port[] getPorts() {
        int size = this.ports != null ? this.ports.size() : 0;
        Port[] result = new Port[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.ports) {
            result[index++] = (Port)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Port[] buildPorts() {
        int size = this.ports != null ? this.ports.size() : 0;
        Port[] result = new Port[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.ports) {
            result[index++] = (Port)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Port buildPort(Integer index) {
        return this.ports.get(index).build();
    }

    @Override
    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToPorts(Integer index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortBuilder builder = new PortBuilder(item);
        this._visitables.get((Object)"ports").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"ports").size(), builder);
        this.ports.add(index >= 0 ? index.intValue() : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(Integer index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"ports").size()) {
            this._visitables.get((Object)"ports").add(builder);
        } else {
            this._visitables.get((Object)"ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Port ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<Port> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<Port> items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<PortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            PortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public BaseConfigFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public BaseConfigFluent.PortsNested<A> addNewPortLike(Port item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.PortsNested<A> setNewPortLike(Integer index, Port item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.PortsNested<A> editPort(Integer index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public BaseConfigFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public BaseConfigFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public BaseConfigFluent.PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    @Override
    public A withServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
        return (A)this;
    }

    @Override
    public Boolean hasServiceType() {
        return this.serviceType != null;
    }

    @Override
    public A withPvcVolumes(PersistentVolumeClaimVolume ... pvcVolumes) {
        if (this.pvcVolumes != null) {
            this.pvcVolumes.clear();
        }
        if (pvcVolumes != null) {
            for (PersistentVolumeClaimVolume item : pvcVolumes) {
                this.addToPvcVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public PersistentVolumeClaimVolume[] getPvcVolumes() {
        int size = this.pvcVolumes != null ? this.pvcVolumes.size() : 0;
        PersistentVolumeClaimVolume[] result = new PersistentVolumeClaimVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.pvcVolumes) {
            result[index++] = (PersistentVolumeClaimVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public PersistentVolumeClaimVolume[] buildPvcVolumes() {
        int size = this.pvcVolumes != null ? this.pvcVolumes.size() : 0;
        PersistentVolumeClaimVolume[] result = new PersistentVolumeClaimVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.pvcVolumes) {
            result[index++] = (PersistentVolumeClaimVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public PersistentVolumeClaimVolume buildPvcVolume(Integer index) {
        return this.pvcVolumes.get(index).build();
    }

    @Override
    public PersistentVolumeClaimVolume buildFirstPvcVolume() {
        return this.pvcVolumes.get(0).build();
    }

    @Override
    public PersistentVolumeClaimVolume buildLastPvcVolume() {
        return this.pvcVolumes.get(this.pvcVolumes.size() - 1).build();
    }

    @Override
    public PersistentVolumeClaimVolume buildMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        for (PersistentVolumeClaimVolumeBuilder item : this.pvcVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        for (PersistentVolumeClaimVolumeBuilder item : this.pvcVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToPvcVolumes(Integer index, PersistentVolumeClaimVolume item) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
        this._visitables.get((Object)"pvcVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"pvcVolumes").size(), builder);
        this.pvcVolumes.add(index >= 0 ? index.intValue() : this.pvcVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPvcVolumes(Integer index, PersistentVolumeClaimVolume item) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"pvcVolumes").size()) {
            this._visitables.get((Object)"pvcVolumes").add(builder);
        } else {
            this._visitables.get((Object)"pvcVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.pvcVolumes.size()) {
            this.pvcVolumes.add(builder);
        } else {
            this.pvcVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPvcVolumes(PersistentVolumeClaimVolume ... items) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPvcVolumes(PersistentVolumeClaimVolume ... items) {
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").remove(builder);
            if (this.pvcVolumes == null) continue;
            this.pvcVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").remove(builder);
            if (this.pvcVolumes == null) continue;
            this.pvcVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPvcVolumes(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        if (this.pvcVolumes == null) {
            return (A)this;
        }
        Iterator<PersistentVolumeClaimVolumeBuilder> each = this.pvcVolumes.iterator();
        List visitables = this._visitables.get((Object)"pvcVolumes");
        while (each.hasNext()) {
            PersistentVolumeClaimVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasPvcVolumes() {
        return this.pvcVolumes != null && !this.pvcVolumes.isEmpty();
    }

    @Override
    public A addNewPvcVolume(String volumeName, String claimName, Boolean readOnly) {
        return this.addToPvcVolumes(new PersistentVolumeClaimVolume(volumeName, claimName, readOnly));
    }

    @Override
    public BaseConfigFluent.PvcVolumesNested<A> addNewPvcVolume() {
        return new PvcVolumesNestedImpl();
    }

    @Override
    public BaseConfigFluent.PvcVolumesNested<A> addNewPvcVolumeLike(PersistentVolumeClaimVolume item) {
        return new PvcVolumesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.PvcVolumesNested<A> setNewPvcVolumeLike(Integer index, PersistentVolumeClaimVolume item) {
        return new PvcVolumesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.PvcVolumesNested<A> editPvcVolume(Integer index) {
        if (this.pvcVolumes.size() <= index) {
            throw new RuntimeException("Can't edit pvcVolumes. Index exceeds size.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    @Override
    public BaseConfigFluent.PvcVolumesNested<A> editFirstPvcVolume() {
        if (this.pvcVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first pvcVolumes. The list is empty.");
        }
        return this.setNewPvcVolumeLike(0, this.buildPvcVolume(0));
    }

    @Override
    public BaseConfigFluent.PvcVolumesNested<A> editLastPvcVolume() {
        int index = this.pvcVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pvcVolumes. The list is empty.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    @Override
    public BaseConfigFluent.PvcVolumesNested<A> editMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pvcVolumes.size(); ++i) {
            if (!predicate.test(this.pvcVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pvcVolumes. No match found.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    @Override
    public A withSecretVolumes(SecretVolume ... secretVolumes) {
        if (this.secretVolumes != null) {
            this.secretVolumes.clear();
        }
        if (secretVolumes != null) {
            for (SecretVolume item : secretVolumes) {
                this.addToSecretVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public SecretVolume[] getSecretVolumes() {
        int size = this.secretVolumes != null ? this.secretVolumes.size() : 0;
        SecretVolume[] result = new SecretVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.secretVolumes) {
            result[index++] = (SecretVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public SecretVolume[] buildSecretVolumes() {
        int size = this.secretVolumes != null ? this.secretVolumes.size() : 0;
        SecretVolume[] result = new SecretVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.secretVolumes) {
            result[index++] = (SecretVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public SecretVolume buildSecretVolume(Integer index) {
        return this.secretVolumes.get(index).build();
    }

    @Override
    public SecretVolume buildFirstSecretVolume() {
        return this.secretVolumes.get(0).build();
    }

    @Override
    public SecretVolume buildLastSecretVolume() {
        return this.secretVolumes.get(this.secretVolumes.size() - 1).build();
    }

    @Override
    public SecretVolume buildMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        for (SecretVolumeBuilder item : this.secretVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        for (SecretVolumeBuilder item : this.secretVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToSecretVolumes(Integer index, SecretVolume item) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
        this._visitables.get((Object)"secretVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"secretVolumes").size(), builder);
        this.secretVolumes.add(index >= 0 ? index.intValue() : this.secretVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecretVolumes(Integer index, SecretVolume item) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"secretVolumes").size()) {
            this._visitables.get((Object)"secretVolumes").add(builder);
        } else {
            this._visitables.get((Object)"secretVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.secretVolumes.size()) {
            this.secretVolumes.add(builder);
        } else {
            this.secretVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecretVolumes(SecretVolume ... items) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecretVolumes(Collection<SecretVolume> items) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecretVolumes(SecretVolume ... items) {
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").remove(builder);
            if (this.secretVolumes == null) continue;
            this.secretVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecretVolumes(Collection<SecretVolume> items) {
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").remove(builder);
            if (this.secretVolumes == null) continue;
            this.secretVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecretVolumes(Predicate<SecretVolumeBuilder> predicate) {
        if (this.secretVolumes == null) {
            return (A)this;
        }
        Iterator<SecretVolumeBuilder> each = this.secretVolumes.iterator();
        List visitables = this._visitables.get((Object)"secretVolumes");
        while (each.hasNext()) {
            SecretVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretVolumes() {
        return this.secretVolumes != null && !this.secretVolumes.isEmpty();
    }

    @Override
    public BaseConfigFluent.SecretVolumesNested<A> addNewSecretVolume() {
        return new SecretVolumesNestedImpl();
    }

    @Override
    public BaseConfigFluent.SecretVolumesNested<A> addNewSecretVolumeLike(SecretVolume item) {
        return new SecretVolumesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.SecretVolumesNested<A> setNewSecretVolumeLike(Integer index, SecretVolume item) {
        return new SecretVolumesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.SecretVolumesNested<A> editSecretVolume(Integer index) {
        if (this.secretVolumes.size() <= index) {
            throw new RuntimeException("Can't edit secretVolumes. Index exceeds size.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    @Override
    public BaseConfigFluent.SecretVolumesNested<A> editFirstSecretVolume() {
        if (this.secretVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first secretVolumes. The list is empty.");
        }
        return this.setNewSecretVolumeLike(0, this.buildSecretVolume(0));
    }

    @Override
    public BaseConfigFluent.SecretVolumesNested<A> editLastSecretVolume() {
        int index = this.secretVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secretVolumes. The list is empty.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    @Override
    public BaseConfigFluent.SecretVolumesNested<A> editMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secretVolumes.size(); ++i) {
            if (!predicate.test(this.secretVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secretVolumes. No match found.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    @Override
    public A withConfigMapVolumes(ConfigMapVolume ... configMapVolumes) {
        if (this.configMapVolumes != null) {
            this.configMapVolumes.clear();
        }
        if (configMapVolumes != null) {
            for (ConfigMapVolume item : configMapVolumes) {
                this.addToConfigMapVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public ConfigMapVolume[] getConfigMapVolumes() {
        int size = this.configMapVolumes != null ? this.configMapVolumes.size() : 0;
        ConfigMapVolume[] result = new ConfigMapVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.configMapVolumes) {
            result[index++] = (ConfigMapVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public ConfigMapVolume[] buildConfigMapVolumes() {
        int size = this.configMapVolumes != null ? this.configMapVolumes.size() : 0;
        ConfigMapVolume[] result = new ConfigMapVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.configMapVolumes) {
            result[index++] = (ConfigMapVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public ConfigMapVolume buildConfigMapVolume(Integer index) {
        return this.configMapVolumes.get(index).build();
    }

    @Override
    public ConfigMapVolume buildFirstConfigMapVolume() {
        return this.configMapVolumes.get(0).build();
    }

    @Override
    public ConfigMapVolume buildLastConfigMapVolume() {
        return this.configMapVolumes.get(this.configMapVolumes.size() - 1).build();
    }

    @Override
    public ConfigMapVolume buildMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        for (ConfigMapVolumeBuilder item : this.configMapVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        for (ConfigMapVolumeBuilder item : this.configMapVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToConfigMapVolumes(Integer index, ConfigMapVolume item) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
        this._visitables.get((Object)"configMapVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"configMapVolumes").size(), builder);
        this.configMapVolumes.add(index >= 0 ? index.intValue() : this.configMapVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConfigMapVolumes(Integer index, ConfigMapVolume item) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"configMapVolumes").size()) {
            this._visitables.get((Object)"configMapVolumes").add(builder);
        } else {
            this._visitables.get((Object)"configMapVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.configMapVolumes.size()) {
            this.configMapVolumes.add(builder);
        } else {
            this.configMapVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConfigMapVolumes(ConfigMapVolume ... items) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigMapVolumes(Collection<ConfigMapVolume> items) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfigMapVolumes(ConfigMapVolume ... items) {
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").remove(builder);
            if (this.configMapVolumes == null) continue;
            this.configMapVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigMapVolumes(Collection<ConfigMapVolume> items) {
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").remove(builder);
            if (this.configMapVolumes == null) continue;
            this.configMapVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConfigMapVolumes(Predicate<ConfigMapVolumeBuilder> predicate) {
        if (this.configMapVolumes == null) {
            return (A)this;
        }
        Iterator<ConfigMapVolumeBuilder> each = this.configMapVolumes.iterator();
        List visitables = this._visitables.get((Object)"configMapVolumes");
        while (each.hasNext()) {
            ConfigMapVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigMapVolumes() {
        return this.configMapVolumes != null && !this.configMapVolumes.isEmpty();
    }

    @Override
    public BaseConfigFluent.ConfigMapVolumesNested<A> addNewConfigMapVolume() {
        return new ConfigMapVolumesNestedImpl();
    }

    @Override
    public BaseConfigFluent.ConfigMapVolumesNested<A> addNewConfigMapVolumeLike(ConfigMapVolume item) {
        return new ConfigMapVolumesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.ConfigMapVolumesNested<A> setNewConfigMapVolumeLike(Integer index, ConfigMapVolume item) {
        return new ConfigMapVolumesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.ConfigMapVolumesNested<A> editConfigMapVolume(Integer index) {
        if (this.configMapVolumes.size() <= index) {
            throw new RuntimeException("Can't edit configMapVolumes. Index exceeds size.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    @Override
    public BaseConfigFluent.ConfigMapVolumesNested<A> editFirstConfigMapVolume() {
        if (this.configMapVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first configMapVolumes. The list is empty.");
        }
        return this.setNewConfigMapVolumeLike(0, this.buildConfigMapVolume(0));
    }

    @Override
    public BaseConfigFluent.ConfigMapVolumesNested<A> editLastConfigMapVolume() {
        int index = this.configMapVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configMapVolumes. The list is empty.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    @Override
    public BaseConfigFluent.ConfigMapVolumesNested<A> editMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configMapVolumes.size(); ++i) {
            if (!predicate.test(this.configMapVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configMapVolumes. No match found.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    @Override
    public A withEmptyDirVolumes(EmptyDirVolume ... emptyDirVolumes) {
        if (this.emptyDirVolumes != null) {
            this.emptyDirVolumes.clear();
        }
        if (emptyDirVolumes != null) {
            for (EmptyDirVolume item : emptyDirVolumes) {
                this.addToEmptyDirVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public EmptyDirVolume[] getEmptyDirVolumes() {
        int size = this.emptyDirVolumes != null ? this.emptyDirVolumes.size() : 0;
        EmptyDirVolume[] result = new EmptyDirVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.emptyDirVolumes) {
            result[index++] = (EmptyDirVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public EmptyDirVolume[] buildEmptyDirVolumes() {
        int size = this.emptyDirVolumes != null ? this.emptyDirVolumes.size() : 0;
        EmptyDirVolume[] result = new EmptyDirVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.emptyDirVolumes) {
            result[index++] = (EmptyDirVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public EmptyDirVolume buildEmptyDirVolume(Integer index) {
        return this.emptyDirVolumes.get(index).build();
    }

    @Override
    public EmptyDirVolume buildFirstEmptyDirVolume() {
        return this.emptyDirVolumes.get(0).build();
    }

    @Override
    public EmptyDirVolume buildLastEmptyDirVolume() {
        return this.emptyDirVolumes.get(this.emptyDirVolumes.size() - 1).build();
    }

    @Override
    public EmptyDirVolume buildMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        for (EmptyDirVolumeBuilder item : this.emptyDirVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        for (EmptyDirVolumeBuilder item : this.emptyDirVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEmptyDirVolumes(Integer index, EmptyDirVolume item) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
        this._visitables.get((Object)"emptyDirVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"emptyDirVolumes").size(), builder);
        this.emptyDirVolumes.add(index >= 0 ? index.intValue() : this.emptyDirVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEmptyDirVolumes(Integer index, EmptyDirVolume item) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"emptyDirVolumes").size()) {
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
        } else {
            this._visitables.get((Object)"emptyDirVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.emptyDirVolumes.size()) {
            this.emptyDirVolumes.add(builder);
        } else {
            this.emptyDirVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEmptyDirVolumes(EmptyDirVolume ... items) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEmptyDirVolumes(Collection<EmptyDirVolume> items) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEmptyDirVolumes(EmptyDirVolume ... items) {
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").remove(builder);
            if (this.emptyDirVolumes == null) continue;
            this.emptyDirVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEmptyDirVolumes(Collection<EmptyDirVolume> items) {
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").remove(builder);
            if (this.emptyDirVolumes == null) continue;
            this.emptyDirVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEmptyDirVolumes(Predicate<EmptyDirVolumeBuilder> predicate) {
        if (this.emptyDirVolumes == null) {
            return (A)this;
        }
        Iterator<EmptyDirVolumeBuilder> each = this.emptyDirVolumes.iterator();
        List visitables = this._visitables.get((Object)"emptyDirVolumes");
        while (each.hasNext()) {
            EmptyDirVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasEmptyDirVolumes() {
        return this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty();
    }

    @Override
    public A addNewEmptyDirVolume(String volumeName) {
        return this.addToEmptyDirVolumes(new EmptyDirVolume(volumeName));
    }

    @Override
    public BaseConfigFluent.EmptyDirVolumesNested<A> addNewEmptyDirVolume() {
        return new EmptyDirVolumesNestedImpl();
    }

    @Override
    public BaseConfigFluent.EmptyDirVolumesNested<A> addNewEmptyDirVolumeLike(EmptyDirVolume item) {
        return new EmptyDirVolumesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.EmptyDirVolumesNested<A> setNewEmptyDirVolumeLike(Integer index, EmptyDirVolume item) {
        return new EmptyDirVolumesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.EmptyDirVolumesNested<A> editEmptyDirVolume(Integer index) {
        if (this.emptyDirVolumes.size() <= index) {
            throw new RuntimeException("Can't edit emptyDirVolumes. Index exceeds size.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    @Override
    public BaseConfigFluent.EmptyDirVolumesNested<A> editFirstEmptyDirVolume() {
        if (this.emptyDirVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first emptyDirVolumes. The list is empty.");
        }
        return this.setNewEmptyDirVolumeLike(0, this.buildEmptyDirVolume(0));
    }

    @Override
    public BaseConfigFluent.EmptyDirVolumesNested<A> editLastEmptyDirVolume() {
        int index = this.emptyDirVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last emptyDirVolumes. The list is empty.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    @Override
    public BaseConfigFluent.EmptyDirVolumesNested<A> editMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.emptyDirVolumes.size(); ++i) {
            if (!predicate.test(this.emptyDirVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching emptyDirVolumes. No match found.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    @Override
    public A withGitRepoVolumes(GitRepoVolume ... gitRepoVolumes) {
        if (this.gitRepoVolumes != null) {
            this.gitRepoVolumes.clear();
        }
        if (gitRepoVolumes != null) {
            for (GitRepoVolume item : gitRepoVolumes) {
                this.addToGitRepoVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public GitRepoVolume[] getGitRepoVolumes() {
        int size = this.gitRepoVolumes != null ? this.gitRepoVolumes.size() : 0;
        GitRepoVolume[] result = new GitRepoVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.gitRepoVolumes) {
            result[index++] = (GitRepoVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public GitRepoVolume[] buildGitRepoVolumes() {
        int size = this.gitRepoVolumes != null ? this.gitRepoVolumes.size() : 0;
        GitRepoVolume[] result = new GitRepoVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.gitRepoVolumes) {
            result[index++] = (GitRepoVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public GitRepoVolume buildGitRepoVolume(Integer index) {
        return this.gitRepoVolumes.get(index).build();
    }

    @Override
    public GitRepoVolume buildFirstGitRepoVolume() {
        return this.gitRepoVolumes.get(0).build();
    }

    @Override
    public GitRepoVolume buildLastGitRepoVolume() {
        return this.gitRepoVolumes.get(this.gitRepoVolumes.size() - 1).build();
    }

    @Override
    public GitRepoVolume buildMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
        for (GitRepoVolumeBuilder item : this.gitRepoVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
        for (GitRepoVolumeBuilder item : this.gitRepoVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToGitRepoVolumes(Integer index, GitRepoVolume item) {
        if (this.gitRepoVolumes == null) {
            this.gitRepoVolumes = new ArrayList();
        }
        GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
        this._visitables.get((Object)"gitRepoVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"gitRepoVolumes").size(), builder);
        this.gitRepoVolumes.add(index >= 0 ? index.intValue() : this.gitRepoVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToGitRepoVolumes(Integer index, GitRepoVolume item) {
        if (this.gitRepoVolumes == null) {
            this.gitRepoVolumes = new ArrayList();
        }
        GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"gitRepoVolumes").size()) {
            this._visitables.get((Object)"gitRepoVolumes").add(builder);
        } else {
            this._visitables.get((Object)"gitRepoVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.gitRepoVolumes.size()) {
            this.gitRepoVolumes.add(builder);
        } else {
            this.gitRepoVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToGitRepoVolumes(GitRepoVolume ... items) {
        if (this.gitRepoVolumes == null) {
            this.gitRepoVolumes = new ArrayList();
        }
        for (GitRepoVolume item : items) {
            GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
            this._visitables.get((Object)"gitRepoVolumes").add(builder);
            this.gitRepoVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToGitRepoVolumes(Collection<GitRepoVolume> items) {
        if (this.gitRepoVolumes == null) {
            this.gitRepoVolumes = new ArrayList();
        }
        for (GitRepoVolume item : items) {
            GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
            this._visitables.get((Object)"gitRepoVolumes").add(builder);
            this.gitRepoVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromGitRepoVolumes(GitRepoVolume ... items) {
        for (GitRepoVolume item : items) {
            GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
            this._visitables.get((Object)"gitRepoVolumes").remove(builder);
            if (this.gitRepoVolumes == null) continue;
            this.gitRepoVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGitRepoVolumes(Collection<GitRepoVolume> items) {
        for (GitRepoVolume item : items) {
            GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
            this._visitables.get((Object)"gitRepoVolumes").remove(builder);
            if (this.gitRepoVolumes == null) continue;
            this.gitRepoVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromGitRepoVolumes(Predicate<GitRepoVolumeBuilder> predicate) {
        if (this.gitRepoVolumes == null) {
            return (A)this;
        }
        Iterator<GitRepoVolumeBuilder> each = this.gitRepoVolumes.iterator();
        List visitables = this._visitables.get((Object)"gitRepoVolumes");
        while (each.hasNext()) {
            GitRepoVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasGitRepoVolumes() {
        return this.gitRepoVolumes != null && !this.gitRepoVolumes.isEmpty();
    }

    @Override
    public A addNewGitRepoVolume(String volumeName, String repository, String directory, String revision) {
        return this.addToGitRepoVolumes(new GitRepoVolume(volumeName, repository, directory, revision));
    }

    @Override
    public BaseConfigFluent.GitRepoVolumesNested<A> addNewGitRepoVolume() {
        return new GitRepoVolumesNestedImpl();
    }

    @Override
    public BaseConfigFluent.GitRepoVolumesNested<A> addNewGitRepoVolumeLike(GitRepoVolume item) {
        return new GitRepoVolumesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.GitRepoVolumesNested<A> setNewGitRepoVolumeLike(Integer index, GitRepoVolume item) {
        return new GitRepoVolumesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.GitRepoVolumesNested<A> editGitRepoVolume(Integer index) {
        if (this.gitRepoVolumes.size() <= index) {
            throw new RuntimeException("Can't edit gitRepoVolumes. Index exceeds size.");
        }
        return this.setNewGitRepoVolumeLike(index, this.buildGitRepoVolume(index));
    }

    @Override
    public BaseConfigFluent.GitRepoVolumesNested<A> editFirstGitRepoVolume() {
        if (this.gitRepoVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first gitRepoVolumes. The list is empty.");
        }
        return this.setNewGitRepoVolumeLike(0, this.buildGitRepoVolume(0));
    }

    @Override
    public BaseConfigFluent.GitRepoVolumesNested<A> editLastGitRepoVolume() {
        int index = this.gitRepoVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gitRepoVolumes. The list is empty.");
        }
        return this.setNewGitRepoVolumeLike(index, this.buildGitRepoVolume(index));
    }

    @Override
    public BaseConfigFluent.GitRepoVolumesNested<A> editMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gitRepoVolumes.size(); ++i) {
            if (!predicate.test(this.gitRepoVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gitRepoVolumes. No match found.");
        }
        return this.setNewGitRepoVolumeLike(index, this.buildGitRepoVolume(index));
    }

    @Override
    public A withAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... awsElasticBlockStoreVolumes) {
        if (this.awsElasticBlockStoreVolumes != null) {
            this.awsElasticBlockStoreVolumes.clear();
        }
        if (awsElasticBlockStoreVolumes != null) {
            for (AwsElasticBlockStoreVolume item : awsElasticBlockStoreVolumes) {
                this.addToAwsElasticBlockStoreVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public AwsElasticBlockStoreVolume[] getAwsElasticBlockStoreVolumes() {
        int size = this.awsElasticBlockStoreVolumes != null ? this.awsElasticBlockStoreVolumes.size() : 0;
        AwsElasticBlockStoreVolume[] result = new AwsElasticBlockStoreVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.awsElasticBlockStoreVolumes) {
            result[index++] = (AwsElasticBlockStoreVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AwsElasticBlockStoreVolume[] buildAwsElasticBlockStoreVolumes() {
        int size = this.awsElasticBlockStoreVolumes != null ? this.awsElasticBlockStoreVolumes.size() : 0;
        AwsElasticBlockStoreVolume[] result = new AwsElasticBlockStoreVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.awsElasticBlockStoreVolumes) {
            result[index++] = (AwsElasticBlockStoreVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AwsElasticBlockStoreVolume buildAwsElasticBlockStoreVolume(Integer index) {
        return this.awsElasticBlockStoreVolumes.get(index).build();
    }

    @Override
    public AwsElasticBlockStoreVolume buildFirstAwsElasticBlockStoreVolume() {
        return this.awsElasticBlockStoreVolumes.get(0).build();
    }

    @Override
    public AwsElasticBlockStoreVolume buildLastAwsElasticBlockStoreVolume() {
        return this.awsElasticBlockStoreVolumes.get(this.awsElasticBlockStoreVolumes.size() - 1).build();
    }

    @Override
    public AwsElasticBlockStoreVolume buildMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        for (AwsElasticBlockStoreVolumeBuilder item : this.awsElasticBlockStoreVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        for (AwsElasticBlockStoreVolumeBuilder item : this.awsElasticBlockStoreVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAwsElasticBlockStoreVolumes(Integer index, AwsElasticBlockStoreVolume item) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
        this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"awsElasticBlockStoreVolumes").size(), builder);
        this.awsElasticBlockStoreVolumes.add(index >= 0 ? index.intValue() : this.awsElasticBlockStoreVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAwsElasticBlockStoreVolumes(Integer index, AwsElasticBlockStoreVolume item) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"awsElasticBlockStoreVolumes").size()) {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
        } else {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.awsElasticBlockStoreVolumes.size()) {
            this.awsElasticBlockStoreVolumes.add(builder);
        } else {
            this.awsElasticBlockStoreVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... items) {
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").remove(builder);
            if (this.awsElasticBlockStoreVolumes == null) continue;
            this.awsElasticBlockStoreVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").remove(builder);
            if (this.awsElasticBlockStoreVolumes == null) continue;
            this.awsElasticBlockStoreVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAwsElasticBlockStoreVolumes(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        if (this.awsElasticBlockStoreVolumes == null) {
            return (A)this;
        }
        Iterator<AwsElasticBlockStoreVolumeBuilder> each = this.awsElasticBlockStoreVolumes.iterator();
        List visitables = this._visitables.get((Object)"awsElasticBlockStoreVolumes");
        while (each.hasNext()) {
            AwsElasticBlockStoreVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty();
    }

    @Override
    public A addNewAwsElasticBlockStoreVolume(String volumeName, String volumeId, Integer partition, String fsType, Boolean readOnly) {
        return this.addToAwsElasticBlockStoreVolumes(new AwsElasticBlockStoreVolume(volumeName, volumeId, partition, fsType, readOnly));
    }

    @Override
    public BaseConfigFluent.AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolume() {
        return new AwsElasticBlockStoreVolumesNestedImpl();
    }

    @Override
    public BaseConfigFluent.AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolumeLike(AwsElasticBlockStoreVolume item) {
        return new AwsElasticBlockStoreVolumesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.AwsElasticBlockStoreVolumesNested<A> setNewAwsElasticBlockStoreVolumeLike(Integer index, AwsElasticBlockStoreVolume item) {
        return new AwsElasticBlockStoreVolumesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.AwsElasticBlockStoreVolumesNested<A> editAwsElasticBlockStoreVolume(Integer index) {
        if (this.awsElasticBlockStoreVolumes.size() <= index) {
            throw new RuntimeException("Can't edit awsElasticBlockStoreVolumes. Index exceeds size.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    @Override
    public BaseConfigFluent.AwsElasticBlockStoreVolumesNested<A> editFirstAwsElasticBlockStoreVolume() {
        if (this.awsElasticBlockStoreVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first awsElasticBlockStoreVolumes. The list is empty.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(0, this.buildAwsElasticBlockStoreVolume(0));
    }

    @Override
    public BaseConfigFluent.AwsElasticBlockStoreVolumesNested<A> editLastAwsElasticBlockStoreVolume() {
        int index = this.awsElasticBlockStoreVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last awsElasticBlockStoreVolumes. The list is empty.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    @Override
    public BaseConfigFluent.AwsElasticBlockStoreVolumesNested<A> editMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.awsElasticBlockStoreVolumes.size(); ++i) {
            if (!predicate.test(this.awsElasticBlockStoreVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching awsElasticBlockStoreVolumes. No match found.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    @Override
    public A withAzureDiskVolumes(AzureDiskVolume ... azureDiskVolumes) {
        if (this.azureDiskVolumes != null) {
            this.azureDiskVolumes.clear();
        }
        if (azureDiskVolumes != null) {
            for (AzureDiskVolume item : azureDiskVolumes) {
                this.addToAzureDiskVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public AzureDiskVolume[] getAzureDiskVolumes() {
        int size = this.azureDiskVolumes != null ? this.azureDiskVolumes.size() : 0;
        AzureDiskVolume[] result = new AzureDiskVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureDiskVolumes) {
            result[index++] = (AzureDiskVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AzureDiskVolume[] buildAzureDiskVolumes() {
        int size = this.azureDiskVolumes != null ? this.azureDiskVolumes.size() : 0;
        AzureDiskVolume[] result = new AzureDiskVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureDiskVolumes) {
            result[index++] = (AzureDiskVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AzureDiskVolume buildAzureDiskVolume(Integer index) {
        return this.azureDiskVolumes.get(index).build();
    }

    @Override
    public AzureDiskVolume buildFirstAzureDiskVolume() {
        return this.azureDiskVolumes.get(0).build();
    }

    @Override
    public AzureDiskVolume buildLastAzureDiskVolume() {
        return this.azureDiskVolumes.get(this.azureDiskVolumes.size() - 1).build();
    }

    @Override
    public AzureDiskVolume buildMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        for (AzureDiskVolumeBuilder item : this.azureDiskVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        for (AzureDiskVolumeBuilder item : this.azureDiskVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAzureDiskVolumes(Integer index, AzureDiskVolume item) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
        this._visitables.get((Object)"azureDiskVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"azureDiskVolumes").size(), builder);
        this.azureDiskVolumes.add(index >= 0 ? index.intValue() : this.azureDiskVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAzureDiskVolumes(Integer index, AzureDiskVolume item) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"azureDiskVolumes").size()) {
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
        } else {
            this._visitables.get((Object)"azureDiskVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.azureDiskVolumes.size()) {
            this.azureDiskVolumes.add(builder);
        } else {
            this.azureDiskVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAzureDiskVolumes(AzureDiskVolume ... items) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAzureDiskVolumes(Collection<AzureDiskVolume> items) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAzureDiskVolumes(AzureDiskVolume ... items) {
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").remove(builder);
            if (this.azureDiskVolumes == null) continue;
            this.azureDiskVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAzureDiskVolumes(Collection<AzureDiskVolume> items) {
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").remove(builder);
            if (this.azureDiskVolumes == null) continue;
            this.azureDiskVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAzureDiskVolumes(Predicate<AzureDiskVolumeBuilder> predicate) {
        if (this.azureDiskVolumes == null) {
            return (A)this;
        }
        Iterator<AzureDiskVolumeBuilder> each = this.azureDiskVolumes.iterator();
        List visitables = this._visitables.get((Object)"azureDiskVolumes");
        while (each.hasNext()) {
            AzureDiskVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAzureDiskVolumes() {
        return this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty();
    }

    @Override
    public BaseConfigFluent.AzureDiskVolumesNested<A> addNewAzureDiskVolume() {
        return new AzureDiskVolumesNestedImpl();
    }

    @Override
    public BaseConfigFluent.AzureDiskVolumesNested<A> addNewAzureDiskVolumeLike(AzureDiskVolume item) {
        return new AzureDiskVolumesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.AzureDiskVolumesNested<A> setNewAzureDiskVolumeLike(Integer index, AzureDiskVolume item) {
        return new AzureDiskVolumesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.AzureDiskVolumesNested<A> editAzureDiskVolume(Integer index) {
        if (this.azureDiskVolumes.size() <= index) {
            throw new RuntimeException("Can't edit azureDiskVolumes. Index exceeds size.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    @Override
    public BaseConfigFluent.AzureDiskVolumesNested<A> editFirstAzureDiskVolume() {
        if (this.azureDiskVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first azureDiskVolumes. The list is empty.");
        }
        return this.setNewAzureDiskVolumeLike(0, this.buildAzureDiskVolume(0));
    }

    @Override
    public BaseConfigFluent.AzureDiskVolumesNested<A> editLastAzureDiskVolume() {
        int index = this.azureDiskVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last azureDiskVolumes. The list is empty.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    @Override
    public BaseConfigFluent.AzureDiskVolumesNested<A> editMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azureDiskVolumes.size(); ++i) {
            if (!predicate.test(this.azureDiskVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching azureDiskVolumes. No match found.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    @Override
    public A withAzureFileVolumes(AzureFileVolume ... azureFileVolumes) {
        if (this.azureFileVolumes != null) {
            this.azureFileVolumes.clear();
        }
        if (azureFileVolumes != null) {
            for (AzureFileVolume item : azureFileVolumes) {
                this.addToAzureFileVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public AzureFileVolume[] getAzureFileVolumes() {
        int size = this.azureFileVolumes != null ? this.azureFileVolumes.size() : 0;
        AzureFileVolume[] result = new AzureFileVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureFileVolumes) {
            result[index++] = (AzureFileVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AzureFileVolume[] buildAzureFileVolumes() {
        int size = this.azureFileVolumes != null ? this.azureFileVolumes.size() : 0;
        AzureFileVolume[] result = new AzureFileVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureFileVolumes) {
            result[index++] = (AzureFileVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AzureFileVolume buildAzureFileVolume(Integer index) {
        return this.azureFileVolumes.get(index).build();
    }

    @Override
    public AzureFileVolume buildFirstAzureFileVolume() {
        return this.azureFileVolumes.get(0).build();
    }

    @Override
    public AzureFileVolume buildLastAzureFileVolume() {
        return this.azureFileVolumes.get(this.azureFileVolumes.size() - 1).build();
    }

    @Override
    public AzureFileVolume buildMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        for (AzureFileVolumeBuilder item : this.azureFileVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        for (AzureFileVolumeBuilder item : this.azureFileVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAzureFileVolumes(Integer index, AzureFileVolume item) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
        this._visitables.get((Object)"azureFileVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"azureFileVolumes").size(), builder);
        this.azureFileVolumes.add(index >= 0 ? index.intValue() : this.azureFileVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAzureFileVolumes(Integer index, AzureFileVolume item) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"azureFileVolumes").size()) {
            this._visitables.get((Object)"azureFileVolumes").add(builder);
        } else {
            this._visitables.get((Object)"azureFileVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.azureFileVolumes.size()) {
            this.azureFileVolumes.add(builder);
        } else {
            this.azureFileVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAzureFileVolumes(AzureFileVolume ... items) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAzureFileVolumes(Collection<AzureFileVolume> items) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAzureFileVolumes(AzureFileVolume ... items) {
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").remove(builder);
            if (this.azureFileVolumes == null) continue;
            this.azureFileVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAzureFileVolumes(Collection<AzureFileVolume> items) {
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").remove(builder);
            if (this.azureFileVolumes == null) continue;
            this.azureFileVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAzureFileVolumes(Predicate<AzureFileVolumeBuilder> predicate) {
        if (this.azureFileVolumes == null) {
            return (A)this;
        }
        Iterator<AzureFileVolumeBuilder> each = this.azureFileVolumes.iterator();
        List visitables = this._visitables.get((Object)"azureFileVolumes");
        while (each.hasNext()) {
            AzureFileVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAzureFileVolumes() {
        return this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty();
    }

    @Override
    public A addNewAzureFileVolume(String volumeName, String shareName, String secretName, Boolean readOnly) {
        return this.addToAzureFileVolumes(new AzureFileVolume(volumeName, shareName, secretName, readOnly));
    }

    @Override
    public BaseConfigFluent.AzureFileVolumesNested<A> addNewAzureFileVolume() {
        return new AzureFileVolumesNestedImpl();
    }

    @Override
    public BaseConfigFluent.AzureFileVolumesNested<A> addNewAzureFileVolumeLike(AzureFileVolume item) {
        return new AzureFileVolumesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.AzureFileVolumesNested<A> setNewAzureFileVolumeLike(Integer index, AzureFileVolume item) {
        return new AzureFileVolumesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.AzureFileVolumesNested<A> editAzureFileVolume(Integer index) {
        if (this.azureFileVolumes.size() <= index) {
            throw new RuntimeException("Can't edit azureFileVolumes. Index exceeds size.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    @Override
    public BaseConfigFluent.AzureFileVolumesNested<A> editFirstAzureFileVolume() {
        if (this.azureFileVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first azureFileVolumes. The list is empty.");
        }
        return this.setNewAzureFileVolumeLike(0, this.buildAzureFileVolume(0));
    }

    @Override
    public BaseConfigFluent.AzureFileVolumesNested<A> editLastAzureFileVolume() {
        int index = this.azureFileVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last azureFileVolumes. The list is empty.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    @Override
    public BaseConfigFluent.AzureFileVolumesNested<A> editMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azureFileVolumes.size(); ++i) {
            if (!predicate.test(this.azureFileVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching azureFileVolumes. No match found.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    @Override
    public A withMounts(Mount ... mounts) {
        if (this.mounts != null) {
            this.mounts.clear();
        }
        if (mounts != null) {
            for (Mount item : mounts) {
                this.addToMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Mount[] getMounts() {
        int size = this.mounts != null ? this.mounts.size() : 0;
        Mount[] result = new Mount[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.mounts) {
            result[index++] = (Mount)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Mount[] buildMounts() {
        int size = this.mounts != null ? this.mounts.size() : 0;
        Mount[] result = new Mount[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.mounts) {
            result[index++] = (Mount)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Mount buildMount(Integer index) {
        return this.mounts.get(index).build();
    }

    @Override
    public Mount buildFirstMount() {
        return this.mounts.get(0).build();
    }

    @Override
    public Mount buildLastMount() {
        return this.mounts.get(this.mounts.size() - 1).build();
    }

    @Override
    public Mount buildMatchingMount(Predicate<MountBuilder> predicate) {
        for (MountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMount(Predicate<MountBuilder> predicate) {
        for (MountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToMounts(Integer index, Mount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        MountBuilder builder = new MountBuilder(item);
        this._visitables.get((Object)"mounts").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"mounts").size(), builder);
        this.mounts.add(index >= 0 ? index.intValue() : this.mounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMounts(Integer index, Mount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        MountBuilder builder = new MountBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"mounts").size()) {
            this._visitables.get((Object)"mounts").add(builder);
        } else {
            this._visitables.get((Object)"mounts").set(index, builder);
        }
        if (index < 0 || index >= this.mounts.size()) {
            this.mounts.add(builder);
        } else {
            this.mounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMounts(Mount ... items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMounts(Collection<Mount> items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMounts(Mount ... items) {
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").remove(builder);
            if (this.mounts == null) continue;
            this.mounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMounts(Collection<Mount> items) {
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").remove(builder);
            if (this.mounts == null) continue;
            this.mounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMounts(Predicate<MountBuilder> predicate) {
        if (this.mounts == null) {
            return (A)this;
        }
        Iterator<MountBuilder> each = this.mounts.iterator();
        List visitables = this._visitables.get((Object)"mounts");
        while (each.hasNext()) {
            MountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasMounts() {
        return this.mounts != null && !this.mounts.isEmpty();
    }

    @Override
    public A addNewMount(String name, String path, String subPath, Boolean readOnly) {
        return this.addToMounts(new Mount(name, path, subPath, readOnly));
    }

    @Override
    public BaseConfigFluent.MountsNested<A> addNewMount() {
        return new MountsNestedImpl();
    }

    @Override
    public BaseConfigFluent.MountsNested<A> addNewMountLike(Mount item) {
        return new MountsNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.MountsNested<A> setNewMountLike(Integer index, Mount item) {
        return new MountsNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.MountsNested<A> editMount(Integer index) {
        if (this.mounts.size() <= index) {
            throw new RuntimeException("Can't edit mounts. Index exceeds size.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public BaseConfigFluent.MountsNested<A> editFirstMount() {
        if (this.mounts.size() == 0) {
            throw new RuntimeException("Can't edit first mounts. The list is empty.");
        }
        return this.setNewMountLike(0, this.buildMount(0));
    }

    @Override
    public BaseConfigFluent.MountsNested<A> editLastMount() {
        int index = this.mounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mounts. The list is empty.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public BaseConfigFluent.MountsNested<A> editMatchingMount(Predicate<MountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mounts.size(); ++i) {
            if (!predicate.test(this.mounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mounts. No match found.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public A withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    @Override
    public A withImagePullSecrets(String ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (String item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getImagePullSecrets() {
        int size = this.imagePullSecrets != null ? this.imagePullSecrets.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.imagePullSecrets) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToImagePullSecrets(Integer index, String item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<String>();
        }
        this.imagePullSecrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(Integer index, String item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<String>();
        }
        this.imagePullSecrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(String ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<String> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(String ... items) {
        for (String item : items) {
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<String> items) {
        for (String item : items) {
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public HostAlias[] getHostAliases() {
        int size = this.hostAliases != null ? this.hostAliases.size() : 0;
        HostAlias[] result = new HostAlias[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.hostAliases) {
            result[index++] = (HostAlias)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public HostAlias[] buildHostAliases() {
        int size = this.hostAliases != null ? this.hostAliases.size() : 0;
        HostAlias[] result = new HostAlias[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.hostAliases) {
            result[index++] = (HostAlias)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public HostAlias buildHostAlias(Integer index) {
        return this.hostAliases.get(index).build();
    }

    @Override
    public HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    @Override
    public HostAlias buildLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1).build();
    }

    @Override
    public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToHostAliases(Integer index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        this._visitables.get((Object)"hostAliases").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"hostAliases").size(), builder);
        this.hostAliases.add(index >= 0 ? index.intValue() : this.hostAliases.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHostAliases(Integer index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"hostAliases").size()) {
            this._visitables.get((Object)"hostAliases").add(builder);
        } else {
            this._visitables.get((Object)"hostAliases").set(index, builder);
        }
        if (index < 0 || index >= this.hostAliases.size()) {
            this.hostAliases.add(builder);
        } else {
            this.hostAliases.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get((Object)"hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get((Object)"hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostAliases(HostAlias ... items) {
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get((Object)"hostAliases").remove(builder);
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get((Object)"hostAliases").remove(builder);
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        Iterator<HostAliasBuilder> each = this.hostAliases.iterator();
        List visitables = this._visitables.get((Object)"hostAliases");
        while (each.hasNext()) {
            HostAliasBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    @Override
    public A addNewHostAlias(String ip, String hostnames) {
        return this.addToHostAliases(new HostAlias(ip, hostnames));
    }

    @Override
    public BaseConfigFluent.HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNestedImpl();
    }

    @Override
    public BaseConfigFluent.HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
        return new HostAliasesNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.HostAliasesNested<A> setNewHostAliasLike(Integer index, HostAlias item) {
        return new HostAliasesNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.HostAliasesNested<A> editHostAlias(Integer index) {
        if (this.hostAliases.size() <= index) {
            throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public BaseConfigFluent.HostAliasesNested<A> editFirstHostAlias() {
        if (this.hostAliases.size() == 0) {
            throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(0, this.buildHostAlias(0));
    }

    @Override
    public BaseConfigFluent.HostAliasesNested<A> editLastHostAlias() {
        int index = this.hostAliases.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public BaseConfigFluent.HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostAliases.size(); ++i) {
            if (!predicate.test(this.hostAliases.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public BaseConfigFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public BaseConfigFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public BaseConfigFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public BaseConfigFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public BaseConfigFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public BaseConfigFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public BaseConfigFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public BaseConfigFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public BaseConfigFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public BaseConfigFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    @Override
    public Probe buildStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    @Override
    public A withStartupProbe(Probe startupProbe) {
        this._visitables.get((Object)"startupProbe").remove(this.startupProbe);
        if (startupProbe != null) {
            this.startupProbe = new ProbeBuilder(startupProbe);
            this._visitables.get((Object)"startupProbe").add(this.startupProbe);
        } else {
            this.startupProbe = null;
            this._visitables.get((Object)"startupProbe").remove(this.startupProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    @Override
    public BaseConfigFluent.StartupProbeNested<A> withNewStartupProbe() {
        return new StartupProbeNestedImpl();
    }

    @Override
    public BaseConfigFluent.StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
        return new StartupProbeNestedImpl(item);
    }

    @Override
    public BaseConfigFluent.StartupProbeNested<A> editStartupProbe() {
        return this.withNewStartupProbeLike(this.getStartupProbe());
    }

    @Override
    public BaseConfigFluent.StartupProbeNested<A> editOrNewStartupProbe() {
        return this.withNewStartupProbeLike(this.getStartupProbe() != null ? this.getStartupProbe() : new ProbeBuilder().build());
    }

    @Override
    public BaseConfigFluent.StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
        return this.withNewStartupProbeLike(this.getStartupProbe() != null ? this.getStartupProbe() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getRequestResources() {
        return this.requestResources != null ? this.requestResources.build() : null;
    }

    @Override
    public ResourceRequirements buildRequestResources() {
        return this.requestResources != null ? this.requestResources.build() : null;
    }

    @Override
    public A withRequestResources(ResourceRequirements requestResources) {
        this._visitables.get((Object)"requestResources").remove(this.requestResources);
        if (requestResources != null) {
            this.requestResources = new ResourceRequirementsBuilder(requestResources);
            this._visitables.get((Object)"requestResources").add(this.requestResources);
        } else {
            this.requestResources = null;
            this._visitables.get((Object)"requestResources").remove(this.requestResources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequestResources() {
        return this.requestResources != null;
    }

    @Override
    public A withNewRequestResources(String memory, String cpu) {
        return this.withRequestResources(new ResourceRequirements(memory, cpu));
    }

    @Override
    public BaseConfigFluent.RequestResourcesNested<A> withNewRequestResources() {
        return new RequestResourcesNestedImpl();
    }

    @Override
    public BaseConfigFluent.RequestResourcesNested<A> withNewRequestResourcesLike(ResourceRequirements item) {
        return new RequestResourcesNestedImpl(item);
    }

    @Override
    public BaseConfigFluent.RequestResourcesNested<A> editRequestResources() {
        return this.withNewRequestResourcesLike(this.getRequestResources());
    }

    @Override
    public BaseConfigFluent.RequestResourcesNested<A> editOrNewRequestResources() {
        return this.withNewRequestResourcesLike(this.getRequestResources() != null ? this.getRequestResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public BaseConfigFluent.RequestResourcesNested<A> editOrNewRequestResourcesLike(ResourceRequirements item) {
        return this.withNewRequestResourcesLike(this.getRequestResources() != null ? this.getRequestResources() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getLimitResources() {
        return this.limitResources != null ? this.limitResources.build() : null;
    }

    @Override
    public ResourceRequirements buildLimitResources() {
        return this.limitResources != null ? this.limitResources.build() : null;
    }

    @Override
    public A withLimitResources(ResourceRequirements limitResources) {
        this._visitables.get((Object)"limitResources").remove(this.limitResources);
        if (limitResources != null) {
            this.limitResources = new ResourceRequirementsBuilder(limitResources);
            this._visitables.get((Object)"limitResources").add(this.limitResources);
        } else {
            this.limitResources = null;
            this._visitables.get((Object)"limitResources").remove(this.limitResources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLimitResources() {
        return this.limitResources != null;
    }

    @Override
    public A withNewLimitResources(String memory, String cpu) {
        return this.withLimitResources(new ResourceRequirements(memory, cpu));
    }

    @Override
    public BaseConfigFluent.LimitResourcesNested<A> withNewLimitResources() {
        return new LimitResourcesNestedImpl();
    }

    @Override
    public BaseConfigFluent.LimitResourcesNested<A> withNewLimitResourcesLike(ResourceRequirements item) {
        return new LimitResourcesNestedImpl(item);
    }

    @Override
    public BaseConfigFluent.LimitResourcesNested<A> editLimitResources() {
        return this.withNewLimitResourcesLike(this.getLimitResources());
    }

    @Override
    public BaseConfigFluent.LimitResourcesNested<A> editOrNewLimitResources() {
        return this.withNewLimitResourcesLike(this.getLimitResources() != null ? this.getLimitResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public BaseConfigFluent.LimitResourcesNested<A> editOrNewLimitResourcesLike(ResourceRequirements item) {
        return this.withNewLimitResourcesLike(this.getLimitResources() != null ? this.getLimitResources() : item);
    }

    @Override
    public A withSidecars(Container ... sidecars) {
        if (this.sidecars != null) {
            this.sidecars.clear();
        }
        if (sidecars != null) {
            for (Container item : sidecars) {
                this.addToSidecars(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Container[] getSidecars() {
        int size = this.sidecars != null ? this.sidecars.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.sidecars) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container[] buildSidecars() {
        int size = this.sidecars != null ? this.sidecars.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.sidecars) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container buildSidecar(Integer index) {
        return this.sidecars.get(index).build();
    }

    @Override
    public Container buildFirstSidecar() {
        return this.sidecars.get(0).build();
    }

    @Override
    public Container buildLastSidecar() {
        return this.sidecars.get(this.sidecars.size() - 1).build();
    }

    @Override
    public Container buildMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToSidecars(Integer index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"sidecars").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"sidecars").size(), builder);
        this.sidecars.add(index >= 0 ? index.intValue() : this.sidecars.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSidecars(Integer index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"sidecars").size()) {
            this._visitables.get((Object)"sidecars").add(builder);
        } else {
            this._visitables.get((Object)"sidecars").set(index, builder);
        }
        if (index < 0 || index >= this.sidecars.size()) {
            this.sidecars.add(builder);
        } else {
            this.sidecars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSidecars(Container ... items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSidecars(Collection<Container> items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSidecars(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").remove(builder);
            if (this.sidecars == null) continue;
            this.sidecars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSidecars(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").remove(builder);
            if (this.sidecars == null) continue;
            this.sidecars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSidecars(Predicate<ContainerBuilder> predicate) {
        if (this.sidecars == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.sidecars.iterator();
        List visitables = this._visitables.get((Object)"sidecars");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasSidecars() {
        return this.sidecars != null && !this.sidecars.isEmpty();
    }

    @Override
    public BaseConfigFluent.SidecarsNested<A> addNewSidecar() {
        return new SidecarsNestedImpl();
    }

    @Override
    public BaseConfigFluent.SidecarsNested<A> addNewSidecarLike(Container item) {
        return new SidecarsNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.SidecarsNested<A> setNewSidecarLike(Integer index, Container item) {
        return new SidecarsNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.SidecarsNested<A> editSidecar(Integer index) {
        if (this.sidecars.size() <= index) {
            throw new RuntimeException("Can't edit sidecars. Index exceeds size.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    public BaseConfigFluent.SidecarsNested<A> editFirstSidecar() {
        if (this.sidecars.size() == 0) {
            throw new RuntimeException("Can't edit first sidecars. The list is empty.");
        }
        return this.setNewSidecarLike(0, this.buildSidecar(0));
    }

    @Override
    public BaseConfigFluent.SidecarsNested<A> editLastSidecar() {
        int index = this.sidecars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sidecars. The list is empty.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    public BaseConfigFluent.SidecarsNested<A> editMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecars.size(); ++i) {
            if (!predicate.test(this.sidecars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sidecars. No match found.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    @Override
    public A withAutoDeployEnabled(Boolean autoDeployEnabled) {
        this.autoDeployEnabled = autoDeployEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasAutoDeployEnabled() {
        return this.autoDeployEnabled != null;
    }

    @Override
    public A withJobs(Job ... jobs) {
        if (this.jobs != null) {
            this.jobs.clear();
        }
        if (jobs != null) {
            for (Job item : jobs) {
                this.addToJobs(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Job[] getJobs() {
        int size = this.jobs != null ? this.jobs.size() : 0;
        Job[] result = new Job[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.jobs) {
            result[index++] = (Job)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Job[] buildJobs() {
        int size = this.jobs != null ? this.jobs.size() : 0;
        Job[] result = new Job[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.jobs) {
            result[index++] = (Job)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Job buildJob(Integer index) {
        return this.jobs.get(index).build();
    }

    @Override
    public Job buildFirstJob() {
        return this.jobs.get(0).build();
    }

    @Override
    public Job buildLastJob() {
        return this.jobs.get(this.jobs.size() - 1).build();
    }

    @Override
    public Job buildMatchingJob(Predicate<JobBuilder> predicate) {
        for (JobBuilder item : this.jobs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingJob(Predicate<JobBuilder> predicate) {
        for (JobBuilder item : this.jobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToJobs(Integer index, Job item) {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        JobBuilder builder = new JobBuilder(item);
        this._visitables.get((Object)"jobs").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"jobs").size(), builder);
        this.jobs.add(index >= 0 ? index.intValue() : this.jobs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToJobs(Integer index, Job item) {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        JobBuilder builder = new JobBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"jobs").size()) {
            this._visitables.get((Object)"jobs").add(builder);
        } else {
            this._visitables.get((Object)"jobs").set(index, builder);
        }
        if (index < 0 || index >= this.jobs.size()) {
            this.jobs.add(builder);
        } else {
            this.jobs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToJobs(Job ... items) {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        for (Job item : items) {
            JobBuilder builder = new JobBuilder(item);
            this._visitables.get((Object)"jobs").add(builder);
            this.jobs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToJobs(Collection<Job> items) {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        for (Job item : items) {
            JobBuilder builder = new JobBuilder(item);
            this._visitables.get((Object)"jobs").add(builder);
            this.jobs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromJobs(Job ... items) {
        for (Job item : items) {
            JobBuilder builder = new JobBuilder(item);
            this._visitables.get((Object)"jobs").remove(builder);
            if (this.jobs == null) continue;
            this.jobs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJobs(Collection<Job> items) {
        for (Job item : items) {
            JobBuilder builder = new JobBuilder(item);
            this._visitables.get((Object)"jobs").remove(builder);
            if (this.jobs == null) continue;
            this.jobs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromJobs(Predicate<JobBuilder> predicate) {
        if (this.jobs == null) {
            return (A)this;
        }
        Iterator<JobBuilder> each = this.jobs.iterator();
        List visitables = this._visitables.get((Object)"jobs");
        while (each.hasNext()) {
            JobBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasJobs() {
        return this.jobs != null && !this.jobs.isEmpty();
    }

    @Override
    public BaseConfigFluent.JobsNested<A> addNewJob() {
        return new JobsNestedImpl();
    }

    @Override
    public BaseConfigFluent.JobsNested<A> addNewJobLike(Job item) {
        return new JobsNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.JobsNested<A> setNewJobLike(Integer index, Job item) {
        return new JobsNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.JobsNested<A> editJob(Integer index) {
        if (this.jobs.size() <= index) {
            throw new RuntimeException("Can't edit jobs. Index exceeds size.");
        }
        return this.setNewJobLike(index, this.buildJob(index));
    }

    @Override
    public BaseConfigFluent.JobsNested<A> editFirstJob() {
        if (this.jobs.size() == 0) {
            throw new RuntimeException("Can't edit first jobs. The list is empty.");
        }
        return this.setNewJobLike(0, this.buildJob(0));
    }

    @Override
    public BaseConfigFluent.JobsNested<A> editLastJob() {
        int index = this.jobs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last jobs. The list is empty.");
        }
        return this.setNewJobLike(index, this.buildJob(index));
    }

    @Override
    public BaseConfigFluent.JobsNested<A> editMatchingJob(Predicate<JobBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.jobs.size(); ++i) {
            if (!predicate.test(this.jobs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching jobs. No match found.");
        }
        return this.setNewJobLike(index, this.buildJob(index));
    }

    @Override
    public A withCronJobs(CronJob ... cronJobs) {
        if (this.cronJobs != null) {
            this.cronJobs.clear();
        }
        if (cronJobs != null) {
            for (CronJob item : cronJobs) {
                this.addToCronJobs(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public CronJob[] getCronJobs() {
        int size = this.cronJobs != null ? this.cronJobs.size() : 0;
        CronJob[] result = new CronJob[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.cronJobs) {
            result[index++] = (CronJob)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public CronJob[] buildCronJobs() {
        int size = this.cronJobs != null ? this.cronJobs.size() : 0;
        CronJob[] result = new CronJob[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.cronJobs) {
            result[index++] = (CronJob)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public CronJob buildCronJob(Integer index) {
        return this.cronJobs.get(index).build();
    }

    @Override
    public CronJob buildFirstCronJob() {
        return this.cronJobs.get(0).build();
    }

    @Override
    public CronJob buildLastCronJob() {
        return this.cronJobs.get(this.cronJobs.size() - 1).build();
    }

    @Override
    public CronJob buildMatchingCronJob(Predicate<CronJobBuilder> predicate) {
        for (CronJobBuilder item : this.cronJobs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCronJob(Predicate<CronJobBuilder> predicate) {
        for (CronJobBuilder item : this.cronJobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToCronJobs(Integer index, CronJob item) {
        if (this.cronJobs == null) {
            this.cronJobs = new ArrayList();
        }
        CronJobBuilder builder = new CronJobBuilder(item);
        this._visitables.get((Object)"cronJobs").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"cronJobs").size(), builder);
        this.cronJobs.add(index >= 0 ? index.intValue() : this.cronJobs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCronJobs(Integer index, CronJob item) {
        if (this.cronJobs == null) {
            this.cronJobs = new ArrayList();
        }
        CronJobBuilder builder = new CronJobBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"cronJobs").size()) {
            this._visitables.get((Object)"cronJobs").add(builder);
        } else {
            this._visitables.get((Object)"cronJobs").set(index, builder);
        }
        if (index < 0 || index >= this.cronJobs.size()) {
            this.cronJobs.add(builder);
        } else {
            this.cronJobs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCronJobs(CronJob ... items) {
        if (this.cronJobs == null) {
            this.cronJobs = new ArrayList();
        }
        for (CronJob item : items) {
            CronJobBuilder builder = new CronJobBuilder(item);
            this._visitables.get((Object)"cronJobs").add(builder);
            this.cronJobs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCronJobs(Collection<CronJob> items) {
        if (this.cronJobs == null) {
            this.cronJobs = new ArrayList();
        }
        for (CronJob item : items) {
            CronJobBuilder builder = new CronJobBuilder(item);
            this._visitables.get((Object)"cronJobs").add(builder);
            this.cronJobs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCronJobs(CronJob ... items) {
        for (CronJob item : items) {
            CronJobBuilder builder = new CronJobBuilder(item);
            this._visitables.get((Object)"cronJobs").remove(builder);
            if (this.cronJobs == null) continue;
            this.cronJobs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCronJobs(Collection<CronJob> items) {
        for (CronJob item : items) {
            CronJobBuilder builder = new CronJobBuilder(item);
            this._visitables.get((Object)"cronJobs").remove(builder);
            if (this.cronJobs == null) continue;
            this.cronJobs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCronJobs(Predicate<CronJobBuilder> predicate) {
        if (this.cronJobs == null) {
            return (A)this;
        }
        Iterator<CronJobBuilder> each = this.cronJobs.iterator();
        List visitables = this._visitables.get((Object)"cronJobs");
        while (each.hasNext()) {
            CronJobBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasCronJobs() {
        return this.cronJobs != null && !this.cronJobs.isEmpty();
    }

    @Override
    public BaseConfigFluent.CronJobsNested<A> addNewCronJob() {
        return new CronJobsNestedImpl();
    }

    @Override
    public BaseConfigFluent.CronJobsNested<A> addNewCronJobLike(CronJob item) {
        return new CronJobsNestedImpl(-1, item);
    }

    @Override
    public BaseConfigFluent.CronJobsNested<A> setNewCronJobLike(Integer index, CronJob item) {
        return new CronJobsNestedImpl(index, item);
    }

    @Override
    public BaseConfigFluent.CronJobsNested<A> editCronJob(Integer index) {
        if (this.cronJobs.size() <= index) {
            throw new RuntimeException("Can't edit cronJobs. Index exceeds size.");
        }
        return this.setNewCronJobLike(index, this.buildCronJob(index));
    }

    @Override
    public BaseConfigFluent.CronJobsNested<A> editFirstCronJob() {
        if (this.cronJobs.size() == 0) {
            throw new RuntimeException("Can't edit first cronJobs. The list is empty.");
        }
        return this.setNewCronJobLike(0, this.buildCronJob(0));
    }

    @Override
    public BaseConfigFluent.CronJobsNested<A> editLastCronJob() {
        int index = this.cronJobs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last cronJobs. The list is empty.");
        }
        return this.setNewCronJobLike(index, this.buildCronJob(index));
    }

    @Override
    public BaseConfigFluent.CronJobsNested<A> editMatchingCronJob(Predicate<CronJobBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.cronJobs.size(); ++i) {
            if (!predicate.test(this.cronJobs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching cronJobs. No match found.");
        }
        return this.setNewCronJobLike(index, this.buildCronJob(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseConfigFluentImpl that = (BaseConfigFluentImpl)o;
        if (this.deploymentKind != null ? !this.deploymentKind.equals(that.deploymentKind) : that.deploymentKind != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.envVars != null ? !this.envVars.equals(that.envVars) : that.envVars != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.serviceType != null ? !this.serviceType.equals((Object)that.serviceType) : that.serviceType != null) {
            return false;
        }
        if (this.pvcVolumes != null ? !this.pvcVolumes.equals(that.pvcVolumes) : that.pvcVolumes != null) {
            return false;
        }
        if (this.secretVolumes != null ? !this.secretVolumes.equals(that.secretVolumes) : that.secretVolumes != null) {
            return false;
        }
        if (this.configMapVolumes != null ? !this.configMapVolumes.equals(that.configMapVolumes) : that.configMapVolumes != null) {
            return false;
        }
        if (this.emptyDirVolumes != null ? !this.emptyDirVolumes.equals(that.emptyDirVolumes) : that.emptyDirVolumes != null) {
            return false;
        }
        if (this.gitRepoVolumes != null ? !this.gitRepoVolumes.equals(that.gitRepoVolumes) : that.gitRepoVolumes != null) {
            return false;
        }
        if (this.awsElasticBlockStoreVolumes != null ? !this.awsElasticBlockStoreVolumes.equals(that.awsElasticBlockStoreVolumes) : that.awsElasticBlockStoreVolumes != null) {
            return false;
        }
        if (this.azureDiskVolumes != null ? !this.azureDiskVolumes.equals(that.azureDiskVolumes) : that.azureDiskVolumes != null) {
            return false;
        }
        if (this.azureFileVolumes != null ? !this.azureFileVolumes.equals(that.azureFileVolumes) : that.azureFileVolumes != null) {
            return false;
        }
        if (this.mounts != null ? !this.mounts.equals(that.mounts) : that.mounts != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals((Object)that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.startupProbe != null ? !this.startupProbe.equals(that.startupProbe) : that.startupProbe != null) {
            return false;
        }
        if (this.requestResources != null ? !this.requestResources.equals(that.requestResources) : that.requestResources != null) {
            return false;
        }
        if (this.limitResources != null ? !this.limitResources.equals(that.limitResources) : that.limitResources != null) {
            return false;
        }
        if (this.sidecars != null ? !this.sidecars.equals(that.sidecars) : that.sidecars != null) {
            return false;
        }
        if (this.autoDeployEnabled != null ? !this.autoDeployEnabled.equals(that.autoDeployEnabled) : that.autoDeployEnabled != null) {
            return false;
        }
        if (this.jobs != null ? !this.jobs.equals(that.jobs) : that.jobs != null) {
            return false;
        }
        return !(this.cronJobs != null ? !this.cronJobs.equals(that.cronJobs) : that.cronJobs != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.deploymentKind, this.labels, this.annotations, this.envVars, this.workingDir, this.command, this.arguments, this.serviceAccount, this.ports, this.serviceType, this.pvcVolumes, this.secretVolumes, this.configMapVolumes, this.emptyDirVolumes, this.gitRepoVolumes, this.awsElasticBlockStoreVolumes, this.azureDiskVolumes, this.azureFileVolumes, this.mounts, this.imagePullPolicy, this.imagePullSecrets, this.hostAliases, this.livenessProbe, this.readinessProbe, this.startupProbe, this.requestResources, this.limitResources, this.sidecars, this.autoDeployEnabled, this.jobs, this.cronJobs, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentKind != null) {
            sb.append("deploymentKind:");
            sb.append(this.deploymentKind + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.envVars != null && !this.envVars.isEmpty()) {
            sb.append("envVars:");
            sb.append(this.envVars + ",");
        }
        if (this.workingDir != null) {
            sb.append("workingDir:");
            sb.append(this.workingDir + ",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            sb.append("arguments:");
            sb.append(this.arguments + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.serviceType != null) {
            sb.append("serviceType:");
            sb.append((Object)((Object)this.serviceType) + ",");
        }
        if (this.pvcVolumes != null && !this.pvcVolumes.isEmpty()) {
            sb.append("pvcVolumes:");
            sb.append(this.pvcVolumes + ",");
        }
        if (this.secretVolumes != null && !this.secretVolumes.isEmpty()) {
            sb.append("secretVolumes:");
            sb.append(this.secretVolumes + ",");
        }
        if (this.configMapVolumes != null && !this.configMapVolumes.isEmpty()) {
            sb.append("configMapVolumes:");
            sb.append(this.configMapVolumes + ",");
        }
        if (this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty()) {
            sb.append("emptyDirVolumes:");
            sb.append(this.emptyDirVolumes + ",");
        }
        if (this.gitRepoVolumes != null && !this.gitRepoVolumes.isEmpty()) {
            sb.append("gitRepoVolumes:");
            sb.append(this.gitRepoVolumes + ",");
        }
        if (this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty()) {
            sb.append("awsElasticBlockStoreVolumes:");
            sb.append(this.awsElasticBlockStoreVolumes + ",");
        }
        if (this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty()) {
            sb.append("azureDiskVolumes:");
            sb.append(this.azureDiskVolumes + ",");
        }
        if (this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty()) {
            sb.append("azureFileVolumes:");
            sb.append(this.azureFileVolumes + ",");
        }
        if (this.mounts != null && !this.mounts.isEmpty()) {
            sb.append("mounts:");
            sb.append(this.mounts + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append((Object)((Object)this.imagePullPolicy) + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.startupProbe != null) {
            sb.append("startupProbe:");
            sb.append(this.startupProbe + ",");
        }
        if (this.requestResources != null) {
            sb.append("requestResources:");
            sb.append(this.requestResources + ",");
        }
        if (this.limitResources != null) {
            sb.append("limitResources:");
            sb.append(this.limitResources + ",");
        }
        if (this.sidecars != null && !this.sidecars.isEmpty()) {
            sb.append("sidecars:");
            sb.append(this.sidecars + ",");
        }
        if (this.autoDeployEnabled != null) {
            sb.append("autoDeployEnabled:");
            sb.append(this.autoDeployEnabled + ",");
        }
        if (this.jobs != null && !this.jobs.isEmpty()) {
            sb.append("jobs:");
            sb.append(this.jobs + ",");
        }
        if (this.cronJobs != null && !this.cronJobs.isEmpty()) {
            sb.append("cronJobs:");
            sb.append(this.cronJobs);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAutoDeployEnabled() {
        return this.withAutoDeployEnabled(true);
    }

    class CronJobsNestedImpl<N>
    extends CronJobFluentImpl<BaseConfigFluent.CronJobsNested<N>>
    implements BaseConfigFluent.CronJobsNested<N>,
    Nested<N> {
        CronJobBuilder builder;
        Integer index;

        CronJobsNestedImpl(Integer index, CronJob item) {
            this.index = index;
            this.builder = new CronJobBuilder(this, item);
        }

        CronJobsNestedImpl() {
            this.index = -1;
            this.builder = new CronJobBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToCronJobs(this.index, this.builder.build());
        }

        @Override
        public N endCronJob() {
            return this.and();
        }
    }

    class JobsNestedImpl<N>
    extends JobFluentImpl<BaseConfigFluent.JobsNested<N>>
    implements BaseConfigFluent.JobsNested<N>,
    Nested<N> {
        JobBuilder builder;
        Integer index;

        JobsNestedImpl(Integer index, Job item) {
            this.index = index;
            this.builder = new JobBuilder(this, item);
        }

        JobsNestedImpl() {
            this.index = -1;
            this.builder = new JobBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToJobs(this.index, this.builder.build());
        }

        @Override
        public N endJob() {
            return this.and();
        }
    }

    class SidecarsNestedImpl<N>
    extends ContainerFluentImpl<BaseConfigFluent.SidecarsNested<N>>
    implements BaseConfigFluent.SidecarsNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        SidecarsNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        SidecarsNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToSidecars(this.index, this.builder.build());
        }

        @Override
        public N endSidecar() {
            return this.and();
        }
    }

    class LimitResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BaseConfigFluent.LimitResourcesNested<N>>
    implements BaseConfigFluent.LimitResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        LimitResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        LimitResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.withLimitResources(this.builder.build());
        }

        @Override
        public N endLimitResources() {
            return this.and();
        }
    }

    class RequestResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BaseConfigFluent.RequestResourcesNested<N>>
    implements BaseConfigFluent.RequestResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        RequestResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        RequestResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.withRequestResources(this.builder.build());
        }

        @Override
        public N endRequestResources() {
            return this.and();
        }
    }

    class StartupProbeNestedImpl<N>
    extends ProbeFluentImpl<BaseConfigFluent.StartupProbeNested<N>>
    implements BaseConfigFluent.StartupProbeNested<N>,
    Nested<N> {
        ProbeBuilder builder;

        StartupProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        StartupProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.withStartupProbe(this.builder.build());
        }

        @Override
        public N endStartupProbe() {
            return this.and();
        }
    }

    class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<BaseConfigFluent.ReadinessProbeNested<N>>
    implements BaseConfigFluent.ReadinessProbeNested<N>,
    Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<BaseConfigFluent.LivenessProbeNested<N>>
    implements BaseConfigFluent.LivenessProbeNested<N>,
    Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    class HostAliasesNestedImpl<N>
    extends HostAliasFluentImpl<BaseConfigFluent.HostAliasesNested<N>>
    implements BaseConfigFluent.HostAliasesNested<N>,
    Nested<N> {
        HostAliasBuilder builder;
        Integer index;

        HostAliasesNestedImpl(Integer index, HostAlias item) {
            this.index = index;
            this.builder = new HostAliasBuilder(this, item);
        }

        HostAliasesNestedImpl() {
            this.index = -1;
            this.builder = new HostAliasBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToHostAliases(this.index, this.builder.build());
        }

        @Override
        public N endHostAlias() {
            return this.and();
        }
    }

    class MountsNestedImpl<N>
    extends MountFluentImpl<BaseConfigFluent.MountsNested<N>>
    implements BaseConfigFluent.MountsNested<N>,
    Nested<N> {
        MountBuilder builder;
        Integer index;

        MountsNestedImpl(Integer index, Mount item) {
            this.index = index;
            this.builder = new MountBuilder(this, item);
        }

        MountsNestedImpl() {
            this.index = -1;
            this.builder = new MountBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToMounts(this.index, this.builder.build());
        }

        @Override
        public N endMount() {
            return this.and();
        }
    }

    class AzureFileVolumesNestedImpl<N>
    extends AzureFileVolumeFluentImpl<BaseConfigFluent.AzureFileVolumesNested<N>>
    implements BaseConfigFluent.AzureFileVolumesNested<N>,
    Nested<N> {
        AzureFileVolumeBuilder builder;
        Integer index;

        AzureFileVolumesNestedImpl(Integer index, AzureFileVolume item) {
            this.index = index;
            this.builder = new AzureFileVolumeBuilder(this, item);
        }

        AzureFileVolumesNestedImpl() {
            this.index = -1;
            this.builder = new AzureFileVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToAzureFileVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAzureFileVolume() {
            return this.and();
        }
    }

    class AzureDiskVolumesNestedImpl<N>
    extends AzureDiskVolumeFluentImpl<BaseConfigFluent.AzureDiskVolumesNested<N>>
    implements BaseConfigFluent.AzureDiskVolumesNested<N>,
    Nested<N> {
        AzureDiskVolumeBuilder builder;
        Integer index;

        AzureDiskVolumesNestedImpl(Integer index, AzureDiskVolume item) {
            this.index = index;
            this.builder = new AzureDiskVolumeBuilder(this, item);
        }

        AzureDiskVolumesNestedImpl() {
            this.index = -1;
            this.builder = new AzureDiskVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToAzureDiskVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAzureDiskVolume() {
            return this.and();
        }
    }

    class AwsElasticBlockStoreVolumesNestedImpl<N>
    extends AwsElasticBlockStoreVolumeFluentImpl<BaseConfigFluent.AwsElasticBlockStoreVolumesNested<N>>
    implements BaseConfigFluent.AwsElasticBlockStoreVolumesNested<N>,
    Nested<N> {
        AwsElasticBlockStoreVolumeBuilder builder;
        Integer index;

        AwsElasticBlockStoreVolumesNestedImpl(Integer index, AwsElasticBlockStoreVolume item) {
            this.index = index;
            this.builder = new AwsElasticBlockStoreVolumeBuilder(this, item);
        }

        AwsElasticBlockStoreVolumesNestedImpl() {
            this.index = -1;
            this.builder = new AwsElasticBlockStoreVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToAwsElasticBlockStoreVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAwsElasticBlockStoreVolume() {
            return this.and();
        }
    }

    class GitRepoVolumesNestedImpl<N>
    extends GitRepoVolumeFluentImpl<BaseConfigFluent.GitRepoVolumesNested<N>>
    implements BaseConfigFluent.GitRepoVolumesNested<N>,
    Nested<N> {
        GitRepoVolumeBuilder builder;
        Integer index;

        GitRepoVolumesNestedImpl(Integer index, GitRepoVolume item) {
            this.index = index;
            this.builder = new GitRepoVolumeBuilder(this, item);
        }

        GitRepoVolumesNestedImpl() {
            this.index = -1;
            this.builder = new GitRepoVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToGitRepoVolumes(this.index, this.builder.build());
        }

        @Override
        public N endGitRepoVolume() {
            return this.and();
        }
    }

    class EmptyDirVolumesNestedImpl<N>
    extends EmptyDirVolumeFluentImpl<BaseConfigFluent.EmptyDirVolumesNested<N>>
    implements BaseConfigFluent.EmptyDirVolumesNested<N>,
    Nested<N> {
        EmptyDirVolumeBuilder builder;
        Integer index;

        EmptyDirVolumesNestedImpl(Integer index, EmptyDirVolume item) {
            this.index = index;
            this.builder = new EmptyDirVolumeBuilder(this, item);
        }

        EmptyDirVolumesNestedImpl() {
            this.index = -1;
            this.builder = new EmptyDirVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToEmptyDirVolumes(this.index, this.builder.build());
        }

        @Override
        public N endEmptyDirVolume() {
            return this.and();
        }
    }

    class ConfigMapVolumesNestedImpl<N>
    extends ConfigMapVolumeFluentImpl<BaseConfigFluent.ConfigMapVolumesNested<N>>
    implements BaseConfigFluent.ConfigMapVolumesNested<N>,
    Nested<N> {
        ConfigMapVolumeBuilder builder;
        Integer index;

        ConfigMapVolumesNestedImpl(Integer index, ConfigMapVolume item) {
            this.index = index;
            this.builder = new ConfigMapVolumeBuilder(this, item);
        }

        ConfigMapVolumesNestedImpl() {
            this.index = -1;
            this.builder = new ConfigMapVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToConfigMapVolumes(this.index, this.builder.build());
        }

        @Override
        public N endConfigMapVolume() {
            return this.and();
        }
    }

    class SecretVolumesNestedImpl<N>
    extends SecretVolumeFluentImpl<BaseConfigFluent.SecretVolumesNested<N>>
    implements BaseConfigFluent.SecretVolumesNested<N>,
    Nested<N> {
        SecretVolumeBuilder builder;
        Integer index;

        SecretVolumesNestedImpl(Integer index, SecretVolume item) {
            this.index = index;
            this.builder = new SecretVolumeBuilder(this, item);
        }

        SecretVolumesNestedImpl() {
            this.index = -1;
            this.builder = new SecretVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToSecretVolumes(this.index, this.builder.build());
        }

        @Override
        public N endSecretVolume() {
            return this.and();
        }
    }

    class PvcVolumesNestedImpl<N>
    extends PersistentVolumeClaimVolumeFluentImpl<BaseConfigFluent.PvcVolumesNested<N>>
    implements BaseConfigFluent.PvcVolumesNested<N>,
    Nested<N> {
        PersistentVolumeClaimVolumeBuilder builder;
        Integer index;

        PvcVolumesNestedImpl(Integer index, PersistentVolumeClaimVolume item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimVolumeBuilder(this, item);
        }

        PvcVolumesNestedImpl() {
            this.index = -1;
            this.builder = new PersistentVolumeClaimVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToPvcVolumes(this.index, this.builder.build());
        }

        @Override
        public N endPvcVolume() {
            return this.and();
        }
    }

    class PortsNestedImpl<N>
    extends PortFluentImpl<BaseConfigFluent.PortsNested<N>>
    implements BaseConfigFluent.PortsNested<N>,
    Nested<N> {
        PortBuilder builder;
        Integer index;

        PortsNestedImpl(Integer index, Port item) {
            this.index = index;
            this.builder = new PortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    class EnvVarsNestedImpl<N>
    extends EnvFluentImpl<BaseConfigFluent.EnvVarsNested<N>>
    implements BaseConfigFluent.EnvVarsNested<N>,
    Nested<N> {
        EnvBuilder builder;
        Integer index;

        EnvVarsNestedImpl(Integer index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        EnvVarsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToEnvVars(this.index, this.builder.build());
        }

        @Override
        public N endEnvVar() {
            return this.and();
        }
    }

    class AnnotationsNestedImpl<N>
    extends AnnotationFluentImpl<BaseConfigFluent.AnnotationsNested<N>>
    implements BaseConfigFluent.AnnotationsNested<N>,
    Nested<N> {
        AnnotationBuilder builder;
        Integer index;

        AnnotationsNestedImpl(Integer index, Annotation item) {
            this.index = index;
            this.builder = new AnnotationBuilder(this, item);
        }

        AnnotationsNestedImpl() {
            this.index = -1;
            this.builder = new AnnotationBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToAnnotations(this.index, this.builder.build());
        }

        @Override
        public N endAnnotation() {
            return this.and();
        }
    }

    class LabelsNestedImpl<N>
    extends LabelFluentImpl<BaseConfigFluent.LabelsNested<N>>
    implements BaseConfigFluent.LabelsNested<N>,
    Nested<N> {
        LabelBuilder builder;
        Integer index;

        LabelsNestedImpl(Integer index, Label item) {
            this.index = index;
            this.builder = new LabelBuilder(this, item);
        }

        LabelsNestedImpl() {
            this.index = -1;
            this.builder = new LabelBuilder(this);
        }

        @Override
        public N and() {
            return (N)BaseConfigFluentImpl.this.setToLabels(this.index, this.builder.build());
        }

        @Override
        public N endLabel() {
            return this.and();
        }
    }
}

