/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.DekorateException;
import io.dekorate.testing.Testing;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public interface WithKubernetesClient
extends TestInstancePostProcessor {
    public static final String KUBERNETES_CLIENT = "KUBERNETES_CLIENT";

    default public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).forEach(f -> this.injectKubernetesClient(context, testInstance, (Field)f));
    }

    default public void injectKubernetesClient(ExtensionContext context, Object testInstance, Field field) {
        if (!field.getType().isAssignableFrom(KubernetesClient.class)) {
            return;
        }
        if (!Arrays.stream(field.getDeclaredAnnotations()).filter(a -> a.annotationType().getSimpleName().equalsIgnoreCase("Inject")).findAny().isPresent()) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(testInstance, this.getKubernetesClient(context));
        }
        catch (IllegalAccessException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }

    default public KubernetesClient getKubernetesClient(ExtensionContext context) {
        Object client = context.getStore(Testing.DEKORATE_STORE).get((Object)KUBERNETES_CLIENT);
        if (client instanceof KubernetesClient) {
            return (KubernetesClient)client;
        }
        client = new KubernetesClientBuilder().build();
        context.getStore(Testing.DEKORATE_STORE).put((Object)KUBERNETES_CLIENT, client);
        return (KubernetesClient)client;
    }

    default public void closeKubernetesClient(ExtensionContext context) {
        Object client = context.getStore(Testing.DEKORATE_STORE).remove((Object)KUBERNETES_CLIENT);
        if (client instanceof KubernetesClient) {
            ((KubernetesClient)client).close();
        }
    }

    default public <T extends HasMetadata> boolean waitUntilCondition(ExtensionContext context, Collection<T> items, Predicate<T> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        long amountInNanos = timeUnit.toNanos(amount);
        long end = System.nanoTime() + amountInNanos;
        KubernetesClient client = this.getKubernetesClient(context);
        List notReady = items.stream().map(i -> (HasMetadata)client.resource(i).fromServer().get()).filter(condition.negate()).collect(Collectors.toList());
        while (System.nanoTime() < end && !notReady.isEmpty()) {
            Thread.sleep(1000L);
            notReady = items.stream().map(i -> (HasMetadata)client.resource(i).fromServer().get()).filter(condition.negate()).collect(Collectors.toList());
        }
        return notReady.isEmpty();
    }

    default public <T extends HasMetadata> boolean deleteAndWait(ExtensionContext context, T item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return this.deleteAndWait(context, Arrays.asList(item), amount, timeUnit);
    }

    default public <T extends HasMetadata> boolean deleteAndWait(ExtensionContext context, Collection<T> items, long amount, TimeUnit timeUnit) throws InterruptedException {
        long amountInNanos = timeUnit.toNanos(amount);
        long end = System.nanoTime() + amountInNanos;
        KubernetesClient client = this.getKubernetesClient(context);
        for (HasMetadata item : items) {
            try {
                HasMetadata existing = (HasMetadata)client.resource(item).fromServer().get();
                if (existing == null) continue;
                client.resource(existing).delete();
            }
            catch (KubernetesClientException e) {
                if (e.getCode() == 404) continue;
                throw e;
            }
        }
        ArrayList<T> notDeleted = new ArrayList<T>(items);
        while (System.nanoTime() < end && !notDeleted.isEmpty()) {
            for (HasMetadata item : items) {
                block8: {
                    if (!notDeleted.contains(item)) continue;
                    try {
                        if (client.resource(item).fromServer().get() == null) {
                            notDeleted.remove(item);
                        }
                    }
                    catch (KubernetesClientException e) {
                        if (e.getCode() != 404) break block8;
                        notDeleted.remove(item);
                    }
                }
                Thread.sleep(1000L);
            }
        }
        return notDeleted.isEmpty();
    }
}

