/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.project.Project;
import io.dekorate.testing.Diagnostics;
import io.dekorate.testing.Testing;
import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.WithProject;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface WithDiagnostics
extends WithKubernetesClient,
WithProject {
    public static final String EXTENSION_ERROR = "EXTENSION_ERROR";
    public static final String READINESS_FAILED = "READINESS_FAILED";

    default public void extensionError(ExtensionContext context, String message) {
        context.getStore(Testing.DEKORATE_STORE).put((Object)EXTENSION_ERROR, (Object)message);
    }

    default public boolean hasExtensionError(ExtensionContext context) {
        return Strings.isNotNullOrEmpty((String)((String)context.getStore(Testing.DEKORATE_STORE).getOrDefault((Object)EXTENSION_ERROR, String.class, null)));
    }

    default public void readinessFailed(ExtensionContext context) {
        context.getStore(Testing.DEKORATE_STORE).put((Object)READINESS_FAILED, (Object)true);
    }

    default public boolean hasReadinessFailed(ExtensionContext context) {
        return (Boolean)context.getStore(Testing.DEKORATE_STORE).getOrDefault((Object)READINESS_FAILED, Boolean.TYPE, (Object)false);
    }

    default public boolean shouldDisplayDiagnostics(ExtensionContext context) {
        return context.getExecutionException().isPresent();
    }

    default public void displayDiagnostics(ExtensionContext context) {
        KubernetesClient client = this.getKubernetesClient(context);
        Diagnostics diagnostics = new Diagnostics(client);
        List projects = this.getProjects(context);
        for (Project project : projects) {
            String key = Testing.KUBERNETES_LIST + project.getRoot();
            KubernetesList resources = (KubernetesList)context.getStore(Testing.DEKORATE_STORE).get((Object)key);
            if (resources == null) continue;
            resources.getItems().stream().forEach(r -> diagnostics.display(r));
        }
        diagnostics.displayAll();
    }
}

