/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.DekorateException;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.utils.Serialization;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public interface WithBaseConfig {
    public static final String KUBERNETES_CONFIG_PATH = "META-INF/dekorate/.config/base.yml";

    default public BaseConfig getBaseConfig() {
        return this.getBaseConfig(KUBERNETES_CONFIG_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public BaseConfig getBaseConfig(String path) {
        URL url = WithBaseConfig.class.getClassLoader().getResource(path);
        if (url == null) throw new IllegalStateException("Expected to find base config at: " + path + "!");
        try (InputStream is = url.openStream();){
            BaseConfig baseConfig = (BaseConfig)Serialization.unmarshal((InputStream)is, BaseConfig.class);
            return baseConfig;
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }
}

