/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.annotation.OnServicePresentCondition;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ServicePresentCondition
implements ExecutionCondition,
WithKubernetesClient {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<OnServicePresentCondition> annotation = context.getElement().map(e -> e.getAnnotation(OnServicePresentCondition.class));
        if (!annotation.isPresent()) {
            return ConditionEvaluationResult.enabled((String)"Condition not found!");
        }
        OnServicePresentCondition condition = annotation.get();
        try {
            KubernetesClient client = this.getKubernetesClient(context);
            String namespace = Strings.isNotNullOrEmpty((String)condition.namespace()) ? condition.namespace() : client.getNamespace();
            Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.getKubernetesClient(context).services().inNamespace(namespace)).withName(condition.value())).get();
            if (service != null) {
                return ConditionEvaluationResult.enabled((String)("Found service:" + condition.value() + " in namespace:" + namespace + " ."));
            }
            return ConditionEvaluationResult.disabled((String)("Could not find service:" + condition.value() + " in namespace:" + namespace + " ."));
        }
        catch (Throwable t) {
            return ConditionEvaluationResult.disabled((String)"Could not lookup for service.");
        }
    }
}

