/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.stream.Collectors;

public class Pods {
    private final KubernetesClient client;

    public Pods(KubernetesClient client) {
        this.client = client;
    }

    public PodList list(Object resource) {
        if (resource instanceof KubernetesList) {
            KubernetesList list = (KubernetesList)resource;
            return ((PodListBuilder)new PodListBuilder().withItems(list.getItems().stream().map((? super T i) -> this.list(i)).filter(i -> i != null && !i.getItems().isEmpty()).flatMap(i -> i.getItems().stream()).collect(Collectors.toList()))).build();
        }
        if (resource instanceof Pod) {
            return ((PodListBuilder)new PodListBuilder().withItems(new Pod[]{(Pod)resource})).build();
        }
        if (resource instanceof Endpoints) {
            return this.list(((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(((Endpoints)resource).getMetadata().getNamespace())).withName(((Endpoints)resource).getMetadata().getName())).get());
        }
        if (resource instanceof Service) {
            return (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(((Service)resource).getMetadata().getNamespace())).withLabels(((Service)resource).getSpec().getSelector())).list();
        }
        if (resource instanceof ReplicationController) {
            return (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(((ReplicationController)resource).getMetadata().getNamespace())).withLabels(((ReplicationController)resource).getSpec().getSelector())).list();
        }
        if (resource instanceof ReplicaSet) {
            return this.map((ReplicaSet)resource);
        }
        if (resource instanceof Deployment) {
            return this.map((Deployment)resource);
        }
        return new PodListBuilder().build();
    }

    protected PodList map(Deployment deployment) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.client.pods().inNamespace(deployment.getMetadata().getNamespace());
        if (deployment.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(deployment.getSpec().getSelector().getMatchLabels());
        }
        if (deployment.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : deployment.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }

    protected PodList map(ReplicaSet replicaSet) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.client.pods().inNamespace(replicaSet.getMetadata().getNamespace());
        if (replicaSet.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(replicaSet.getSpec().getSelector().getMatchLabels());
        }
        if (replicaSet.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : replicaSet.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }
}

