/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.testing.AbstractDiagonsticsService;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;

public class PodDiagnostics
extends AbstractDiagonsticsService<Pod> {
    private static final String CONTAINER_STATUS_FORMAT = "\t%-40s %-7s %-7s %s";

    public PodDiagnostics(KubernetesClient client) {
        super(client);
    }

    @Override
    public void display(Pod pod) {
        this.LOGGER.info("Diagnostics for kind: [Pod] with name : [" + pod.getMetadata().getName() + "].");
        this.displayStatus(pod);
        this.displayEvents(pod);
        this.displayLogs(pod);
    }

    @Override
    public void displayStatus(Pod pod) {
        this.LOGGER.info("Container statuses of Pod:" + pod.getMetadata().getName());
        if (pod.getStatus() != null && pod.getStatus().getContainerStatuses() != null) {
            this.LOGGER.info(String.format(CONTAINER_STATUS_FORMAT, "Name", "Running", "Ready", "Image"));
            pod.getStatus().getContainerStatuses().forEach(c -> this.LOGGER.info(String.format(CONTAINER_STATUS_FORMAT, c.getName(), c.getState().getRunning() != null, c.getReady(), c.getImage())));
        } else {
            this.LOGGER.warning("No containers statuses found.");
        }
    }

    protected void displayLogs(Pod pod) {
        for (Container container : pod.getSpec().getContainers()) {
            this.displayLogs(pod, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayLogs(Pod pod, Container container) {
        try {
            this.LOGGER.info("Logs of pod: [" + pod.getMetadata().getName() + "], container: [" + container.getName() + "]");
            this.LOGGER.info(((ContainerResource)((PodResource)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).inContainer((Object)container.getName())).tailingLines(100).withPrettyOutput().getLog());
        }
        catch (Throwable t) {
            this.LOGGER.error("Failed to read logs, due to:" + t.getMessage());
        }
        finally {
            this.LOGGER.info("---");
        }
    }
}

