/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.utils.Generics;
import io.dekorate.utils.Serialization;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.HashMap;

public interface DiagnosticsService<T extends HasMetadata> {
    public static final Logger LOGGER = LoggerFactory.getLogger();

    public KubernetesClient getKubernetesClient();

    default public Class<T> getType() {
        return (Class)Generics.getTypeArguments(DiagnosticsService.class, this.getClass()).get(0);
    }

    public void display(T var1);

    public void displayStatus(T var1);

    default public void displayResourceYaml(T resource) {
        try {
            LOGGER.info(Serialization.asYaml(resource));
        }
        finally {
            LOGGER.info("\t---");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void displayEvents(T resource) {
        try {
            HashMap<String, String> fields = new HashMap<String, String>();
            if (Strings.isNotNullOrEmpty((String)resource.getMetadata().getUid())) {
                fields.put("involvedObject.uid", resource.getMetadata().getUid());
            }
            if (Strings.isNotNullOrEmpty((String)resource.getMetadata().getNamespace())) {
                fields.put("involvedObject.namespace", resource.getMetadata().getNamespace());
            }
            fields.put("involvedObject.name", resource.getMetadata().getName());
            EventList eventList = (EventList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getKubernetesClient().v1().events().inNamespace(resource.getMetadata().getNamespace())).withFields(fields)).list();
            if (eventList == null) {
                return;
            }
            LOGGER.info(String.format("Events of %s: [%s]", resource.getKind(), resource.getMetadata().getName()));
            for (Event event : eventList.getItems()) {
                LOGGER.info(String.format("%s\t\t%s", event.getReason(), event.getMessage()));
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to read events, due to:" + t.getMessage());
        }
        finally {
            LOGGER.info("\t---");
        }
    }
}

