/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing;

import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.annotation.OnCustomResourcePresentCondition;
import io.dekorate.utils.Pluralize;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CustomResourceCondition
implements ExecutionCondition,
WithKubernetesClient {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<OnCustomResourcePresentCondition> annotation = context.getElement().map(e -> e.getAnnotation(OnCustomResourcePresentCondition.class));
        if (!annotation.isPresent()) {
            return ConditionEvaluationResult.enabled((String)"Condition not found!");
        }
        OnCustomResourcePresentCondition condition = annotation.get();
        try {
            String apiVersion = condition.apiVersion();
            String kind = condition.kind();
            String plural = Strings.isNotNullOrEmpty((String)condition.plural()) ? condition.plural() : Pluralize.FUNCTION.apply(kind).toLowerCase();
            String name = condition.name();
            String namespace = condition.namespace();
            KubernetesClient client = this.getKubernetesClient(context);
            Config config = client.getConfiguration();
            HttpClient httpClient = client.getHttpClient();
            ArrayList<String> parts = new ArrayList<String>();
            parts.add(config.getMasterUrl());
            parts.add("apis");
            parts.add(apiVersion);
            if (Strings.isNotNullOrEmpty((String)namespace)) {
                parts.add("namespaces");
                parts.add(namespace);
            }
            parts.add(plural);
            if (Strings.isNotNullOrEmpty((String)name)) {
                parts.add(name);
            }
            parts.add(plural);
            String requestUrl = URLUtils.join((String[])((String[])parts.stream().toArray(String[]::new)));
            HttpRequest request = httpClient.newHttpRequestBuilder().uri(requestUrl).build();
            HttpResponse response = (HttpResponse)httpClient.sendAsync(request, String.class).get(10L, TimeUnit.SECONDS);
            if (!response.isSuccessful()) {
                return ConditionEvaluationResult.disabled((String)"Could not lookup custom resource.");
            }
            return ConditionEvaluationResult.enabled((String)("Found resource with apiVersion:" + apiVersion + " kind:" + kind + " namespace: " + (Strings.isNullOrEmpty((String)namespace) ? "any" : namespace) + " name: " + (Strings.isNullOrEmpty((String)name) ? "any" : name)));
        }
        catch (Throwable t) {
            return ConditionEvaluationResult.disabled((String)"Could not lookup for service.");
        }
    }
}

