/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.source;

import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.audio.ConversionsKt;
import com.otaliastudios.transcoder.source.DataSource;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BlankAudioDataSource
implements DataSource {
    private static final int CHANNEL_COUNT = 2;
    private static final int SAMPLE_RATE = 44100;
    private static final int PERIOD_SIZE = ConversionsKt.samplesToBytes(2048, 2);
    private final long durationUs;
    private ByteBuffer byteBuffer;
    private MediaFormat audioFormat;
    private long positionUs = 0L;
    private boolean initialized = false;

    public BlankAudioDataSource(long durationUs2) {
        this.durationUs = durationUs2;
    }

    @Override
    public void initialize() {
        this.byteBuffer = ByteBuffer.allocateDirect(PERIOD_SIZE).order(ByteOrder.nativeOrder());
        this.audioFormat = new MediaFormat();
        this.audioFormat.setString("mime", "audio/raw");
        this.audioFormat.setInteger("bitrate", ConversionsKt.bitRate(44100, 2));
        this.audioFormat.setInteger("channel-count", 2);
        this.audioFormat.setInteger("max-input-size", PERIOD_SIZE);
        this.audioFormat.setInteger("sample-rate", 44100);
        this.initialized = true;
    }

    @Override
    public void selectTrack(@NonNull TrackType type) {
    }

    @Override
    public void releaseTrack(@NonNull TrackType type) {
    }

    @Override
    public void deinitialize() {
        this.positionUs = 0L;
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    @Nullable
    public double[] getLocation() {
        return null;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public long seekTo(long desiredPositionUs) {
        this.positionUs = desiredPositionUs;
        return desiredPositionUs;
    }

    @Override
    @Nullable
    public MediaFormat getTrackFormat(@NonNull TrackType type) {
        return type == TrackType.AUDIO ? this.audioFormat : null;
    }

    @Override
    public boolean canReadTrack(@NonNull TrackType type) {
        return type == TrackType.AUDIO;
    }

    @Override
    public void readTrack(@NonNull DataSource.Chunk chunk) {
        int position = chunk.buffer.position();
        int bytes = Math.min(chunk.buffer.remaining(), PERIOD_SIZE);
        this.byteBuffer.clear();
        this.byteBuffer.limit(bytes);
        chunk.buffer.put(this.byteBuffer);
        chunk.buffer.position(position);
        chunk.buffer.limit(position + bytes);
        chunk.keyframe = true;
        chunk.timeUs = this.positionUs;
        chunk.render = true;
        this.positionUs += ConversionsKt.bytesToUs(bytes, 44100, 2);
    }

    @Override
    public long getPositionUs() {
        return this.positionUs;
    }

    @Override
    public boolean isDrained() {
        return this.positionUs >= this.getDurationUs();
    }
}

