/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.video;

import android.media.MediaFormat;
import android.view.Surface;
import com.otaliastudios.transcoder.internal.codec.DecoderChannel;
import com.otaliastudios.transcoder.internal.codec.DecoderData;
import com.otaliastudios.transcoder.internal.pipeline.BaseStep;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.video.FrameDrawer;
import com.otaliastudios.transcoder.internal.video.FrameDropper;
import com.otaliastudios.transcoder.internal.video.FrameDropperKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003B)\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#H\u0016J\b\u0010$\u001a\u00020\u001eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/otaliastudios/transcoder/internal/video/VideoRenderer;", "Lcom/otaliastudios/transcoder/internal/pipeline/BaseStep;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderData;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderChannel;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "sourceRotation", "", "extraRotation", "targetFormat", "Landroid/media/MediaFormat;", "flipY", "", "<init>", "(IILandroid/media/MediaFormat;Z)V", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/video/VideoRenderer;", "frameDrawer", "Lcom/otaliastudios/transcoder/internal/video/FrameDrawer;", "getFrameDrawer", "()Lcom/otaliastudios/transcoder/internal/video/FrameDrawer;", "frameDrawer$delegate", "Lkotlin/Lazy;", "frameDropper", "Lcom/otaliastudios/transcoder/internal/video/FrameDropper;", "handleSourceFormat", "Landroid/view/Surface;", "sourceFormat", "handleRawFormat", "", "rawFormat", "advance", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "release", "lib_release"})
@SourceDebugExtension(value={"SMAP\nVideoRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoRenderer.kt\ncom/otaliastudios/transcoder/internal/video/VideoRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class VideoRenderer
extends BaseStep<DecoderData, DecoderChannel, Long, Channel>
implements DecoderChannel {
    private final int sourceRotation;
    private final int extraRotation;
    @NotNull
    private final MediaFormat targetFormat;
    @NotNull
    private final VideoRenderer channel;
    @NotNull
    private final Lazy frameDrawer$delegate;
    private FrameDropper frameDropper;

    public VideoRenderer(int sourceRotation, int extraRotation, @NotNull MediaFormat targetFormat, boolean flipY) {
        Intrinsics.checkNotNullParameter((Object)targetFormat, (String)"targetFormat");
        super("VideoRenderer");
        this.sourceRotation = sourceRotation;
        this.extraRotation = extraRotation;
        this.targetFormat = targetFormat;
        this.channel = this;
        this.frameDrawer$delegate = LazyKt.lazy(() -> VideoRenderer.frameDrawer_delegate$lambda$0(flipY));
        int width = this.targetFormat.getInteger("width");
        int height = this.targetFormat.getInteger("height");
        boolean flip = this.extraRotation % 180 != 0;
        int flippedWidth = flip ? height : width;
        int flippedHeight = flip ? width : height;
        this.targetFormat.setInteger("width", flippedWidth);
        this.targetFormat.setInteger("height", flippedHeight);
        this.getLog().i("encoded output format: " + this.targetFormat);
        this.getLog().i("output size=" + flippedWidth + "x" + flippedHeight + ", flipped=" + flip);
    }

    public /* synthetic */ VideoRenderer(int n, int n2, MediaFormat mediaFormat, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        this(n, n2, mediaFormat, bl);
    }

    @Override
    @NotNull
    public VideoRenderer getChannel() {
        return this.channel;
    }

    private final FrameDrawer getFrameDrawer() {
        Lazy lazy = this.frameDrawer$delegate;
        return (FrameDrawer)lazy.getValue();
    }

    @Override
    @NotNull
    public Surface handleSourceFormat(@NotNull MediaFormat sourceFormat) {
        Object object;
        Object $this$handleSourceFormat_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)sourceFormat, (String)"sourceFormat");
        this.getLog().i("encoded input format: " + sourceFormat);
        Object object2 = this;
        try {
            $this$handleSourceFormat_u24lambda_u241 = object2;
            boolean bl = false;
            $this$handleSourceFormat_u24lambda_u241 = Result.constructor-impl((Object)sourceFormat.getInteger("rotation-degrees"));
        }
        catch (Throwable bl) {
            $this$handleSourceFormat_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$handleSourceFormat_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = 0;
        }
        int sourceRotation = ((Number)object).intValue();
        if (sourceRotation != this.sourceRotation) {
            throw new IllegalStateException(("Unexpected difference in rotation. DataSource=" + this.sourceRotation + ", MediaFormat=" + sourceRotation).toString());
        }
        sourceFormat.setInteger("rotation-degrees", 0);
        int rotation = (sourceRotation + this.extraRotation) % 360;
        this.getFrameDrawer().setRotation(rotation);
        boolean flip = rotation % 180 != 0;
        float sourceWidth = sourceFormat.getInteger("width");
        float sourceHeight = sourceFormat.getInteger("height");
        float sourceRatio = sourceWidth / sourceHeight;
        float targetWidth = flip ? this.targetFormat.getInteger("height") : this.targetFormat.getInteger("width");
        float targetHeight = flip ? this.targetFormat.getInteger("width") : this.targetFormat.getInteger("height");
        float targetRatio = targetWidth / targetHeight;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (sourceRatio > targetRatio) {
            scaleX = sourceRatio / targetRatio;
        } else if (sourceRatio < targetRatio) {
            scaleY = targetRatio / sourceRatio;
        }
        this.getFrameDrawer().setScale(scaleX, scaleY);
        this.frameDropper = FrameDropperKt.FrameDropper(sourceFormat.getInteger("frame-rate"), this.targetFormat.getInteger("frame-rate"));
        Surface surface = this.getFrameDrawer().getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
        return surface;
    }

    @Override
    public void handleRawFormat(@NotNull MediaFormat rawFormat) {
        Intrinsics.checkNotNullParameter((Object)rawFormat, (String)"rawFormat");
        this.getLog().i("decoded input format: " + rawFormat);
    }

    @Override
    @NotNull
    public State<Long> advance(@NotNull State.Ok<DecoderData> state) {
        State state2;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (state instanceof State.Eos) {
            ((DecoderData)((State.Eos)state).getValue()).getRelease().invoke((Object)false);
            state2 = new State.Eos<Long>(0L);
        } else {
            FrameDropper frameDropper = this.frameDropper;
            if (frameDropper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"frameDropper");
                frameDropper = null;
            }
            if (frameDropper.shouldRender(state.getValue().getTimeUs())) {
                state.getValue().getRelease().invoke((Object)true);
                this.getFrameDrawer().drawFrame();
                state2 = new State.Ok<Long>(state.getValue().getTimeUs());
            } else {
                state.getValue().getRelease().invoke((Object)false);
                state2 = new State.Consume(false, 1, null);
            }
        }
        return state2;
    }

    @Override
    public void release() {
        this.getFrameDrawer().release();
    }

    private static final FrameDrawer frameDrawer_delegate$lambda$0(boolean $flipY) {
        FrameDrawer drawer = new FrameDrawer();
        drawer.setFlipY($flipY);
        return drawer;
    }
}

