/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import androidx.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISO6709LocationParser {
    private final Pattern pattern = Pattern.compile("([+\\-][0-9.]+)([+\\-][0-9.]+)");

    @Nullable
    public float[] parse(@Nullable String location) {
        if (location == null) {
            return null;
        }
        Matcher m = this.pattern.matcher(location);
        if (m.find() && m.groupCount() == 2) {
            String latstr = m.group(1);
            String lonstr = m.group(2);
            try {
                float lat = Float.parseFloat(latstr);
                float lon = Float.parseFloat(lonstr);
                return new float[]{lat, lon};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

