/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.transcode;

import com.otaliastudios.transcoder.TranscoderOptions;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.transcode.DefaultTranscodeEngine;
import com.otaliastudios.transcoder.internal.transcode.TranscodeDispatcher;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.sink.DataSink;
import com.otaliastudios.transcoder.strategy.TrackStrategy;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import com.otaliastudios.transcoder.validator.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b \u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u001c\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tH&J\b\u0010\u000b\u001a\u00020\u0007H&\u00a8\u0006\r"}, d2={"Lcom/otaliastudios/transcoder/internal/transcode/TranscodeEngine;", "", "<init>", "()V", "validate", "", "transcode", "", "progress", "Lkotlin/Function1;", "", "cleanup", "Companion", "lib_release"})
public abstract class TranscodeEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log = new Logger("TranscodeEngine");

    public abstract boolean validate();

    public abstract void transcode(@NotNull Function1<? super Double, Unit> var1);

    public abstract void cleanup();

    @JvmStatic
    public static final void transcode(@NotNull TranscoderOptions options) {
        Companion.transcode(options);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/otaliastudios/transcoder/internal/transcode/TranscodeEngine$Companion;", "", "<init>", "()V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "isInterrupted", "", "", "transcode", "", "options", "Lcom/otaliastudios/transcoder/TranscoderOptions;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isInterrupted(Throwable $this$isInterrupted) {
            if ($this$isInterrupted instanceof InterruptedException) {
                return true;
            }
            if (Intrinsics.areEqual((Object)$this$isInterrupted, (Object)$this$isInterrupted.getCause())) {
                return false;
            }
            Throwable throwable = $this$isInterrupted.getCause();
            return throwable != null ? this.isInterrupted(throwable) : false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void transcode(@NotNull TranscoderOptions options) {
            block9: {
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                log.i("transcode(): called...");
                TranscodeEngine engine = null;
                TranscodeDispatcher dispatcher = new TranscodeDispatcher(options);
                try {
                    DataSources dataSources = new DataSources(options);
                    DataSink dataSink = options.getDataSink();
                    Intrinsics.checkNotNullExpressionValue((Object)dataSink, (String)"getDataSink(...)");
                    DataSink dataSink2 = dataSink;
                    TrackMap<TrackStrategy> trackMap = TrackMapKt.trackMapOf(options.getVideoTrackStrategy(), options.getAudioTrackStrategy());
                    Validator validator = options.getValidator();
                    Intrinsics.checkNotNullExpressionValue((Object)validator, (String)"getValidator(...)");
                    Validator validator2 = validator;
                    int n = options.getVideoRotation();
                    TimeInterpolator timeInterpolator = options.getTimeInterpolator();
                    Intrinsics.checkNotNullExpressionValue((Object)timeInterpolator, (String)"getTimeInterpolator(...)");
                    TimeInterpolator timeInterpolator2 = timeInterpolator;
                    AudioStretcher audioStretcher = options.getAudioStretcher();
                    Intrinsics.checkNotNullExpressionValue((Object)audioStretcher, (String)"getAudioStretcher(...)");
                    AudioStretcher audioStretcher2 = audioStretcher;
                    AudioResampler audioResampler = options.getAudioResampler();
                    Intrinsics.checkNotNullExpressionValue((Object)audioResampler, (String)"getAudioResampler(...)");
                    AudioResampler audioResampler2 = audioResampler;
                    engine = new DefaultTranscodeEngine(dataSources, dataSink2, trackMap, validator2, n, audioStretcher2, audioResampler2, timeInterpolator2);
                    if (!((DefaultTranscodeEngine)engine).validate()) {
                        dispatcher.dispatchSuccess(1);
                    } else {
                        ((DefaultTranscodeEngine)engine).transcode((Function1<? super Double, Unit>)((Function1)arg_0 -> Companion.transcode$lambda$0(dispatcher, arg_0)));
                        dispatcher.dispatchSuccess(0);
                    }
                    engine.cleanup();
                }
                catch (Exception e) {
                    if (this.isInterrupted(e)) {
                        log.i("Transcode canceled.", e);
                        dispatcher.dispatchCancel();
                        break block9;
                    }
                    log.e("Unexpected error while transcoding.", e);
                    dispatcher.dispatchFailure(e);
                    throw e;
                }
                finally {
                    TranscodeEngine transcodeEngine = engine;
                    if (transcodeEngine != null) {
                        transcodeEngine.cleanup();
                    }
                }
            }
        }

        private static final Unit transcode$lambda$0(TranscodeDispatcher $dispatcher, double it) {
            Intrinsics.checkNotNullParameter((Object)$dispatcher, (String)"$dispatcher");
            $dispatcher.dispatchProgress(it);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

