/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.transcode;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.TranscoderListener;
import com.otaliastudios.transcoder.TranscoderOptions;

class TranscodeDispatcher {
    private final Handler mHandler;
    private final TranscoderListener mListener;

    TranscodeDispatcher(@NonNull TranscoderOptions options) {
        this.mHandler = options.getListenerHandler();
        this.mListener = options.getListener();
    }

    void dispatchCancel() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                TranscodeDispatcher.this.mListener.onTranscodeCanceled();
            }
        });
    }

    void dispatchSuccess(final int successCode) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                TranscodeDispatcher.this.mListener.onTranscodeCompleted(successCode);
            }
        });
    }

    void dispatchFailure(final @NonNull Throwable exception) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                TranscodeDispatcher.this.mListener.onTranscodeFailed(exception);
            }
        });
    }

    void dispatchProgress(final double progress2) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                TranscodeDispatcher.this.mListener.onTranscodeProgress(progress2);
            }
        });
    }
}

