/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.thumbnails;

import android.graphics.Bitmap;
import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Segment;
import com.otaliastudios.transcoder.internal.Segments;
import com.otaliastudios.transcoder.internal.Timer;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.codec.Decoder;
import com.otaliastudios.transcoder.internal.data.Reader;
import com.otaliastudios.transcoder.internal.data.Seeker;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.PipelineKt;
import com.otaliastudios.transcoder.internal.pipeline.PipelinesKt;
import com.otaliastudios.transcoder.internal.thumbnails.ThumbnailsEngine;
import com.otaliastudios.transcoder.internal.utils.EosKt;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.internal.video.VideoRenderer;
import com.otaliastudios.transcoder.internal.video.VideoSnapshots;
import com.otaliastudios.transcoder.resize.Resizer;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.strategy.DefaultVideoStrategy;
import com.otaliastudios.transcoder.strategy.RemoveTrackStrategy;
import com.otaliastudios.transcoder.thumbnail.Thumbnail;
import com.otaliastudios.transcoder.thumbnail.ThumbnailRequest;
import com.otaliastudios.transcoder.time.DefaultTimeInterpolator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 )2\u00020\u0001:\u0002()B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010&\u001a\u00020%2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#H\u0016J\b\u0010'\u001a\u00020%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\u00160\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/otaliastudios/transcoder/internal/thumbnails/DefaultThumbnailsEngine;", "Lcom/otaliastudios/transcoder/internal/thumbnails/ThumbnailsEngine;", "dataSources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "rotation", "", "resizer", "Lcom/otaliastudios/transcoder/resize/Resizer;", "requests", "", "Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "<init>", "(Lcom/otaliastudios/transcoder/internal/DataSources;ILcom/otaliastudios/transcoder/resize/Resizer;Ljava/util/List;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "segments", "Lcom/otaliastudios/transcoder/internal/Segments;", "timer", "Lcom/otaliastudios/transcoder/internal/Timer;", "positions", "Lkotlin/Pair;", "", "createPipeline", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "index", "count", "status", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "outputFormat", "Landroid/media/MediaFormat;", "progress", "Lkotlin/Function1;", "Lcom/otaliastudios/transcoder/thumbnail/Thumbnail;", "", "thumbnails", "cleanup", "Stub", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nDefaultThumbnailsEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultThumbnailsEngine.kt\ncom/otaliastudios/transcoder/internal/thumbnails/DefaultThumbnailsEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1368#2:142\n1454#2,2:143\n1557#2:145\n1628#2,3:146\n1456#2,3:149\n1053#2:152\n1611#2,9:153\n1863#2:162\n1864#2:165\n1620#2:166\n1557#2:167\n1628#2,3:168\n1#3:163\n1#3:164\n*S KotlinDebug\n*F\n+ 1 DefaultThumbnailsEngine.kt\ncom/otaliastudios/transcoder/internal/thumbnails/DefaultThumbnailsEngine\n*L\n66#1:142\n66#1:143,2\n68#1:145\n68#1:146,3\n66#1:149,3\n69#1:152\n86#1:153,9\n86#1:162\n86#1:165\n86#1:166\n95#1:167\n95#1:168,3\n86#1:164\n*E\n"})
public final class DefaultThumbnailsEngine
extends ThumbnailsEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSources dataSources;
    private final int rotation;
    @NotNull
    private final Logger log;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final Segments segments;
    @NotNull
    private final Timer timer;
    @NotNull
    private final List<Pair<Long, ThumbnailRequest>> positions;
    private Function1<? super Thumbnail, Unit> progress;
    private static final long WAIT_MS = 2L;
    private static final long PROGRESS_LOOPS = 10L;

    /*
     * WARNING - void declaration
     */
    public DefaultThumbnailsEngine(@NotNull DataSources dataSources, int rotation, @NotNull Resizer resizer, @NotNull List<? extends ThumbnailRequest> requests) {
        void $this$sortedBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)dataSources, (String)"dataSources");
        Intrinsics.checkNotNullParameter((Object)resizer, (String)"resizer");
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        this.dataSources = dataSources;
        this.rotation = rotation;
        this.log = new Logger("ThumbnailsEngine");
        this.tracks = new Tracks(TrackMapKt.trackMapOf(new DefaultVideoStrategy.Builder().frameRate(120).addResizer(resizer).build(), new RemoveTrackStrategy()), this.dataSources, this.rotation, true);
        this.segments = new Segments(this.dataSources, this.tracks, (Function5<? super TrackType, ? super Integer, ? super Integer, ? super TrackStatus, ? super MediaFormat, Pipeline>)((Function5)new Function5<TrackType, Integer, Integer, TrackStatus, MediaFormat, Pipeline>((Object)this){

            public final Pipeline invoke(TrackType p0, int p1, int p2, TrackStatus p3, MediaFormat p4) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                return DefaultThumbnailsEngine.access$createPipeline((DefaultThumbnailsEngine)this.receiver, p0, p1, p2, p3, p4);
            }
        }));
        this.timer = new Timer(new DefaultTimeInterpolator(), this.dataSources, this.tracks, (TrackMap<Integer>)this.segments.getCurrentIndex());
        this.log.i("Created Tracks, Segments, Timer...");
        Iterable iterable = requests;
        DefaultThumbnailsEngine defaultThumbnailsEngine = this;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ThumbnailRequest request = (ThumbnailRequest)element$iv$iv;
            boolean bl = false;
            long duration = this.timer.getTotalDurationUs();
            Iterable $this$map$iv = request.locate(duration);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)((long)it), (Object)request));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        defaultThumbnailsEngine.positions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Long)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getFirst()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Pipeline createPipeline(TrackType type, int index, int count, TrackStatus status, MediaFormat outputFormat) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        this.log.i("Creating pipeline #" + index + ". absoluteUs=" + CollectionsKt.joinToString$default((Iterable)this.positions, null, null, null, (int)0, null, DefaultThumbnailsEngine::createPipeline$lambda$3, (int)31, null));
        Iterable $this$mapNotNull$iv = this.positions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Stub stub;
            Long localizedUs;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            long positionUs2 = ((Number)pair.component1()).longValue();
            ThumbnailRequest request = (ThumbnailRequest)pair.component2();
            Long l = localizedUs = this.timer.localize(type, index, positionUs2);
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                stub = new Stub(request, positionUs2, localizedUs);
            } else {
                stub = null;
            }
            if (stub == null) continue;
            Stub it$iv$iv = stub;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List stubs = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (stubs.isEmpty()) {
            return PipelinesKt.EmptyPipeline();
        }
        DataSource source = EosKt.forcingEos((DataSource)this.dataSources.get(type).get(index), (Function0<Boolean>)((Function0)() -> DefaultThumbnailsEngine.createPipeline$lambda$6(stubs)));
        Iterable $this$map$iv = stubs;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv = (Stub)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getLocalizedUs());
        }
        List positions = (List)destination$iv$iv2;
        this.log.i("Requests for step #" + index + ": " + CollectionsKt.joinToString$default((Iterable)positions, null, null, null, (int)0, null, null, (int)63, null) + " [duration=" + source.getDurationUs() + "]");
        return Pipeline.Companion.build$lib_release$default(Pipeline.Companion, "Thumbnails", null, () -> DefaultThumbnailsEngine.createPipeline$lambda$10(source, positions, type, this, outputFormat, stubs), 2, null);
    }

    @Override
    public void thumbnails(@NotNull Function1<? super Thumbnail, Unit> progress2) {
        Intrinsics.checkNotNullParameter(progress2, (String)"progress");
        this.progress = progress2;
        while (true) {
            boolean completed;
            Segment segment = this.segments.next(TrackType.VIDEO);
            boolean advanced = segment != null ? segment.advance() : false;
            boolean bl = completed = !advanced && !this.segments.hasNext();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (completed) break;
            if (advanced) continue;
            Thread.sleep(WAIT_MS);
        }
    }

    @Override
    public void cleanup() {
        Object object;
        Object $this$cleanup_u24lambda_u2411;
        DefaultThumbnailsEngine defaultThumbnailsEngine = this;
        try {
            $this$cleanup_u24lambda_u2411 = defaultThumbnailsEngine;
            boolean bl = false;
            ((DefaultThumbnailsEngine)$this$cleanup_u24lambda_u2411).segments.release();
            $this$cleanup_u24lambda_u2411 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$cleanup_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        defaultThumbnailsEngine = this;
        try {
            DefaultThumbnailsEngine $this$cleanup_u24lambda_u2412 = defaultThumbnailsEngine;
            boolean bl = false;
            $this$cleanup_u24lambda_u2412.dataSources.release();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private static final CharSequence createPipeline$lambda$3(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(((Number)it.getFirst()).longValue());
    }

    private static final boolean createPipeline$lambda$6(List $stubs) {
        Intrinsics.checkNotNullParameter((Object)$stubs, (String)"$stubs");
        return $stubs.isEmpty();
    }

    private static final boolean createPipeline$lambda$10$lambda$8(List $stubs, long it) {
        Intrinsics.checkNotNullParameter((Object)$stubs, (String)"$stubs");
        Stub stub = (Stub)CollectionsKt.firstOrNull((List)$stubs);
        return stub != null ? it == stub.getLocalizedUs() : false;
    }

    private static final Unit createPipeline$lambda$10$lambda$9(List $stubs, DefaultThumbnailsEngine this$0, long pos, Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)$stubs, (String)"$stubs");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Stub stub = (Stub)CollectionsKt.removeFirst((List)$stubs);
        stub.setActualLocalizedUs(pos);
        this$0.log.i("Got snapshot. positionUs=" + stub.getPositionUs() + " localizedUs=" + stub.getLocalizedUs() + " actualLocalizedUs=" + stub.getActualLocalizedUs() + " deltaUs=" + (stub.getLocalizedUs() - stub.getActualLocalizedUs()));
        Thumbnail thumbnail = new Thumbnail(stub.getRequest(), stub.getPositionUs(), bitmap);
        Function1<? super Thumbnail, Unit> function1 = this$0.progress;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progress");
            function1 = null;
        }
        function1.invoke((Object)thumbnail);
        return Unit.INSTANCE;
    }

    private static final Pipeline.Builder createPipeline$lambda$10(DataSource $source, List $positions, TrackType $type, DefaultThumbnailsEngine this$0, MediaFormat $outputFormat, List $stubs) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$positions, (String)"$positions");
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$outputFormat, (String)"$outputFormat");
        Intrinsics.checkNotNullParameter((Object)$stubs, (String)"$stubs");
        Pipeline.Builder builder = PipelineKt.plus(new Seeker($source, $positions, (Function1<? super Long, Boolean>)((Function1)arg_0 -> DefaultThumbnailsEngine.createPipeline$lambda$10$lambda$8($stubs, arg_0))), new Reader($source, $type));
        MediaFormat mediaFormat = $source.getTrackFormat($type);
        Intrinsics.checkNotNull((Object)mediaFormat);
        return builder.plus(new Decoder(mediaFormat, false)).plus(new VideoRenderer($source.getOrientation(), this$0.rotation, $outputFormat, true)).plus(new VideoSnapshots($outputFormat, $positions, 50000L, (Function2<? super Long, ? super Bitmap, Unit>)((Function2)(arg_0, arg_1) -> DefaultThumbnailsEngine.createPipeline$lambda$10$lambda$9($stubs, this$0, arg_0, arg_1))));
    }

    public static final /* synthetic */ Pipeline access$createPipeline(DefaultThumbnailsEngine $this, TrackType type, int index, int count, TrackStatus status, MediaFormat outputFormat) {
        return $this.createPipeline(type, index, count, status, outputFormat);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/otaliastudios/transcoder/internal/thumbnails/DefaultThumbnailsEngine$Companion;", "", "<init>", "()V", "WAIT_MS", "", "PROGRESS_LOOPS", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/otaliastudios/transcoder/internal/thumbnails/DefaultThumbnailsEngine$Stub;", "", "request", "Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "positionUs", "", "localizedUs", "<init>", "(Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;JJ)V", "getRequest", "()Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "getPositionUs", "()J", "getLocalizedUs", "actualLocalizedUs", "getActualLocalizedUs", "setActualLocalizedUs", "(J)V", "lib_release"})
    private static final class Stub {
        @NotNull
        private final ThumbnailRequest request;
        private final long positionUs;
        private final long localizedUs;
        private long actualLocalizedUs;

        public Stub(@NotNull ThumbnailRequest request, long positionUs2, long localizedUs) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.request = request;
            this.positionUs = positionUs2;
            this.actualLocalizedUs = this.localizedUs = localizedUs;
        }

        @NotNull
        public final ThumbnailRequest getRequest() {
            return this.request;
        }

        public final long getPositionUs() {
            return this.positionUs;
        }

        public final long getLocalizedUs() {
            return this.localizedUs;
        }

        public final long getActualLocalizedUs() {
            return this.actualLocalizedUs;
        }

        public final void setActualLocalizedUs(long l) {
            this.actualLocalizedUs = l;
        }
    }
}

