/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.pipeline;

import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.PipelineItem;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.pipeline.Step;
import com.otaliastudios.transcoder.internal.utils.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0006\u0010\u000e\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "", "name", "", "items", "", "Lcom/otaliastudios/transcoder/internal/pipeline/PipelineItem;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "execute", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "", "release", "Companion", "Builder", "lib_release"})
@SourceDebugExtension(value={"SMAP\nPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pipeline.kt\ncom/otaliastudios/transcoder/internal/pipeline/Pipeline\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1863#2,2:199\n1863#2,2:201\n*S KotlinDebug\n*F\n+ 1 Pipeline.kt\ncom/otaliastudios/transcoder/internal/pipeline/Pipeline\n*L\n71#1:199,2\n164#1:201,2\n*E\n"})
public final class Pipeline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PipelineItem> items;
    @NotNull
    private final Logger log;

    private Pipeline(String name, List<PipelineItem> items) {
        this.items = items;
        this.log = new Logger(name);
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)CollectionsKt.zipWithNext((Iterable)this.items));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            PipelineItem first = (PipelineItem)pair.component1();
            PipelineItem next = (PipelineItem)pair.component2();
            first.attachToNext(next);
        }
    }

    @NotNull
    public final State<Unit> execute() {
        this.log.v("LOOP");
        boolean advanced = false;
        boolean sleeps = false;
        int n = ((Collection)this.items).size();
        for (int i = 0; i < n; ++i) {
            PipelineItem item = this.items.get(i);
            if (item.canHandle(i == 0)) {
                this.log.v(item.getName() + " START #" + item.getPackets() + " (" + item.getUnhandled().size() + " pending)");
                State.Failure failure = item.handle();
                if (failure != null) {
                    sleeps = sleeps || failure.getSleep();
                    this.log.v(item.getName() + " FAILED #" + item.getPackets());
                } else {
                    this.log.v(item.getName() + " SUCCESS #" + item.getPackets() + " " + (item.getDone() ? "(eos)" : ""));
                }
                advanced = advanced || item.getAdvanced();
                continue;
            }
            this.log.v(item.getName() + " SKIP #" + item.getPackets() + " " + (item.getDone() ? "(eos)" : ""));
        }
        return this.items.isEmpty() ? (State)new State.Eos<Unit>(Unit.INSTANCE) : (((PipelineItem)CollectionsKt.last(this.items)).getDone() ? (State)new State.Eos<Unit>(Unit.INSTANCE) : (advanced ? (State)new State.Ok<Unit>(Unit.INSTANCE) : (State)new State.Retry(sleeps)));
    }

    public final void release() {
        Iterable $this$forEach$iv = this.items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PipelineItem it = (PipelineItem)element$iv;
            boolean bl = false;
            it.getStep().release();
        }
    }

    public /* synthetic */ Pipeline(String name, List items, DefaultConstructorMarker $constructor_marker) {
        this(name, items);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0002B)\b\u0000\u0012\u001e\b\u0002\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJI\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0000\"\b\b\u0002\u0010\r*\u00020\u0002\"\b\b\u0003\u0010\u000e*\u00020\u00042\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0007H\u0086\u0002R*\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline$Builder;", "D", "", "C", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "steps", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Step;", "<init>", "(Ljava/util/List;)V", "getSteps$lib_release", "()Ljava/util/List;", "plus", "NewData", "NewChannel", "step", "lib_release"})
    public static final class Builder<D, C extends Channel> {
        @NotNull
        private final List<Step<?, ?, ?, ?>> steps;

        public Builder(@NotNull List<? extends Step<?, ?, ?, ?>> steps) {
            Intrinsics.checkNotNullParameter(steps, (String)"steps");
            this.steps = steps;
        }

        public /* synthetic */ Builder(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<Step<?, ?, ?, ?>> getSteps$lib_release() {
            return this.steps;
        }

        @NotNull
        public final <NewData, NewChannel extends Channel> Builder<NewData, NewChannel> plus(@NotNull Step<D, C, NewData, NewChannel> step) {
            Intrinsics.checkNotNullParameter(step, (String)"step");
            return new Builder<D, C>(CollectionsKt.plus((Collection)this.steps, step));
        }

        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline$Companion;", "", "<init>", "()V", "build", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "name", "", "debug", "builder", "Lkotlin/Function0;", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline$Builder;", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "build$lib_release", "lib_release"})
    @SourceDebugExtension(value={"SMAP\nPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pipeline.kt\ncom/otaliastudios/transcoder/internal/pipeline/Pipeline$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1567#2:199\n1598#2,4:200\n*S KotlinDebug\n*F\n+ 1 Pipeline.kt\ncom/otaliastudios/transcoder/internal/pipeline/Pipeline$Companion\n*L\n170#1:199\n170#1:200,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pipeline build$lib_release(@NotNull String name, @Nullable String debug, @NotNull Function0<? extends Builder<?, Channel>> builder) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            List<Step<?, ?, ?, ?>> steps = ((Builder)builder.invoke()).getSteps$lib_release();
            Iterable $this$mapIndexed$iv = steps;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void step;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Step step2 = (Step)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)step, (String)"null cannot be cast to non-null type com.otaliastudios.transcoder.internal.pipeline.Step<kotlin.Any, com.otaliastudios.transcoder.internal.pipeline.Channel, kotlin.Any, com.otaliastudios.transcoder.internal.pipeline.Channel>");
                collection.add(new PipelineItem((Step<Object, Channel, Object, Channel>)step, (int)(index + true) + "/" + steps.size() + " '" + step.getName() + "'"));
            }
            List items = (List)destination$iv$iv;
            String string = debug;
            if (string == null) {
                string = "";
            }
            return new Pipeline(name + "Pipeline" + string, items, null);
        }

        public static /* synthetic */ Pipeline build$lib_release$default(Companion companion, String string, String string2, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                function0 = Companion::build$lambda$0;
            }
            return companion.build$lib_release(string, string2, function0);
        }

        private static final Builder build$lambda$0() {
            return new Builder(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

