/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.codec;

import com.otaliastudios.transcoder.internal.utils.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0003J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/DecoderDropper;", "", "continuous", "", "<init>", "(Z)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "closedDeltas", "", "Lkotlin/ranges/LongRange;", "", "closedRanges", "", "pendingRange", "firstInputUs", "Ljava/lang/Long;", "firstOutputUs", "debug", "", "message", "", "important", "input", "timeUs", "render", "output", "(J)Ljava/lang/Long;", "lib_release"})
@SourceDebugExtension(value={"SMAP\nDecoderDropper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecoderDropper.kt\ncom/otaliastudios/transcoder/internal/codec/DecoderDropper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1863#2,2:93\n*S KotlinDebug\n*F\n+ 1 DecoderDropper.kt\ncom/otaliastudios/transcoder/internal/codec/DecoderDropper\n*L\n69#1:93,2\n*E\n"})
public final class DecoderDropper {
    private final boolean continuous;
    @NotNull
    private final Logger log;
    @NotNull
    private final Map<LongRange, Long> closedDeltas;
    @NotNull
    private final List<LongRange> closedRanges;
    @Nullable
    private LongRange pendingRange;
    @Nullable
    private Long firstInputUs;
    @Nullable
    private Long firstOutputUs;

    public DecoderDropper(boolean continuous) {
        this.continuous = continuous;
        this.log = new Logger("DecoderDropper");
        this.closedDeltas = new LinkedHashMap();
        this.closedRanges = new ArrayList();
    }

    private final void debug(String message, boolean important) {
    }

    static /* synthetic */ void debug$default(DecoderDropper decoderDropper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        decoderDropper.debug(string, bl);
    }

    public final void input(long timeUs, boolean render) {
        if (this.firstInputUs == null) {
            this.firstInputUs = timeUs;
        }
        if (render) {
            DecoderDropper.debug$default(this, "INPUT: inputUs=" + timeUs, false, 2, null);
            if (this.pendingRange == null) {
                this.pendingRange = new LongRange(timeUs, Long.MAX_VALUE);
            } else {
                LongRange longRange = this.pendingRange;
                Intrinsics.checkNotNull((Object)longRange);
                this.pendingRange = new LongRange(longRange.getFirst(), timeUs);
            }
        } else {
            DecoderDropper.debug$default(this, "INPUT: Got SKIPPING input! inputUs=" + timeUs, false, 2, null);
            if (this.pendingRange != null) {
                LongRange longRange = this.pendingRange;
                Intrinsics.checkNotNull((Object)longRange);
                if (longRange.getLast() != Long.MAX_VALUE) {
                    long l;
                    LongRange longRange2 = this.pendingRange;
                    Intrinsics.checkNotNull((Object)longRange2);
                    this.closedRanges.add(longRange2);
                    LongRange longRange3 = this.pendingRange;
                    Intrinsics.checkNotNull((Object)longRange3);
                    if (this.closedRanges.size() >= 2) {
                        LongRange longRange4 = this.pendingRange;
                        Intrinsics.checkNotNull((Object)longRange4);
                        l = longRange4.getFirst() - this.closedRanges.get(CollectionsKt.getLastIndex(this.closedRanges) - 1).getLast();
                    } else {
                        l = 0L;
                    }
                    this.closedDeltas.put(longRange3, l);
                }
            }
            this.pendingRange = null;
        }
    }

    @Nullable
    public final Long output(long timeUs) {
        if (this.firstOutputUs == null) {
            this.firstOutputUs = timeUs;
        }
        Long l = this.firstInputUs;
        Intrinsics.checkNotNull((Object)l);
        long l2 = l;
        Long l3 = this.firstOutputUs;
        Intrinsics.checkNotNull((Object)l3);
        long timeInInputScaleUs = l2 + (timeUs - l3);
        long deltaUs = 0L;
        Iterable $this$forEach$iv = this.closedRanges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LongRange it = (LongRange)element$iv;
            boolean bl = false;
            Long l4 = this.closedDeltas.get(it);
            Intrinsics.checkNotNull((Object)l4);
            deltaUs += ((Number)l4).longValue();
            if (!it.contains(timeInInputScaleUs)) continue;
            DecoderDropper.debug$default(this, "OUTPUT: Rendering! outputTimeUs=" + timeUs + " newOutputTimeUs=" + (timeUs - deltaUs) + " deltaUs=" + deltaUs, false, 2, null);
            return this.continuous ? Long.valueOf(timeUs - deltaUs) : Long.valueOf(timeUs);
        }
        if (this.pendingRange != null) {
            LongRange longRange = this.pendingRange;
            Intrinsics.checkNotNull((Object)longRange);
            if (longRange.contains(timeInInputScaleUs)) {
                if (!((Collection)this.closedRanges).isEmpty()) {
                    LongRange longRange2 = this.pendingRange;
                    Intrinsics.checkNotNull((Object)longRange2);
                    deltaUs += longRange2.getFirst() - ((LongRange)CollectionsKt.last(this.closedRanges)).getLast();
                }
                DecoderDropper.debug$default(this, "OUTPUT: Rendering! outputTimeUs=" + timeUs + " newOutputTimeUs=" + (timeUs - deltaUs) + " deltaUs=" + deltaUs, false, 2, null);
                return this.continuous ? Long.valueOf(timeUs - deltaUs) : Long.valueOf(timeUs);
            }
        }
        this.debug("OUTPUT: SKIPPING! outputTimeUs=" + timeUs, true);
        return null;
    }
}

