/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001&B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\nH\u0002J%\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0002\u0010%J\u0016\u0010\u0002\u001a\u00020!2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R&\u0010\u001d\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\n0\u001f\u0012\u0004\u0012\u00020!0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/otaliastudios/transcoder/internal/Timer;", "", "interpolator", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "sources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "current", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "", "<init>", "(Lcom/otaliastudios/transcoder/time/TimeInterpolator;Lcom/otaliastudios/transcoder/internal/DataSources;Lcom/otaliastudios/transcoder/internal/Tracks;Lcom/otaliastudios/transcoder/internal/utils/TrackMap;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "durationUs", "", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "positionUs", "getPositionUs", "()Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "getDurationUs", "totalDurationUs", "getTotalDurationUs", "()J", "progress", "", "getProgress", "interpolators", "", "Lkotlin/Pair;", "Lcom/otaliastudios/transcoder/common/TrackType;", "Lcom/otaliastudios/transcoder/internal/Timer$SegmentInterpolator;", "localize", "type", "index", "(Lcom/otaliastudios/transcoder/common/TrackType;IJ)Ljava/lang/Long;", "SegmentInterpolator", "lib_release"})
@SourceDebugExtension(value={"SMAP\nTimer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Timer.kt\ncom/otaliastudios/transcoder/internal/Timer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,108:1\n1812#2,4:109\n1812#2,4:113\n785#2:117\n796#2:118\n1872#2,2:119\n797#2,2:121\n1874#2:123\n799#2:124\n381#3,7:125\n*S KotlinDebug\n*F\n+ 1 Timer.kt\ncom/otaliastudios/transcoder/internal/Timer\n*L\n18#1:109,4\n23#1:113,4\n63#1:117\n63#1:118\n63#1:119,2\n63#1:121,2\n63#1:123\n63#1:124\n71#1:125,7\n*E\n"})
public final class Timer {
    @NotNull
    private final TimeInterpolator interpolator;
    @NotNull
    private final DataSources sources;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final TrackMap<Integer> current;
    @NotNull
    private final Logger log;
    @NotNull
    private final TrackMap<Long> positionUs;
    @NotNull
    private final TrackMap<Long> durationUs;
    @NotNull
    private final TrackMap<Double> progress;
    @NotNull
    private final Map<Pair<TrackType, Integer>, SegmentInterpolator> interpolators;

    public Timer(@NotNull TimeInterpolator interpolator, @NotNull DataSources sources, @NotNull Tracks tracks, @NotNull TrackMap<Integer> current) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)tracks, (String)"tracks");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        this.interpolator = interpolator;
        this.sources = sources;
        this.tracks = tracks;
        this.current = current;
        this.log = new Logger("Timer");
        this.positionUs = new TrackMap<Long>(this){
            final /* synthetic */ Timer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean has(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            public Long get(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return !Timer.access$getTracks$p(this.this$0).getActive().has(type) ? 0L : Timer.access$positionUs(this.this$0, (List)Timer.access$getSources$p(this.this$0).get(type), ((Number)Timer.access$getCurrent$p(this.this$0).get(type)).intValue());
            }

            public Long getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            public Long getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public Long getOrNull(TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            public Long videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            public Long audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            public Iterator<Long> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }
        };
        this.durationUs = new TrackMap<Long>(this){
            final /* synthetic */ Timer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean has(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            public Long get(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return !Timer.access$getTracks$p(this.this$0).getActive().has(type) ? 0L : Timer.access$durationUs(this.this$0, (List)Timer.access$getSources$p(this.this$0).get(type), ((Number)Timer.access$getCurrent$p(this.this$0).get(type)).intValue());
            }

            public Long getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            public Long getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public Long getOrNull(TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            public Long videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            public Long audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            public Iterator<Long> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }
        };
        this.progress = new TrackMap<Double>(this){
            final /* synthetic */ Timer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean has(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            public Double get(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                long read = ((Number)this.this$0.getPositionUs().get(type)).longValue();
                long total = ((Number)this.this$0.getDurationUs().get(type)).longValue();
                return total == 0L ? 0.0 : (double)read / (double)total;
            }

            public Double getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            public Double getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public Double getOrNull(TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            public Double videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            public Double audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            public Iterator<Double> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }
        };
        this.interpolators = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    private final long durationUs(List<? extends DataSource> $this$durationUs, int current) {
        void $this$foldIndexed$iv;
        Iterable iterable = $this$durationUs;
        long initial$iv = 0L;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void source;
            void acc;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataSource dataSource = (DataSource)element$iv;
            long l = accumulator$iv;
            int index = n;
            boolean bl = false;
            accumulator$iv = acc + (index < current ? source.getPositionUs() : source.getDurationUs());
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final long positionUs(List<? extends DataSource> $this$positionUs, int current) {
        void $this$foldIndexed$iv;
        Iterable iterable = $this$positionUs;
        long initial$iv = 0L;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void source;
            void acc;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataSource dataSource = (DataSource)element$iv;
            long l = accumulator$iv;
            int index = n;
            boolean bl = false;
            accumulator$iv = index <= current ? acc + source.getPositionUs() : acc;
        }
        return accumulator$iv;
    }

    @NotNull
    public final TrackMap<Long> getPositionUs() {
        return this.positionUs;
    }

    @NotNull
    public final TrackMap<Long> getDurationUs() {
        return this.durationUs;
    }

    public final long getTotalDurationUs() {
        long video = this.tracks.getActive().getHasVideo() ? ((Number)this.durationUs.getVideo()).longValue() : Long.MAX_VALUE;
        long audio = this.tracks.getActive().getHasAudio() ? ((Number)this.durationUs.getAudio()).longValue() : Long.MAX_VALUE;
        return Math.min(video, audio);
    }

    @NotNull
    public final TrackMap<Double> getProgress() {
        return this.progress;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long localize(@NotNull TrackType type, int index, long positionUs2) {
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.tracks.getActive().has(type)) {
            return null;
        }
        Iterable iterable = (Iterable)this.sources.get(type);
        Timer timer = this;
        boolean $i$f$filterIndexed = false;
        void var9_8 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            DataSource cfr_ignored_0 = (DataSource)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            if (!(i < index)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        long behindUs = timer.durationUs((List)destination$iv$iv, -1);
        long localizedUs = positionUs2 - behindUs;
        if (localizedUs < 0L) {
            return null;
        }
        if (localizedUs > ((DataSource)this.sources.get(type).get(index)).getDurationUs()) {
            return null;
        }
        return localizedUs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SegmentInterpolator interpolator(@NotNull TrackType type, int index) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Map<Pair<TrackType, Integer>, SegmentInterpolator> map = this.interpolators;
        Pair key$iv = TuplesKt.to((Object)((Object)type), (Object)index);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            SegmentInterpolator answer$iv = new SegmentInterpolator(new Logger(type.getDisplayName$lib_release() + "Interpolator" + index + "/" + this.sources.get(type).size()), this.interpolator, index == 0 ? null : this.interpolator(type, index - 1));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SegmentInterpolator)object;
    }

    public static final /* synthetic */ Tracks access$getTracks$p(Timer $this) {
        return $this.tracks;
    }

    public static final /* synthetic */ long access$positionUs(Timer $this, List $receiver, int current) {
        return $this.positionUs($receiver, current);
    }

    public static final /* synthetic */ DataSources access$getSources$p(Timer $this) {
        return $this.sources;
    }

    public static final /* synthetic */ TrackMap access$getCurrent$p(Timer $this) {
        return $this.current;
    }

    public static final /* synthetic */ long access$durationUs(Timer $this, List $receiver, int current) {
        return $this.durationUs($receiver, current);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/otaliastudios/transcoder/internal/Timer$SegmentInterpolator;", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "user", "previous", "<init>", "(Lcom/otaliastudios/transcoder/internal/utils/Logger;Lcom/otaliastudios/transcoder/time/TimeInterpolator;Lcom/otaliastudios/transcoder/internal/Timer$SegmentInterpolator;)V", "inputBase", "", "interpolatedLast", "outputLast", "outputBase", "getOutputBase", "()J", "outputBase$delegate", "Lkotlin/Lazy;", "interpolate", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "time", "lib_release"})
    @SourceDebugExtension(value={"SMAP\nTimer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Timer.kt\ncom/otaliastudios/transcoder/internal/Timer$SegmentInterpolator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
    public static final class SegmentInterpolator
    implements TimeInterpolator {
        @NotNull
        private final Logger log;
        @NotNull
        private final TimeInterpolator user;
        private long inputBase;
        private long interpolatedLast;
        private long outputLast;
        @NotNull
        private final Lazy outputBase$delegate;

        public SegmentInterpolator(@NotNull Logger log, @NotNull TimeInterpolator user, @Nullable SegmentInterpolator previous) {
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            this.log = log;
            this.user = user;
            this.inputBase = Long.MIN_VALUE;
            this.interpolatedLast = Long.MIN_VALUE;
            this.outputLast = Long.MIN_VALUE;
            this.outputBase$delegate = LazyKt.lazy(() -> SegmentInterpolator.outputBase_delegate$lambda$1(previous, this));
        }

        private final long getOutputBase() {
            Lazy lazy = this.outputBase$delegate;
            return ((Number)lazy.getValue()).longValue();
        }

        @Override
        public long interpolate(@NotNull TrackType type, long time) {
            long l;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            if (this.inputBase == Long.MIN_VALUE) {
                this.inputBase = time;
            }
            this.outputLast = this.getOutputBase() + (time - this.inputBase);
            long it = l = this.user.interpolate(type, this.outputLast);
            boolean bl = false;
            if (!(it > this.interpolatedLast)) {
                boolean bl2 = false;
                String string = "Timestamps must be monotonically increasing: " + it + ", " + this.interpolatedLast;
                throw new IllegalStateException(string.toString());
            }
            this.interpolatedLast = it;
            return l;
        }

        private static final long outputBase_delegate$lambda$1(SegmentInterpolator $previous, SegmentInterpolator this$0) {
            long l;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            long it = l = $previous == null ? 0L : $previous.outputLast + 1L;
            boolean bl = false;
            this$0.log.i("Found output base timestamp: " + it);
            return l;
        }
    }
}

