/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.State;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/otaliastudios/transcoder/internal/Segment;", "", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "index", "", "pipeline", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "<init>", "(Lcom/otaliastudios/transcoder/common/TrackType;ILcom/otaliastudios/transcoder/internal/pipeline/Pipeline;)V", "getType", "()Lcom/otaliastudios/transcoder/common/TrackType;", "getIndex", "()I", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "", "advance", "", "canAdvance", "needsSleep", "release", "lib_release"})
public final class Segment {
    @NotNull
    private final TrackType type;
    private final int index;
    @NotNull
    private final Pipeline pipeline;
    @Nullable
    private State<Unit> state;

    public Segment(@NotNull TrackType type, int index, @NotNull Pipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        this.type = type;
        this.index = index;
        this.pipeline = pipeline;
    }

    @NotNull
    public final TrackType getType() {
        return this.type;
    }

    public final int getIndex() {
        return this.index;
    }

    public final boolean advance() {
        this.state = this.pipeline.execute();
        return this.state instanceof State.Ok;
    }

    public final boolean canAdvance() {
        return this.state == null || !(this.state instanceof State.Eos);
    }

    public final boolean needsSleep() {
        State<Unit> state = this.state;
        if (state == null) {
            return false;
        }
        State<Unit> s = state;
        if (s instanceof State.Ok) {
            return false;
        }
        if (s instanceof State.Failure) {
            return ((State.Failure)s).getSleep();
        }
        throw new NoWhenBranchMatchedException();
    }

    public final void release() {
        this.pipeline.release();
    }
}

