/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import com.otaliastudios.transcoder.ThumbnailerOptions;
import com.otaliastudios.transcoder.TranscoderOptions;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.source.BlankAudioDataSource;
import com.otaliastudios.transcoder.source.DataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B%\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0003H\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020\u0003H\u0002J\u0012\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0012\u0010\u0011\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0006\u0010\u001a\u001a\u00020\u0010R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/otaliastudios/transcoder/internal/DataSources;", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "videoSources", "audioSources", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "options", "Lcom/otaliastudios/transcoder/TranscoderOptions;", "(Lcom/otaliastudios/transcoder/TranscoderOptions;)V", "Lcom/otaliastudios/transcoder/ThumbnailerOptions;", "(Lcom/otaliastudios/transcoder/ThumbnailerOptions;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "init", "", "deinit", "discarded", "", "get", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "has", "", "all", "release", "lib_release"})
@SourceDebugExtension(value={"SMAP\nDataSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSources.kt\ncom/otaliastudios/transcoder/internal/DataSources\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1782#2,4:88\n1782#2,4:93\n1557#2:97\n1628#2,3:98\n1863#2,2:101\n1863#2,2:103\n1#3:92\n*S KotlinDebug\n*F\n+ 1 DataSources.kt\ncom/otaliastudios/transcoder/internal/DataSources\n*L\n45#1:88,4\n54#1:93,4\n61#1:97\n61#1:98,3\n24#1:101,2\n28#1:103,2\n*E\n"})
public final class DataSources
implements TrackMap<List<? extends DataSource>> {
    @NotNull
    private final Logger log;
    @NotNull
    private final List<DataSource> discarded;
    @NotNull
    private final List<DataSource> videoSources;
    @NotNull
    private final List<DataSource> audioSources;

    /*
     * WARNING - void declaration
     */
    private DataSources(List<? extends DataSource> videoSources, List<? extends DataSource> audioSources) {
        List list;
        void $this$audioSources_u24lambda_u249;
        int n;
        List list2;
        DataSources $this$videoSources_u24lambda_u244;
        int valid;
        DataSource it;
        int n2;
        this.log = new Logger("DataSources");
        this.log.i("initializing videoSources...");
        this.init(videoSources);
        this.log.i("initializing audioSources...");
        this.init(audioSources);
        this.discarded = new ArrayList();
        DataSources dataSources = this;
        DataSources dataSources2 = this;
        boolean bl = false;
        Iterable $this$count$iv22 = videoSources;
        boolean $i$f$count = false;
        if ($this$count$iv22 instanceof Collection && ((Collection)$this$count$iv22).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv22) {
                it = (DataSource)element$iv;
                boolean bl2 = false;
                if (!(it.getTrackFormat(TrackType.VIDEO) != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int $this$count$iv22 = valid = n2;
        if ($this$count$iv22 == 0) {
            List it2 = $i$f$count = CollectionsKt.emptyList();
            boolean bl3 = false;
            CollectionsKt.addAll((Collection)$this$videoSources_u24lambda_u244.discarded, (Iterable)videoSources);
            list2 = $i$f$count;
        } else {
            list2 = $this$count$iv22 == videoSources.size() ? videoSources : videoSources;
        }
        dataSources2.videoSources = list2;
        $this$videoSources_u24lambda_u244 = this;
        dataSources2 = this;
        boolean bl4 = false;
        Iterable $this$count$iv = audioSources;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (DataSource)element$iv;
                boolean bl5 = false;
                if (!(it.getTrackFormat(TrackType.AUDIO) != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        valid = n;
        $this$audioSources_u24lambda_u249.log.i("computing audioSources, valid=" + valid);
        int n3 = valid;
        if (n3 == 0) {
            List it3 = $i$f$count = CollectionsKt.emptyList();
            boolean bl6 = false;
            CollectionsKt.addAll((Collection)$this$audioSources_u24lambda_u249.discarded, (Iterable)audioSources);
            list = $i$f$count;
        } else if (n3 == audioSources.size()) {
            list = audioSources;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = audioSources;
            boolean $i$f$map = false;
            Iterable bl6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DataSource dataSource;
                void source;
                DataSource dataSource2 = (DataSource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                if (source.getTrackFormat(TrackType.AUDIO) != null) {
                    dataSource = source;
                } else {
                    BlankAudioDataSource blankAudioDataSource;
                    BlankAudioDataSource it4 = blankAudioDataSource = new BlankAudioDataSource(source.getDurationUs());
                    boolean bl8 = false;
                    ((Collection)$this$audioSources_u24lambda_u249.discarded).add(source);
                    dataSource = blankAudioDataSource;
                }
                collection.add(dataSource);
            }
            list = (List)destination$iv$iv;
        }
        dataSources2.audioSources = list;
    }

    public DataSources(@NotNull TranscoderOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        List<DataSource> list = options.getVideoDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getVideoDataSources(...)");
        List<DataSource> list2 = options.getAudioDataSources();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAudioDataSources(...)");
        this(list, list2);
    }

    public DataSources(@NotNull ThumbnailerOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this(options.getDataSources(), CollectionsKt.emptyList());
    }

    private final void init(DataSource $this$init) {
        if (!$this$init.isInitialized()) {
            $this$init.initialize();
        }
    }

    private final void deinit(DataSource $this$deinit) {
        if ($this$deinit.isInitialized()) {
            $this$deinit.deinitialize();
        }
    }

    private final void init(List<? extends DataSource> $this$init) {
        Iterable $this$forEach$iv = $this$init;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSource it = (DataSource)element$iv;
            boolean bl = false;
            this.log.i("initializing " + it + "... (isInit=" + it.isInitialized() + ")");
            this.init(it);
        }
    }

    private final void deinit(List<? extends DataSource> $this$deinit) {
        Iterable $this$forEach$iv = $this$deinit;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSource it = (DataSource)element$iv;
            boolean bl = false;
            this.log.i("deinitializing " + it + "... (isInit=" + it.isInitialized() + ")");
            this.deinit(it);
        }
    }

    @Override
    @NotNull
    public List<DataSource> get(@NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.audioSources;
            case 2 -> this.videoSources;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean has(@NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return !((Collection)this.get(type)).isEmpty();
    }

    @NotNull
    public final List<DataSource> all() {
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((Collection)this.getAudio()), (Iterable)((Iterable)this.getVideo())));
    }

    public final void release() {
        this.log.i("release(): releasing...");
        this.deinit((List)this.getVideo());
        this.deinit((List)this.getAudio());
        this.deinit(this.discarded);
        this.log.i("release(): released.");
    }

    @Override
    @NotNull
    public List<DataSource> getVideo() {
        return TrackMap.DefaultImpls.getVideo(this);
    }

    @Override
    @NotNull
    public List<DataSource> getAudio() {
        return TrackMap.DefaultImpls.getAudio(this);
    }

    @Override
    public boolean getHasVideo() {
        return TrackMap.DefaultImpls.getHasVideo(this);
    }

    @Override
    public boolean getHasAudio() {
        return TrackMap.DefaultImpls.getHasAudio(this);
    }

    @Override
    @Nullable
    public List<DataSource> getOrNull(@NotNull TrackType type) {
        return TrackMap.DefaultImpls.getOrNull(this, type);
    }

    @Override
    @Nullable
    public List<DataSource> videoOrNull() {
        return TrackMap.DefaultImpls.videoOrNull(this);
    }

    @Override
    @Nullable
    public List<DataSource> audioOrNull() {
        return TrackMap.DefaultImpls.audioOrNull(this);
    }

    @Override
    public int getSize() {
        return TrackMap.DefaultImpls.getSize(this);
    }

    @Override
    @NotNull
    public Iterator<List<DataSource>> iterator() {
        return TrackMap.DefaultImpls.iterator(this);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackType.values().length];
            try {
                nArray[TrackType.AUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

