/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.EGL14;
import com.otaliastudios.opengl.core.EglCore;
import com.otaliastudios.opengl.surface.EglWindowSurface;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/otaliastudios/transcoder/internal/Codecs;", "", "sources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "current", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "", "<init>", "(Lcom/otaliastudios/transcoder/internal/DataSources;Lcom/otaliastudios/transcoder/internal/Tracks;Lcom/otaliastudios/transcoder/internal/utils/TrackMap;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "encoders", "Lcom/otaliastudios/transcoder/internal/Codecs$Codec;", "getEncoders", "()Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "ownsEncoderStart", "", "getOwnsEncoderStart", "ownsEncoderStop", "getOwnsEncoderStop", "release", "", "Surface", "Codec", "lib_release"})
@SourceDebugExtension(value={"SMAP\nCodecs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Codecs.kt\ncom/otaliastudios/transcoder/internal/Codecs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1863#2,2:146\n*S KotlinDebug\n*F\n+ 1 Codecs.kt\ncom/otaliastudios/transcoder/internal/Codecs\n*L\n141#1:146,2\n*E\n"})
public final class Codecs {
    @NotNull
    private final DataSources sources;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final TrackMap<Integer> current;
    @NotNull
    private final Logger log;
    @NotNull
    private final TrackMap<Codec> encoders;
    @NotNull
    private final TrackMap<Boolean> ownsEncoderStart;
    @NotNull
    private final TrackMap<Boolean> ownsEncoderStop;

    public Codecs(@NotNull DataSources sources, @NotNull Tracks tracks, @NotNull TrackMap<Integer> current) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)tracks, (String)"tracks");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        this.sources = sources;
        this.tracks = tracks;
        this.current = current;
        this.log = new Logger("Codecs");
        this.encoders = new TrackMap<Codec>(this){
            private final Lazy lazyAudio$delegate;
            private final Lazy lazyVideo$delegate;
            final /* synthetic */ Codecs this$0;
            {
                this.this$0 = $receiver;
                this.lazyAudio$delegate = LazyKt.lazy(() -> encoders.1.lazyAudio_delegate$lambda$0($receiver));
                this.lazyVideo$delegate = LazyKt.lazy(() -> encoders.1.lazyVideo_delegate$lambda$4($receiver));
            }

            public boolean has(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return Codecs.access$getTracks$p(this.this$0).getAll().get(type) == TrackStatus.COMPRESSING;
            }

            private final Codec getLazyAudio() {
                Lazy lazy = this.lazyAudio$delegate;
                return (Codec)lazy.getValue();
            }

            private final Codec getLazyVideo() {
                Lazy lazy = this.lazyVideo$delegate;
                return (Codec)lazy.getValue();
            }

            public Codec get(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return switch (encoders.WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1 -> this.getLazyAudio();
                    case 2 -> this.getLazyVideo();
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public Codec getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            public Codec getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public Codec getOrNull(TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            public Codec videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            public Codec audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            public Iterator<Codec> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }

            private static final Codec lazyAudio_delegate$lambda$0(Codecs this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                MediaFormat format = Codecs.access$getTracks$p(this$0).getOutputFormats().getAudio();
                String string = format.getString("mime");
                Intrinsics.checkNotNull((Object)string);
                MediaCodec mediaCodec = MediaCodec.createEncoderByType((String)string);
                Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createEncoderByType(...)");
                MediaCodec codec = mediaCodec;
                codec.configure(format, null, null, 1);
                return new Codec(codec, null, null, 4, null);
            }

            private static final CharSequence lazyVideo_delegate$lambda$4$lambda$3(MediaCodecInfo it) {
                String string = it.getName();
                String[] stringArray = it.getSupportedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSupportedTypes(...)");
                return string + " (" + ArraysKt.joinToString$default((Object[])stringArray, null, null, null, (int)0, null, null, (int)63, null) + ")";
            }

            /*
             * Unable to fully structure code
             */
            private static final Codec lazyVideo_delegate$lambda$4(Codecs this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                format = Codecs.access$getTracks$p(this$0).getOutputFormats().getVideo();
                width = format.getInteger("width");
                height = format.getInteger("height");
                Codecs.access$getLog$p(this$0).i("Destination video surface size: " + width + "x" + height + " @ " + format.getInteger("rotation-degrees"));
                Codecs.access$getLog$p(this$0).i("Destination video format: " + format);
                allCodecs = new MediaCodecList(0);
                v0 = allCodecs.getCodecInfos();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getCodecInfos(...)");
                $this$filter$iv = v0;
                $i$f$filter = false;
                var8_8 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    block6: {
                        it = (MediaCodecInfo)element$iv$iv;
                        $i$a$-filter-Codecs$encoders$1$lazyVideo$2$videoEncoders$1 = false;
                        if (!it.isEncoder()) ** GOTO lbl-1000
                        v1 = it.getSupportedTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getSupportedTypes(...)");
                        $this$any$iv = v1;
                        $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            $i$a$-any-Codecs$encoders$1$lazyVideo$2$videoEncoders$1$1 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!StringsKt.startsWith$default((String)it, (String)"video/", (boolean)false, (int)2, null)) continue;
                            v2 = true;
                            break block6;
                        }
                        v2 = false;
                    }
                    if (v2) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                videoEncoders = (List)destination$iv$iv;
                Codecs.access$getLog$p(this$0).i("Available encoders: " + CollectionsKt.joinToString$default((Iterable)videoEncoders, null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lazyVideo_delegate$lambda$4$lambda$3(android.media.MediaCodecInfo ), (Landroid/media/MediaCodecInfo;)Ljava/lang/CharSequence;)(), (int)31, null));
                v4 = format.getString("mime");
                Intrinsics.checkNotNull((Object)v4);
                v5 = MediaCodec.createEncoderByType((String)v4);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"createEncoderByType(...)");
                codec = v5;
                codec.configure(format, null, null, 1);
                Codecs.access$getLog$p(this$0).i("Selected encoder " + codec.getName());
                v6 = codec.createInputSurface();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"createInputSurface(...)");
                surface = v6;
                Codecs.access$getLog$p(this$0).i("Creating OpenGL context on " + Thread.currentThread() + " (" + surface.isValid() + ")");
                eglContext = new EglCore(EGL14.EGL_NO_CONTEXT, 1);
                eglWindow = new EglWindowSurface(eglContext, surface, true);
                eglWindow.makeCurrent();
                var10_11 = TuplesKt.to((Object)eglWindow.getWidth(), (Object)eglWindow.getHeight());
                eglWidth = ((Number)var10_11.component1()).intValue();
                eglHeight = ((Number)var10_11.component2()).intValue();
                if (eglWidth != width || eglHeight != height) {
                    Codecs.access$getLog$p(this$0).e("OpenGL surface has wrong size (expected: " + width + "x" + height + ", found: " + eglWindow.getWidth() + "x" + eglWindow.getHeight() + ").");
                    if (Intrinsics.areEqual((Object)codec.getName(), (Object)"c2.android.avc.encoder") && eglWidth == 1 && eglHeight == 1) {
                        throw new IllegalStateException("c2.android.avc.encoder was unable to create the input surface (1x1).".toString());
                    }
                }
                return new Codec(codec, new Surface(eglContext, eglWindow), null, 4, null);
            }
        };
        this.ownsEncoderStart = new TrackMap<Boolean>(this){
            final /* synthetic */ Codecs this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean has(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            public Boolean get(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return ((Number)Codecs.access$getCurrent$p(this.this$0).get(type)).intValue() == 0;
            }

            public Boolean getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            public Boolean getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public Boolean getOrNull(TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            public Boolean videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            public Boolean audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            public Iterator<Boolean> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }
        };
        this.ownsEncoderStop = new TrackMap<Boolean>(this){
            final /* synthetic */ Codecs this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean has(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            public Boolean get(TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return ((Number)Codecs.access$getCurrent$p(this.this$0).get(type)).intValue() == CollectionsKt.getLastIndex((List)Codecs.access$getSources$p(this.this$0).get(type));
            }

            public Boolean getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            public Boolean getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public Boolean getOrNull(TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            public Boolean videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            public Boolean audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            public Iterator<Boolean> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }
        };
    }

    @NotNull
    public final TrackMap<Codec> getEncoders() {
        return this.encoders;
    }

    @NotNull
    public final TrackMap<Boolean> getOwnsEncoderStart() {
        return this.ownsEncoderStart;
    }

    @NotNull
    public final TrackMap<Boolean> getOwnsEncoderStop() {
        return this.ownsEncoderStop;
    }

    public final void release() {
        Iterable $this$forEach$iv = this.encoders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Codec it = (Codec)element$iv;
            boolean bl = false;
            Surface surface = it.getSurface();
            if (surface == null) continue;
            surface.release();
        }
    }

    public static final /* synthetic */ Tracks access$getTracks$p(Codecs $this) {
        return $this.tracks;
    }

    public static final /* synthetic */ Logger access$getLog$p(Codecs $this) {
        return $this.log;
    }

    public static final /* synthetic */ TrackMap access$getCurrent$p(Codecs $this) {
        return $this.current;
    }

    public static final /* synthetic */ DataSources access$getSources$p(Codecs $this) {
        return $this.sources;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0013\u0018\u00010%J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R+\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R+\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001a\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u0018R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R \u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00130%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/otaliastudios/transcoder/internal/Codecs$Codec;", "", "codec", "Landroid/media/MediaCodec;", "surface", "Lcom/otaliastudios/transcoder/internal/Codecs$Surface;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "<init>", "(Landroid/media/MediaCodec;Lcom/otaliastudios/transcoder/internal/Codecs$Surface;Lcom/otaliastudios/transcoder/internal/utils/Logger;)V", "getCodec", "()Landroid/media/MediaCodec;", "getSurface", "()Lcom/otaliastudios/transcoder/internal/Codecs$Surface;", "getLog", "()Lcom/otaliastudios/transcoder/internal/utils/Logger;", "setLog", "(Lcom/otaliastudios/transcoder/internal/utils/Logger;)V", "<set-?>", "", "dequeuedInputs", "getDequeuedInputs", "()I", "setDequeuedInputs", "(I)V", "dequeuedInputs$delegate", "Lkotlin/properties/ReadWriteProperty;", "dequeuedOutputs", "getDequeuedOutputs", "setDequeuedOutputs", "dequeuedOutputs$delegate", "state", "", "getState", "()Ljava/lang/String;", "heldInputs", "Lkotlin/collections/ArrayDeque;", "Lkotlin/Pair;", "Ljava/nio/ByteBuffer;", "getInputBuffer", "holdInputBuffer", "", "buffer", "id", "lib_release"})
    @SourceDebugExtension(value={"SMAP\nCodecs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Codecs.kt\ncom/otaliastudios/transcoder/internal/Codecs$Codec\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n33#2,3:146\n33#2,3:149\n1#3:152\n*S KotlinDebug\n*F\n+ 1 Codecs.kt\ncom/otaliastudios/transcoder/internal/Codecs$Codec\n*L\n41#1:146,3\n42#1:149,3\n*E\n"})
    public static final class Codec {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final MediaCodec codec;
        @Nullable
        private final Surface surface;
        @Nullable
        private Logger log;
        @NotNull
        private final ReadWriteProperty dequeuedInputs$delegate;
        @NotNull
        private final ReadWriteProperty dequeuedOutputs$delegate;
        @NotNull
        private final ArrayDeque<Pair<ByteBuffer, Integer>> heldInputs;

        public Codec(@NotNull MediaCodec codec, @Nullable Surface surface, @Nullable Logger log) {
            Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
            this.codec = codec;
            this.surface = surface;
            this.log = log;
            Delegates delegates = Delegates.INSTANCE;
            Integer initialValue$iv = 0;
            boolean $i$f$observable = false;
            this.dequeuedInputs$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, this){
                final /* synthetic */ Codec this$0;
                {
                    this.this$0 = codec;
                    super($initialValue);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                        ((Number)newValue).intValue();
                        ((Number)oldValue).intValue();
                        boolean bl = false;
                        Logger logger = this.this$0.getLog();
                        if (logger == null) break block0;
                        logger.v(this.this$0.getState());
                    }
                }
            };
            Delegates this_$iv = Delegates.INSTANCE;
            initialValue$iv = 0;
            $i$f$observable = false;
            this.dequeuedOutputs$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, this){
                final /* synthetic */ Codec this$0;
                {
                    this.this$0 = codec;
                    super($initialValue);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                        ((Number)newValue).intValue();
                        ((Number)oldValue).intValue();
                        boolean bl = false;
                        Logger logger = this.this$0.getLog();
                        if (logger == null) break block0;
                        logger.v(this.this$0.getState());
                    }
                }
            };
            this.heldInputs = new ArrayDeque();
        }

        public /* synthetic */ Codec(MediaCodec mediaCodec, Surface surface, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                surface = null;
            }
            if ((n & 4) != 0) {
                logger = null;
            }
            this(mediaCodec, surface, logger);
        }

        @NotNull
        public final MediaCodec getCodec() {
            return this.codec;
        }

        @Nullable
        public final Surface getSurface() {
            return this.surface;
        }

        @Nullable
        public final Logger getLog() {
            return this.log;
        }

        public final void setLog(@Nullable Logger logger) {
            this.log = logger;
        }

        public final int getDequeuedInputs() {
            return ((Number)this.dequeuedInputs$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
        }

        public final void setDequeuedInputs(int n) {
            this.dequeuedInputs$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
        }

        public final int getDequeuedOutputs() {
            return ((Number)this.dequeuedOutputs$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
        }

        public final void setDequeuedOutputs(int n) {
            this.dequeuedOutputs$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)n);
        }

        @NotNull
        public final String getState() {
            return "dequeuedInputs=" + this.getDequeuedInputs() + " dequeuedOutputs=" + this.getDequeuedOutputs() + " heldInputs=" + this.heldInputs.size();
        }

        @Nullable
        public final Pair<ByteBuffer, Integer> getInputBuffer() {
            Pair pair;
            if (!((Collection)this.heldInputs).isEmpty()) {
                Object object = this.heldInputs.removeFirst();
                Pair it = (Pair)object;
                boolean bl = false;
                Logger logger = this.log;
                if (logger != null) {
                    logger.v(this.getState());
                }
                return (Pair)object;
            }
            int id = this.codec.dequeueInputBuffer(100L);
            if (id >= 0) {
                int it = this.getDequeuedInputs();
                this.setDequeuedInputs(it + 1);
                ByteBuffer byteBuffer = this.codec.getInputBuffer(id);
                if (byteBuffer == null) {
                    boolean bl = false;
                    String string = "inputBuffer(" + id + ") should not be null.";
                    throw new IllegalStateException(string.toString());
                }
                ByteBuffer buf = byteBuffer;
                pair = TuplesKt.to((Object)buf, (Object)id);
            } else {
                Logger logger = this.log;
                if (logger != null) {
                    logger.i("buffer() failed with " + id + ". " + this.getState());
                }
                pair = null;
            }
            return pair;
        }

        public final void holdInputBuffer(@NotNull ByteBuffer buffer, int id) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.heldInputs.addLast((Object)TuplesKt.to((Object)buffer, (Object)id));
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Codec.class, "dequeuedInputs", "getDequeuedInputs()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Codec.class, "dequeuedOutputs", "getDequeuedOutputs()I", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/otaliastudios/transcoder/internal/Codecs$Surface;", "", "context", "Lcom/otaliastudios/opengl/core/EglCore;", "window", "Lcom/otaliastudios/opengl/surface/EglWindowSurface;", "<init>", "(Lcom/otaliastudios/opengl/core/EglCore;Lcom/otaliastudios/opengl/surface/EglWindowSurface;)V", "getWindow", "()Lcom/otaliastudios/opengl/surface/EglWindowSurface;", "release", "", "lib_release"})
    public static final class Surface {
        @NotNull
        private final EglCore context;
        @NotNull
        private final EglWindowSurface window;

        public Surface(@NotNull EglCore context, @NotNull EglWindowSurface window) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            this.context = context;
            this.window = window;
        }

        @NotNull
        public final EglWindowSurface getWindow() {
            return this.window;
        }

        public final void release() {
            this.window.release();
            this.context.release();
        }
    }
}

