/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.transcoder.TranscoderOptions;
import com.otaliastudios.transcoder.internal.transcode.TranscodeEngine;
import com.otaliastudios.transcoder.internal.utils.ThreadPool;
import com.otaliastudios.transcoder.sink.DataSink;
import java.io.FileDescriptor;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class Transcoder {
    public static final int SUCCESS_TRANSCODED = 0;
    public static final int SUCCESS_NOT_NEEDED = 1;

    @NonNull
    public static Transcoder getInstance() {
        return new Transcoder();
    }

    private Transcoder() {
    }

    @NonNull
    public static TranscoderOptions.Builder into(@NonNull String outPath) {
        return new TranscoderOptions.Builder(outPath);
    }

    @RequiresApi(api=26)
    @NonNull
    public static TranscoderOptions.Builder into(@NonNull FileDescriptor fileDescriptor) {
        return new TranscoderOptions.Builder(fileDescriptor);
    }

    @NonNull
    public static TranscoderOptions.Builder into(@NonNull DataSink dataSink) {
        return new TranscoderOptions.Builder(dataSink);
    }

    @NonNull
    public Future<Void> transcode(final @NonNull TranscoderOptions options) {
        return ThreadPool.getExecutor().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TranscodeEngine.transcode(options);
                return null;
            }
        });
    }
}

