/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.configuration;

import io.quarkus.debezium.configuration.DatasourceParser;
import io.quarkus.debezium.configuration.PostgresDatasourceConfiguration;
import io.quarkus.runtime.annotations.Recorder;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Recorder
public class DatasourceRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasourceRecorder.class);
    public static final String PREFIX = "quarkus.datasource";
    public static final String JDBC_URL = ".jdbc.url";
    public static final String USERNAME = ".username";
    public static final String PASSWORD = ".password";
    public static final String DOT = ".";

    public Supplier<PostgresDatasourceConfiguration> convert(String name, boolean defaultConfiguration) {
        if (defaultConfiguration) {
            LOGGER.trace("Extracting default configuration for data source {}", (Object)name);
            String jdbcUrl = ConfigProvider.getConfig().getConfigValue("quarkus.datasource.jdbc.url").getValue();
            String username = ConfigProvider.getConfig().getConfigValue("quarkus.datasource.username").getValue();
            String password = ConfigProvider.getConfig().getConfigValue("quarkus.datasource.password").getValue();
            return this.createConfiguration("default", jdbcUrl, username, password, true);
        }
        LOGGER.trace("Extracting datasource configuration for {}", (Object)name);
        String jdbcUrl = ConfigProvider.getConfig().getConfigValue("quarkus.datasource." + name + JDBC_URL).getValue();
        String username = ConfigProvider.getConfig().getConfigValue("quarkus.datasource." + name + USERNAME).getValue();
        String password = ConfigProvider.getConfig().getConfigValue("quarkus.datasource." + name + PASSWORD).getValue();
        if (jdbcUrl == null) {
            LOGGER.warn("JDBC URL is null");
            return null;
        }
        return this.createConfiguration(name, jdbcUrl, username, password, false);
    }

    private Supplier<PostgresDatasourceConfiguration> createConfiguration(String name, String jdbcUrl, String username, String password, boolean isDefault) {
        return () -> new DatasourceParser(jdbcUrl).asString().map(datasource -> new PostgresDatasourceConfiguration(datasource.host(), username, password, datasource.database(), datasource.port(), isDefault, name)).orElse(null);
    }
}

