/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.configuration;

import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.runtime.configuration.QuarkusDatasourceConfiguration;
import java.util.Map;

public class PostgresDatasourceConfiguration
implements QuarkusDatasourceConfiguration {
    private final String host;
    private final String username;
    private final String password;
    private final String database;
    private final String port;
    private final boolean isDefault;
    private final String name;

    public PostgresDatasourceConfiguration(String host, String username, String password, String database, String port, boolean isDefault, String name) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.database = database;
        this.port = port;
        this.isDefault = isDefault;
        this.name = name;
    }

    public Map<String, String> asDebezium() {
        return Map.of("name", this.name.replaceAll("[<>]", ""), "database." + JdbcConfiguration.HOSTNAME.name(), this.host, "database." + JdbcConfiguration.PORT.name(), this.port, "database." + JdbcConfiguration.USER.name(), this.username, "database." + JdbcConfiguration.PASSWORD.name(), this.password, "database." + JdbcConfiguration.DATABASE.name(), this.database);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getName() {
        return this.name;
    }

    public String getSanitizedName() {
        return this.name.replaceAll("[<>]", "");
    }
}

