/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.embedded.EmbeddedEngineConfig;
import io.debezium.engine.RecordChangeEvent;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.runtime.Connector;
import io.debezium.runtime.ConnectorProducer;
import io.debezium.runtime.Debezium;
import io.debezium.runtime.configuration.DebeziumEngineConfiguration;
import io.quarkus.debezium.configuration.PostgresDatasourceConfiguration;
import io.quarkus.debezium.engine.SourceRecordDebezium;
import io.quarkus.debezium.engine.StateHandler;
import io.quarkus.debezium.engine.capture.CapturingInvokerRegistry;
import io.quarkus.debezium.notification.QuarkusNotificationChannel;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;

@ApplicationScoped
public class PostgresEngineProducer
implements ConnectorProducer {
    public static final Connector POSTGRES = new Connector(PostgresConnector.class.getName());
    public static final String DEBEZIUM_DATASOURCE_HOSTNAME = "database." + JdbcConfiguration.HOSTNAME.name();
    private final CapturingInvokerRegistry<RecordChangeEvent<SourceRecord>> registry;
    private final StateHandler stateHandler;
    private final Instance<PostgresDatasourceConfiguration> configurations;
    private final QuarkusNotificationChannel channel;

    @Inject
    public PostgresEngineProducer(CapturingInvokerRegistry<RecordChangeEvent<SourceRecord>> registry, StateHandler stateHandler, Instance<PostgresDatasourceConfiguration> configurations, QuarkusNotificationChannel channel) {
        this.registry = registry;
        this.stateHandler = stateHandler;
        this.configurations = configurations;
        this.channel = channel;
    }

    @Produces
    @Singleton
    public Debezium engine(DebeziumEngineConfiguration debeziumEngineConfiguration) {
        Map configurationMap = debeziumEngineConfiguration.configuration();
        configurationMap.compute(CommonConnectorConfig.NOTIFICATION_ENABLED_CHANNELS.name(), (key, value) -> value == null ? this.channel.name() : value.concat("," + this.channel.name()));
        configurationMap.put(EmbeddedEngineConfig.CONNECTOR_CLASS.name(), POSTGRES.name());
        if (configurationMap.get(DEBEZIUM_DATASOURCE_HOSTNAME) != null) {
            return new SourceRecordDebezium(configurationMap, this.stateHandler, POSTGRES, this.registry);
        }
        configurationMap.putAll(this.configurations.stream().findFirst().map(PostgresDatasourceConfiguration::asDebezium).orElse(Collections.emptyMap()));
        return new SourceRecordDebezium(configurationMap, this.stateHandler, POSTGRES, this.registry);
    }
}

