/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sample.app.resources;

import io.quarkus.sample.app.services.OrderService;
import io.quarkus.sample.app.services.ProductService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;

@Path(value="/captured")
@ApplicationScoped
public class CapturingResource {
    private final ProductService productService;
    private final OrderService orderService;

    public CapturingResource(ProductService productService, OrderService orderService) {
        this.productService = productService;
        this.orderService = orderService;
    }

    @GET
    @Path(value="all")
    public Response captured() {
        if (this.productService.isInvoked()) {
            return Response.status((Response.Status)Response.Status.FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="products")
    public Response products() {
        if (this.productService.products().isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.productService.products()).build();
    }

    @GET
    @Path(value="orders")
    public Response orders() {
        if (this.orderService.orders().isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(this.orderService.orders()).build();
    }
}

