/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sample.app.services;

import io.debezium.runtime.Capturing;
import io.debezium.runtime.CapturingEvent;
import io.quarkus.sample.app.dto.Order;
import io.quarkus.sample.app.dto.Product;
import io.quarkus.sample.app.services.OrderService;
import io.quarkus.sample.app.services.ProductService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CaptureHandler {
    private final ProductService productService;
    private final OrderService orderService;
    private final Logger logger = LoggerFactory.getLogger(CaptureHandler.class);

    @Inject
    public CaptureHandler(ProductService productService, OrderService orderService) {
        this.productService = productService;
        this.orderService = orderService;
    }

    @Capturing
    public void capture(CapturingEvent<SourceRecord> event) {
        this.productService.captured();
    }

    @Capturing(destination="dbserver1.public.products")
    public void products(CapturingEvent<Product> event) {
        this.logger.info("getting a product event for destination {} from capturing id {}", (Object)event.destination(), (Object)event.engine());
        this.productService.add((Product)event.record());
    }

    @Capturing(destination="dbserver2.public.orders", engine="alternative")
    public void orders(CapturingEvent<Order> event) {
        this.logger.info("getting a order event for destination {} from capturing id {}", (Object)event.destination(), (Object)event.engine());
        this.orderService.add((Order)event.record());
    }
}

