/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventMetadata;
import com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.TableMapEventMetadataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TableMapEventDataDeserializer
implements EventDataDeserializer<TableMapEventData> {
    private final TableMapEventMetadataDeserializer metadataDeserializer = new TableMapEventMetadataDeserializer();

    @Override
    public TableMapEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        TableMapEventData eventData = new TableMapEventData();
        eventData.setTableId(inputStream.readLong(6));
        inputStream.skip(3L);
        eventData.setDatabase(inputStream.readZeroTerminatedString());
        inputStream.skip(1L);
        eventData.setTable(inputStream.readZeroTerminatedString());
        int numberOfColumns = inputStream.readPackedInteger();
        eventData.setColumnTypes(inputStream.read(numberOfColumns));
        inputStream.readPackedInteger();
        eventData.setColumnMetadata(this.readMetadata(inputStream, eventData.getColumnTypes()));
        eventData.setColumnNullability(inputStream.readBitSet(numberOfColumns, true));
        int metadataLength = inputStream.available();
        TableMapEventMetadata metadata = null;
        if (metadataLength > 0) {
            metadata = this.metadataDeserializer.deserialize(new ByteArrayInputStream(inputStream.read(metadataLength)), eventData.getColumnTypes().length, eventData.getColumnTypes());
        }
        eventData.setEventMetadata(metadata);
        return eventData;
    }

    private List<Integer> numericColumnIndex(byte[] types) {
        ArrayList<Integer> numericColumnIndexList = new ArrayList<Integer>();
        int i = 0;
        while (i < types.length) {
            switch (ColumnType.byCode(types[i] & 0xFF)) {
                case TINY: 
                case SHORT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case LONGLONG: 
                case INT24: 
                case YEAR: 
                case NEWDECIMAL: {
                    numericColumnIndexList.add(i);
                    break;
                }
            }
            ++i;
        }
        return numericColumnIndexList;
    }

    private int numericColumnCount(byte[] types) {
        int count = 0;
        int i = 0;
        while (i < types.length) {
            switch (ColumnType.byCode(types[i] & 0xFF)) {
                case TINY: 
                case SHORT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case LONGLONG: 
                case INT24: 
                case YEAR: 
                case NEWDECIMAL: {
                    ++count;
                    break;
                }
            }
            ++i;
        }
        return count;
    }

    private int[] readMetadata(ByteArrayInputStream inputStream, byte[] columnTypes) throws IOException {
        int[] metadata = new int[columnTypes.length];
        int i = 0;
        while (i < columnTypes.length) {
            switch (ColumnType.byCode(columnTypes[i] & 0xFF)) {
                case FLOAT: 
                case DOUBLE: 
                case VECTOR: 
                case JSON: 
                case BLOB: 
                case GEOMETRY: {
                    metadata[i] = inputStream.readInteger(1);
                    break;
                }
                case VARCHAR: 
                case BIT: 
                case NEWDECIMAL: {
                    metadata[i] = inputStream.readInteger(2);
                    break;
                }
                case ENUM: 
                case SET: 
                case STRING: {
                    metadata[i] = TableMapEventDataDeserializer.bigEndianInteger(inputStream.read(2), 0, 2);
                    break;
                }
                case TIMESTAMP_V2: 
                case DATETIME_V2: 
                case TIME_V2: {
                    metadata[i] = inputStream.readInteger(1);
                    break;
                }
                default: {
                    metadata[i] = 0;
                }
            }
            ++i;
        }
        return metadata;
    }

    private static int bigEndianInteger(byte[] bytes, int offset, int length) {
        int result = 0;
        int i = offset;
        while (i < offset + length) {
            int b = bytes[i];
            result = result << 8 | (b >= 0 ? b : b + 256);
            ++i;
        }
        return result;
    }
}

