/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.PreviousGtidSetEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;

public class PreviousGtidSetDeserializer
implements EventDataDeserializer<PreviousGtidSetEventData> {
    @Override
    public PreviousGtidSetEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        int nUuids = inputStream.readInteger(8);
        String[] gtids = new String[nUuids];
        int i = 0;
        while (i < nUuids) {
            String uuid = this.formatUUID(inputStream.read(16));
            int nIntervals = inputStream.readInteger(8);
            String[] intervals = new String[nIntervals];
            int j = 0;
            while (j < nIntervals) {
                long start = inputStream.readLong(8);
                long end = inputStream.readLong(8);
                intervals[j] = String.valueOf(start) + "-" + (end - 1L);
                ++j;
            }
            gtids[i] = String.format("%s:%s", uuid, PreviousGtidSetDeserializer.join(intervals, ":"));
            ++i;
        }
        return new PreviousGtidSetEventData(PreviousGtidSetDeserializer.join(gtids, ","));
    }

    private String formatUUID(byte[] bytes) {
        return String.format("%s-%s-%s-%s-%s", PreviousGtidSetDeserializer.byteArrayToHex(bytes, 0, 4), PreviousGtidSetDeserializer.byteArrayToHex(bytes, 4, 2), PreviousGtidSetDeserializer.byteArrayToHex(bytes, 6, 2), PreviousGtidSetDeserializer.byteArrayToHex(bytes, 8, 2), PreviousGtidSetDeserializer.byteArrayToHex(bytes, 10, 6));
    }

    private static String byteArrayToHex(byte[] a, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        int idx = offset;
        while (idx < offset + len && idx < a.length) {
            sb.append(String.format("%02x", a[idx] & 0xFF));
            ++idx;
        }
        return sb.toString();
    }

    private static String join(String[] values, String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(values[i]);
            ++i;
        }
        return sb.toString();
    }
}

