/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryLogDatabaseVersion {
    private static final Pattern VERSION = Pattern.compile("([0-9]*).([0-9]*).*");
    private final int major;
    private final int minor;
    private final String serverVersion;
    private final boolean mariaDb;

    public BinaryLogDatabaseVersion(String serverVersion) {
        this(-1, -1, serverVersion);
    }

    public BinaryLogDatabaseVersion(int major, int minor, String serverVersion) {
        this.major = major;
        this.minor = minor;
        this.serverVersion = serverVersion;
        this.mariaDb = serverVersion != null && serverVersion.toLowerCase().contains("mariadb");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean isMariaDb() {
        return this.mariaDb;
    }

    public boolean isGreaterThan(int major, int minor) {
        return this.major > major || this.major == major && this.minor > minor;
    }

    public boolean isEqualTo(int major, int minor) {
        return this.major == major && this.minor == minor;
    }

    public boolean isGreaterThanOrEqualTo(int major, int minor) {
        return this.isGreaterThan(major, minor) || this.isEqualTo(major, minor);
    }

    public String toString() {
        return String.valueOf(this.serverVersion) + " (major=" + this.major + ", minor=" + this.minor + ", mariadb=" + this.mariaDb + ")";
    }

    public static BinaryLogDatabaseVersion parse(String serverVersion) {
        if (serverVersion == null) {
            return new BinaryLogDatabaseVersion(serverVersion);
        }
        Matcher matcher = VERSION.matcher(serverVersion);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            return new BinaryLogDatabaseVersion(major, minor, serverVersion);
        }
        return new BinaryLogDatabaseVersion(serverVersion);
    }
}

