/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import io.debezium.testing.testcontainers.SchemaRegistryContainer;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerImageName;

public class SchemaRegistryTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRegistryTestResourceLifecycleManager.class);
    private static final String defaultImage = "quay.io/debezium/confluentinc-cp-kafka:7.2.10";
    private static final Network network = Network.newNetwork();
    private static final Integer PORT = 8081;
    public static KafkaContainer kafkaContainer = (KafkaContainer)new KafkaContainer(DockerImageName.parse((String)"quay.io/debezium/confluentinc-cp-kafka:7.2.10").asCompatibleSubstituteFor("confluentinc/cp-kafka")).withNetwork(network);
    private static final SchemaRegistryContainer schemaRegistryContainer = (SchemaRegistryContainer)((SchemaRegistryContainer)((SchemaRegistryContainer)((SchemaRegistryContainer)new SchemaRegistryContainer().withNetwork(network)).withKafka(kafkaContainer).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).dependsOn(new Startable[]{kafkaContainer})).withStartupTimeout(Duration.ofSeconds(90L));

    public Map<String, String> start() {
        Startables.deepStart(Stream.of(new GenericContainer[]{kafkaContainer, schemaRegistryContainer})).join();
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.format.schema.registry.url", SchemaRegistryTestResourceLifecycleManager.getSchemaRegistryUrl());
        return params;
    }

    public void stop() {
        try {
            if (schemaRegistryContainer != null) {
                schemaRegistryContainer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getSchemaRegistryUrl() {
        return "http://" + schemaRegistryContainer.getHost() + ":" + schemaRegistryContainer.getMappedPort(PORT);
    }
}

