/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.util;

import io.debezium.testing.testcontainers.util.dns.FakeDns;
import java.net.InetAddress;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class DockerUtils {
    public static final String CONTAINER_VM_LOG_SKIP = "container.vm.log.skip";
    public static final String CONTAINER_VM_FAKE_DNS = "container.vm.fake.dns";

    public static boolean isContainerVM() {
        String property = System.getProperty(CONTAINER_VM_FAKE_DNS, "auto");
        return property.equals("true") || property.equals("auto") && DockerUtils.isMac();
    }

    public static boolean isMac() {
        return System.getProperty("os.name").contains("Mac");
    }

    public static void logContainerVMBanner(Logger logger, Collection<String> hosts, boolean skip) {
        String prop = System.getProperty(CONTAINER_VM_LOG_SKIP, "false");
        boolean propertySkip = Boolean.parseBoolean(prop);
        if (propertySkip || skip || !DockerUtils.isContainerVM() || FakeDns.getInstance().isEnabled()) {
            return;
        }
        String newLine = "\n> ";
        String doubleNewLine = "\n> ".repeat(2);
        String hostEntries = hosts.stream().map(host -> "127.0.0.1 " + host).collect(Collectors.joining("\n> "));
        StringBuilder banner = new StringBuilder().append("\n>>> VM BASED CONTAINER RUNTIME DETECTED <<<").append(doubleNewLine).append("Requires the following entries in /etc/hosts or equivalent of your platform").append(doubleNewLine).append(hostEntries).append("\n> ").append("\n>>> Missing entries will likely lead to failures");
        logger.warn(banner.toString());
    }

    public static void enableFakeDnsIfRequired() {
        if (DockerUtils.isContainerVM()) {
            FakeDns.getInstance().enable();
        }
    }

    public static void disableFakeDns() {
        FakeDns.getInstance().disable();
    }

    public static void addFakeDnsEntry(String hostname) {
        DockerUtils.addFakeDnsEntry(hostname, InetAddress.getLoopbackAddress());
    }

    public static void addFakeDnsEntry(String hostname, InetAddress address) {
        if (FakeDns.getInstance().isEnabled()) {
            FakeDns.getInstance().addResolution(hostname, address);
        }
    }

    public static void removeFakeDnsEntry(String hostname) {
        DockerUtils.removeFakeDnsEntry(hostname, InetAddress.getLoopbackAddress());
    }

    public static void removeFakeDnsEntry(String hostname, InetAddress address) {
        if (FakeDns.getInstance().isEnabled()) {
            FakeDns.getInstance().removeResolution(hostname, address);
        }
    }

    private DockerUtils() {
        throw new AssertionError((Object)"Should not be instantiated");
    }
}

