/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class PostgresTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    public static final String POSTGRES_USER = "postgres";
    public static final String POSTGRES_PASSWORD = "postgres";
    public static final String POSTGRES_DBNAME = "postgres";
    public static final String POSTGRES_IMAGE = "debezium/example-postgres";
    public static final String POSTGRES_HOST = "localhost";
    public static final Integer POSTGRES_PORT = 5432;
    private final GenericContainer<?> container = new GenericContainer("debezium/example-postgres").waitingFor((WaitStrategy)Wait.forLogMessage((String)".*database system is ready to accept connections.*", (int)2)).withEnv("POSTGRES_USER", "postgres").withEnv("POSTGRES_PASSWORD", "postgres").withEnv("POSTGRES_DB", "postgres").withEnv("POSTGRES_INITDB_ARGS", "-E UTF8").withEnv("LANG", "en_US.utf8").withExposedPorts(new Integer[]{POSTGRES_PORT}).withStartupTimeout(Duration.ofSeconds(30L));

    public Map<String, String> start() {
        this.container.start();
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.source.database.hostname", POSTGRES_HOST);
        params.put("debezium.source.database.port", this.container.getMappedPort(POSTGRES_PORT.intValue()).toString());
        params.put("debezium.source.database.user", "postgres");
        params.put("debezium.source.database.password", "postgres");
        params.put("debezium.source.database.dbname", "postgres");
        return params;
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

